/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.game;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.game.ItemSpawnerType;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.nms.holograms.Hologram;

public class ItemSpawner
implements org.screamingsandals.bedwars.api.game.ItemSpawner {
    public Location loc;
    @Nullable
    public String declaredSpawnerType;
    public ItemSpawnerType type;
    public String customName;
    public double startLevel;
    public double currentLevel;
    public int maxSpawnedResources;
    public boolean hologramEnabled;
    public Team team;
    public List<Item> spawnedItems;
    public boolean spawnerIsFullHologram = false;
    public boolean rerenderHologram = false;
    public double currentLevelOnHologram = -1.0;
    public boolean spawnerLockedFull;
    public int countdownDelay;
    public int currentCycle;

    public ItemSpawner(Location loc, ItemSpawnerType type, String customName, boolean hologramEnabled, double startLevel, Team team, int maxSpawnedResources) {
        this.loc = loc;
        this.type = type;
        this.customName = customName;
        this.currentLevel = this.startLevel = startLevel;
        this.hologramEnabled = hologramEnabled;
        this.team = team;
        this.spawnedItems = new ArrayList<Item>();
        this.maxSpawnedResources = maxSpawnedResources;
    }

    @Override
    public org.screamingsandals.bedwars.api.game.ItemSpawnerType getItemSpawnerType() {
        return this.type;
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public double getStartLevel() {
        return this.startLevel;
    }

    @Override
    public double getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public boolean getHologramEnabled() {
        return this.hologramEnabled;
    }

    @Override
    public void setCurrentLevel(double level) {
        this.currentLevel = level;
    }

    @Override
    public Team getTeam() {
        return this.team;
    }

    @Override
    public void setTeam(Team team) {
        this.team = team;
    }

    public int getMaxSpawnedResources() {
        return this.maxSpawnedResources;
    }

    public int nextMaxSpawn(int calculated, Hologram countdown) {
        if (this.currentLevel <= 0.0) {
            if (!(countdown == null || this.spawnerIsFullHologram && this.currentLevelOnHologram == this.currentLevel)) {
                this.spawnerIsFullHologram = true;
                this.currentLevelOnHologram = this.currentLevel;
                countdown.setLine(1, I.i18nonly("spawner_not_enough_level").replace("%levels%", String.valueOf(this.currentLevelOnHologram * -1.0 + 1.0)));
            }
            return 0;
        }
        if (this.maxSpawnedResources <= 0) {
            if (this.spawnerIsFullHologram && !this.rerenderHologram) {
                this.spawnerIsFullHologram = false;
                this.rerenderHologram = true;
            }
            return calculated;
        }
        this.flushDeathItems();
        int spawned = this.getSpawnedItemsCount();
        if (spawned >= this.maxSpawnedResources) {
            this.spawnerLockedFull = true;
            if (countdown != null && !this.spawnerIsFullHologram) {
                this.spawnerIsFullHologram = true;
                countdown.setLine(1, I.i18nonly("spawner_is_full"));
            }
            return 0;
        }
        if (this.maxSpawnedResources - spawned >= calculated) {
            if (this.spawnerIsFullHologram && !this.rerenderHologram) {
                this.rerenderHologram = true;
                this.spawnerIsFullHologram = false;
            } else if (calculated + spawned == this.maxSpawnedResources) {
                this.spawnerLockedFull = true;
                if (countdown != null) {
                    this.spawnerIsFullHologram = true;
                    countdown.setLine(1, I.i18nonly("spawner_is_full"));
                }
            }
            return calculated;
        }
        this.spawnerLockedFull = true;
        if (countdown != null && !this.spawnerIsFullHologram) {
            this.spawnerIsFullHologram = true;
            countdown.setLine(1, I.i18nonly("spawner_is_full"));
        }
        return this.maxSpawnedResources - spawned;
    }

    public void add(Item item) {
        if (this.maxSpawnedResources > 0 && !this.spawnedItems.contains(item)) {
            this.spawnedItems.add(item);
        }
    }

    public void remove(Item item) {
        if (this.maxSpawnedResources > 0 && this.spawnedItems.contains(item)) {
            this.spawnedItems.remove(item);
            if (this.spawnerIsFullHologram && this.maxSpawnedResources > this.getSpawnedItemsCount()) {
                this.spawnerIsFullHologram = false;
                this.rerenderHologram = true;
            }
        }
    }

    public void flushDeathItems() {
        this.spawnedItems.removeIf(Entity::isDead);
    }

    public int getSpawnedItemsCount() {
        return this.spawnedItems.stream().mapToInt(i -> i.getItemStack().getAmount()).sum();
    }
}

