/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.game;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.screamingsandals.bedwars.lib.lang.I18n;

public class ItemSpawnerType
implements org.screamingsandals.bedwars.api.game.ItemSpawnerType {
    private String configKey;
    private String name;
    private String translatableKey;
    private double spread;
    private Material material;
    private ChatColor color;
    private int interval;
    private int damage;

    public ItemSpawnerType(String configKey, String name, String translatableKey, double spread, Material material, ChatColor color, int interval, int damage) {
        this.configKey = configKey;
        this.name = name;
        this.translatableKey = translatableKey;
        this.spread = spread;
        this.material = material;
        this.color = color;
        this.interval = interval;
        this.damage = damage;
    }

    @Override
    public String getConfigKey() {
        return this.configKey;
    }

    @Override
    public ChatColor getColor() {
        return this.color;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public double getSpread() {
        return this.spread;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public String getTranslatableKey() {
        if (this.translatableKey != null && !this.translatableKey.equals("")) {
            return I18n.i18n(this.translatableKey, this.name, false);
        }
        return this.name;
    }

    @Override
    public String getItemName() {
        return this.color + this.getTranslatableKey();
    }

    @Override
    public String getItemBoldName() {
        return this.color.toString() + ChatColor.BOLD.toString() + this.getTranslatableKey();
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public ItemStack getStack() {
        return this.getStack(1);
    }

    @Override
    public ItemStack getStack(int amount) {
        ItemStack stack = new ItemStack(this.material, amount, (short)this.damage);
        ItemMeta stackMeta = stack.getItemMeta();
        stackMeta.setDisplayName(this.getItemName());
        stack.setItemMeta(stackMeta);
        return stack;
    }
}

