/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.game;

import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class RespawnProtection
extends BukkitRunnable {
    private Game game;
    private Player player;
    private int length;
    private boolean running = true;

    public RespawnProtection(Game game, Player player, int seconds) {
        this.game = game;
        this.player = player;
        this.length = seconds;
    }

    public void run() {
        if (!this.running) {
            return;
        }
        if (this.length > 0 && Main.getConfigurator().config.getBoolean("respawn.show-messages")) {
            MiscUtils.sendActionBarMessage(this.player, I18n.i18nonly("respawn_protection_remaining").replace("%time%", Integer.toString(this.length)));
        }
        if (this.length <= 0) {
            if (Main.getConfigurator().config.getBoolean("respawn.show-messages")) {
                MiscUtils.sendActionBarMessage(this.player, I18n.i18nonly("respawn_protection_end"));
            }
            this.game.removeProtectedPlayer(this.player);
            this.running = false;
        }
        --this.length;
    }

    public void runProtection() {
        this.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 5L, 20L);
    }
}

