/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.holograms;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.statistics.LeaderboardEntry;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.nms.holograms.Hologram;
import org.screamingsandals.bedwars.lib.nms.holograms.TouchHandler;

public class LeaderboardHolograms
implements TouchHandler {
    private ArrayList<Location> hologramLocations;
    private Map<Location, Hologram> holograms;
    private List<LeaderboardEntry> entries;

    public void addHologramLocation(Location eyeLocation) {
        this.hologramLocations.add(eyeLocation.subtract(0.0, 3.0, 0.0));
        this.updateHologramDatabase();
        if (this.entries == null) {
            this.updateEntries();
        } else {
            this.updateHolograms();
        }
    }

    public void updateEntries() {
        if (this.hologramLocations == null || this.hologramLocations.isEmpty()) {
            return;
        }
        this.entries = Main.getPlayerStatisticsManager().getLeaderboard(Main.getConfigurator().config.getInt("holograms.leaderboard.size"));
        this.updateHolograms();
    }

    public void loadHolograms() {
        if (!Main.isHologramsEnabled()) {
            return;
        }
        if (this.hologramLocations != null || this.holograms != null) {
            this.unloadHolograms();
        }
        this.holograms = new HashMap<Location, Hologram>();
        this.hologramLocations = new ArrayList();
        File file = new File(Main.getInstance().getDataFolder(), "holodb_leaderboard.yml");
        if (file.exists()) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                List locations = (List)config.get("locations");
                if (locations != null) {
                    if (locations.removeIf(location -> location.getWorld() == null)) {
                        Main.getInstance().getLogger().warning("There are holograms in " + file.getAbsolutePath() + " with location in unknown world! They were removed from the configuration");
                    }
                    this.hologramLocations.addAll(locations);
                }
            }
            catch (Throwable t) {
                Main.getInstance().getLogger().severe("Failed to load holograms from " + file.getAbsolutePath());
                t.printStackTrace();
            }
        }
        if (this.hologramLocations.isEmpty()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), this::updateEntries);
    }

    private void updateHologramDatabase() {
        try {
            File file = new File(Main.getInstance().getDataFolder(), "holodb_leaderboard.yml");
            YamlConfiguration config = new YamlConfiguration();
            if (!file.exists()) {
                file.createNewFile();
            }
            config.set("locations", this.hologramLocations);
            config.save(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void unloadHolograms() {
        if (Main.isHologramsEnabled()) {
            for (Hologram holo : this.holograms.values()) {
                holo.destroy();
            }
            this.holograms.clear();
        }
    }

    public void addViewer(Player player) {
        this.holograms.values().forEach(hologram -> {
            if (!hologram.getViewers().contains(player)) {
                Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> hologram.addViewer(player), 10L);
            }
        });
    }

    private void updateHolograms() {
        this.hologramLocations.forEach(location -> {
            if (!this.holograms.containsKey(location)) {
                this.holograms.put((Location)location, Main.getHologramManager().spawnHologramTouchable((Location)location, new String[0]));
                this.holograms.get(location).addHandler(this);
            }
            this.updateHologram(this.holograms.get(location));
        });
        Bukkit.getOnlinePlayers().forEach(this::addViewer);
    }

    private void updateHologram(Hologram holo) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getConfigurator().config.getString("holograms.leaderboard.headline")));
        String line = ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getConfigurator().config.getString("holograms.leaderboard.format"));
        if (this.entries == null || this.entries.isEmpty()) {
            lines.add(I.i18nonly("leaderboard_no_scores"));
        } else {
            AtomicInteger l = new AtomicInteger(1);
            this.entries.forEach(leaderboardEntry -> lines.add(line.replace("%name%", leaderboardEntry.getPlayer().getName() != null ? leaderboardEntry.getPlayer().getName() : (leaderboardEntry.getLatestKnownName() != null ? leaderboardEntry.getLatestKnownName() : leaderboardEntry.getPlayer().getUniqueId().toString())).replace("%score%", Integer.toString(leaderboardEntry.getTotalScore())).replace("%order%", Integer.toString(l.getAndIncrement()))));
        }
        for (int i = 0; i < lines.size(); ++i) {
            holo.setLine(i, (String)lines.get(i));
        }
    }

    @Override
    public void handle(Player player, Hologram hologram) {
        if (!player.hasMetadata("bw-remove-holo") || !player.isOp() && !BaseCommand.hasPermission((CommandSender)player, BaseCommand.ADMIN_PERMISSION, false)) {
            return;
        }
        player.removeMetadata("bw-remove-holo", (Plugin)Main.getInstance());
        Main.getInstance().getServer().getScheduler().runTask((Plugin)Main.getInstance(), () -> {
            hologram.destroy();
            new ArrayList<Location>(this.hologramLocations).forEach(location -> {
                if (hologram.getLocation().getX() == location.getX() && hologram.getLocation().getY() == location.getY() && hologram.getLocation().getZ() == location.getZ()) {
                    this.hologramLocations.remove(location);
                    this.holograms.remove(location);
                    this.updateHologramDatabase();
                }
            });
            player.sendMessage(I.i18n("holo_removed"));
        });
    }
}

