/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.holograms;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.lib.nms.holograms.Hologram;
import org.screamingsandals.bedwars.lib.nms.holograms.TouchHandler;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;

public class StatisticsHolograms
implements TouchHandler {
    private ArrayList<Location> hologramLocations = null;
    private Map<UUID, List<Hologram>> holograms = null;

    public void addHologramLocation(Location eyeLocation) {
        this.hologramLocations.add(eyeLocation.subtract(0.0, 3.0, 0.0));
        this.updateHologramDatabase();
    }

    public void loadHolograms() {
        if (!Main.isHologramsEnabled()) {
            return;
        }
        if (this.holograms != null && this.hologramLocations != null) {
            this.unloadHolograms();
        }
        this.holograms = new HashMap<UUID, List<Hologram>>();
        this.hologramLocations = new ArrayList();
        File file = new File(Main.getInstance().getDataFolder(), "holodb.yml");
        if (file.exists()) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                List locations = (List)config.get("locations");
                if (locations != null) {
                    if (locations.removeIf(location -> location.getWorld() == null)) {
                        Main.getInstance().getLogger().warning("There are holograms in " + file.getAbsolutePath() + " with location in unknown world! They were removed from the configuration");
                    }
                    this.hologramLocations.addAll(locations);
                }
            }
            catch (Throwable t) {
                Main.getInstance().getLogger().severe("Failed to load holograms from " + file.getAbsolutePath());
                t.printStackTrace();
            }
        }
        if (this.hologramLocations.isEmpty()) {
            return;
        }
        this.updateHolograms();
    }

    public void unloadHolograms() {
        if (Main.isHologramsEnabled()) {
            for (List<Hologram> holos : this.holograms.values()) {
                for (Hologram holo : holos) {
                    holo.destroy();
                }
            }
        }
    }

    public void updateHolograms(Player player) {
        Main.getInstance().getServer().getScheduler().runTask((Plugin)Main.getInstance(), () -> {
            for (Location holoLocation : this.hologramLocations) {
                this.updatePlayerHologram(player, holoLocation);
            }
        });
    }

    public void updateHolograms(Player player, long delay) {
        Main.getInstance().getServer().getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> this.updateHolograms(player), delay);
    }

    public void cleanupPlayerLeave(OfflinePlayer player) {
        List<Hologram> holos = this.holograms.get(player.getUniqueId());
        if (holos != null) {
            holos.forEach(holo -> holo.destroy());
            holos.clear();
            this.holograms.remove(player.getUniqueId());
        }
    }

    public void updateHolograms() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            Main.getInstance().getServer().getScheduler().runTask((Plugin)Main.getInstance(), () -> {
                for (Location holoLocation : this.hologramLocations) {
                    this.updatePlayerHologram(player, holoLocation);
                }
            });
        }
    }

    private Hologram getHologramByLocation(List<Hologram> holograms, Location holoLocation) {
        for (Hologram holo : holograms) {
            if (holo.getLocation().getX() != holoLocation.getX() || holo.getLocation().getY() != holoLocation.getY() || holo.getLocation().getZ() != holoLocation.getZ()) continue;
            return holo;
        }
        return null;
    }

    public void updatePlayerHologram(Player player, Location holoLocation) {
        List<Hologram> holograms;
        Hologram holo;
        if (!this.holograms.containsKey(player.getUniqueId())) {
            this.holograms.put(player.getUniqueId(), new ArrayList());
        }
        if ((holo = this.getHologramByLocation(holograms = this.holograms.get(player.getUniqueId()), holoLocation)) == null && player.getWorld() == holoLocation.getWorld()) {
            holograms.add(this.createPlayerStatisticHologram(player, holoLocation));
        } else if (holo != null) {
            if (holo.getLocation().getWorld() == player.getWorld()) {
                this.updatePlayerStatisticHologram(player, holo);
            } else {
                holograms.remove(holo);
                holo.destroy();
            }
        }
    }

    private Hologram createPlayerStatisticHologram(Player player, Location holoLocation) {
        Hologram holo = Main.getHologramManager().spawnHologramTouchable(player, holoLocation, new String[0]);
        holo.addHandler(this);
        String headline = ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getConfigurator().config.getString("holograms.headline", "Your &eBEDWARS&f stats"));
        if (!headline.trim().isEmpty()) {
            holo.addLine(headline);
        }
        this.updatePlayerStatisticHologram(player, holo);
        return holo;
    }

    private void updateHologramDatabase() {
        try {
            File file = new File(Main.getInstance().getDataFolder(), "holodb.yml");
            YamlConfiguration config = new YamlConfiguration();
            if (!file.exists()) {
                file.createNewFile();
            }
            config.set("locations", this.hologramLocations);
            config.save(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Location getHologramLocationByLocation(Location holoLocation) {
        for (Location loc : this.hologramLocations) {
            if (loc.getX() != holoLocation.getX() || loc.getY() != holoLocation.getY() || loc.getZ() != holoLocation.getZ()) continue;
            return loc;
        }
        return null;
    }

    @Override
    public void handle(Player player, Hologram holo) {
        if (!player.hasMetadata("bw-remove-holo") || !player.isOp() && !BaseCommand.hasPermission((CommandSender)player, BaseCommand.ADMIN_PERMISSION, false)) {
            return;
        }
        player.removeMetadata("bw-remove-holo", (Plugin)Main.getInstance());
        Main.getInstance().getServer().getScheduler().runTask((Plugin)Main.getInstance(), () -> {
            for (Map.Entry<UUID, List<Hologram>> entry : this.holograms.entrySet()) {
                Iterator<Hologram> iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    Hologram hologram = iterator.next();
                    if (hologram.getLocation().getX() != holo.getLocation().getX() || hologram.getLocation().getY() != holo.getLocation().getY() || hologram.getLocation().getZ() != holo.getLocation().getZ()) continue;
                    hologram.destroy();
                    iterator.remove();
                }
            }
            Location holoLocation = this.getHologramLocationByLocation(holo.getLocation());
            if (holoLocation != null) {
                this.hologramLocations.remove(holoLocation);
                this.updateHologramDatabase();
            }
            player.sendMessage(I.i18n("holo_removed"));
        });
    }

    private void updatePlayerStatisticHologram(Player player, Hologram holo) {
        PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(I.i18n("statistics_kills", false).replace("%kills%", Integer.toString(statistic.getKills())));
        lines.add(I.i18n("statistics_deaths", false).replace("%deaths%", Integer.toString(statistic.getDeaths())));
        lines.add(I.i18n("statistics_kd", false).replace("%kd%", Double.toString(statistic.getKD())));
        lines.add(I.i18n("statistics_wins", false).replace("%wins%", Integer.toString(statistic.getWins())));
        lines.add(I.i18n("statistics_loses", false).replace("%loses%", Integer.toString(statistic.getLoses())));
        lines.add(I.i18n("statistics_games", false).replace("%games%", Integer.toString(statistic.getGames())));
        lines.add(I.i18n("statistics_beds", false).replace("%beds%", Integer.toString(statistic.getDestroyedBeds())));
        lines.add(I.i18n("statistics_score", false).replace("%score%", Integer.toString(statistic.getScore())));
        int size = holo.length();
        int increment = 0;
        if (size == 1 || size > lines.size()) {
            increment = 1;
        }
        for (int i = 0; i < lines.size(); ++i) {
            holo.setLine(i + increment, (String)lines.get(i));
        }
        if (!holo.getViewers().contains(player)) {
            holo.addViewer(player);
        }
    }
}

