/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.inventories;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsOpenTeamSelectionEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.Team;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.builder.FormatBuilder;
import org.screamingsandals.bedwars.lib.sgui.events.CloseInventoryEvent;
import org.screamingsandals.bedwars.lib.sgui.events.PostActionEvent;
import org.screamingsandals.bedwars.lib.sgui.inventory.GuiHolder;
import org.screamingsandals.bedwars.lib.sgui.inventory.Options;
import org.screamingsandals.bedwars.lib.sgui.utils.MapReader;

public class TeamSelectorInventory
implements Listener {
    private Game game;
    private SimpleInventories simpleGuiFormat;
    private Options options;
    private List<Player> openedForPlayers = new ArrayList<Player>();

    public TeamSelectorInventory(Main plugin, Game game) {
        this.game = game;
        this.options = new Options((Plugin)Main.getInstance());
        this.options.setPrefix(I18n.i18nonly("team_selection_name", "Select team - %arena%").replace("%arena%", game.getName()));
        this.options.setShowPageNumber(false);
        this.options.setRender_header_start(54);
        this.options.setRender_offset(0);
        int teamCount = game.getTeams().size();
        if (teamCount <= 9) {
            this.options.setRender_actual_rows(1);
        } else if (teamCount <= 18) {
            this.options.setRender_actual_rows(2);
        }
        this.createData();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void destroy() {
        HandlerList.unregisterAll((Listener)this);
    }

    public void openForPlayer(Player player) {
        BedwarsOpenTeamSelectionEvent event = new BedwarsOpenTeamSelectionEvent(this.game, player);
        Main.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.repaint();
        this.openedForPlayers.add(player);
        this.simpleGuiFormat.openForPlayer(player);
    }

    private void createData() {
        SimpleInventories simpleGuiFormat = new SimpleInventories(this.options);
        FormatBuilder builder = new FormatBuilder();
        ItemStack stack = Main.getConfigurator().readDefinedItem("team-select", Main.isLegacy() ? "WOOL" : "WHITE_WOOL");
        for (Team team : this.game.getTeams()) {
            ItemStack teamStack = Main.applyColor(team.color, stack, true);
            ItemMeta teamMeta = teamStack.getItemMeta();
            List<GamePlayer> playersInTeam = this.game.getPlayersInTeam(team);
            int playersInTeamCount = playersInTeam.size();
            teamMeta.setDisplayName(I18n.i18nonly("team_select_item").replace("%teamName%", team.color.chatColor + team.getName()).replace("%inTeam%", String.valueOf(playersInTeamCount)).replace("%maxInTeam%", String.valueOf(team.maxPlayers)));
            teamMeta.setLore(this.formatLore(team, this.game));
            teamStack.setItemMeta(teamMeta);
            builder.add(teamStack).set("team", team);
        }
        simpleGuiFormat.load(builder);
        simpleGuiFormat.generateData();
        this.simpleGuiFormat = simpleGuiFormat;
    }

    private List<String> formatLore(Team team, Game game) {
        ArrayList<String> loreList = new ArrayList<String>();
        List<GamePlayer> playersInTeam = game.getPlayersInTeam(team);
        int playersInTeamCount = playersInTeam.size();
        if (playersInTeamCount >= team.maxPlayers) {
            loreList.add(team.color.chatColor + I18n.i18nonly("team_select_item_lore_full"));
        } else {
            loreList.add(team.color.chatColor + I18n.i18nonly("team_select_item_lore_join"));
        }
        if (!playersInTeam.isEmpty()) {
            loreList.add(I18n.i18nonly("team_select_item_lore"));
            for (GamePlayer gamePlayer : playersInTeam) {
                loreList.add(team.color.chatColor + gamePlayer.player.getDisplayName());
            }
        }
        return loreList;
    }

    private void repaint() {
        this.createData();
        for (Player pl : new ArrayList<Player>(this.openedForPlayers)) {
            GuiHolder guiHolder = this.simpleGuiFormat.getCurrentGuiHolder(pl);
            if (guiHolder == null) {
                this.openedForPlayers.remove(pl);
                continue;
            }
            guiHolder.setFormat(this.simpleGuiFormat);
            guiHolder.repaint();
        }
    }

    @EventHandler
    public void onPostAction(PostActionEvent event) {
        if (event.getFormat() != this.simpleGuiFormat) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.openedForPlayers.contains(player)) {
            return;
        }
        MapReader reader = event.getItem().getReader();
        if (reader.containsKey("team")) {
            Team team = (Team)reader.get("team");
            this.game.selectTeam(Main.getPlayerGameProfile(player), team.getName());
            this.openedForPlayers.remove(player);
            player.closeInventory();
            this.repaint();
        }
    }

    @EventHandler
    public void onInventoryClose(CloseInventoryEvent event) {
        if (event.getFormat() != this.simpleGuiFormat) {
            return;
        }
        this.openedForPlayers.remove(event.getPlayer());
    }

    @EventHandler
    public void onPlayerLeave(BedwarsPlayerLeaveEvent event) {
        this.openedForPlayers.remove(event.getPlayer());
        if (event.getGame() != this.game) {
            return;
        }
        this.repaint();
    }
}

