/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.debug;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;

public class Debug {
    private static Logger logger;
    private static Logger aLogger;
    private static boolean isDebug;
    private static String fallbackName;

    public static void init(String pluginName) {
        logger = Logger.getLogger(pluginName);
        aLogger = Logger.getAnonymousLogger();
    }

    public static void info(String debug) {
        if (isDebug) {
            Debug.log(Level.INFO, Debug.translateColor(debug));
        }
    }

    public static void info(String debug, boolean forceDebug) {
        if (isDebug || forceDebug) {
            Debug.log(Level.INFO, Debug.translateColor(debug));
        }
    }

    public static void infoA(String prefix, String debug) {
        if (isDebug) {
            Debug.aLog(Level.INFO, Debug.translateColor(prefix) + " " + Debug.translateColor(debug));
        }
    }

    public static void infoA(String prefix, String debug, boolean forceDebug) {
        if (isDebug || forceDebug) {
            Debug.aLog(Level.INFO, Debug.translateColor(prefix) + " " + Debug.translateColor(debug));
        }
    }

    public static void warn(String debug) {
        if (isDebug) {
            Debug.log(Level.WARNING, Debug.translateColor(debug));
        }
    }

    public static void warn(String debug, boolean forceDebug) {
        if (isDebug || forceDebug) {
            Debug.log(Level.WARNING, Debug.translateColor(debug));
        }
    }

    public static void warnA(String prefix, String debug) {
        if (isDebug) {
            Debug.aLog(Level.WARNING, Debug.translateColor(prefix) + "> " + Debug.translateColor(debug));
        }
    }

    public static void warnA(String prefix, String debug, boolean forceDebug) {
        if (isDebug || forceDebug) {
            Debug.aLog(Level.WARNING, Debug.translateColor(prefix) + "> " + Debug.translateColor(debug));
        }
    }

    public static void debug(String debug, Level level, boolean forceDebug) {
        if (isDebug || forceDebug) {
            Debug.log(level, Debug.translateColor(debug));
        }
    }

    public static void setDebug(boolean debug) {
        isDebug = debug;
    }

    public static void setFallbackName(String name) {
        fallbackName = name;
    }

    private static String translateColor(String string) {
        if (string == null) {
            return "";
        }
        if (Debug.isBukkit()) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        }
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    private static void log(Level level, String message) {
        if (logger != null) {
            logger.log(level, message);
        } else {
            Logger.getLogger(fallbackName).log(level, message);
        }
    }

    private static void aLog(Level level, String message) {
        if (aLogger != null) {
            aLogger.log(level, message);
        } else {
            Logger.getAnonymousLogger(fallbackName).log(level, message);
        }
    }

    private static boolean isBukkit() {
        try {
            Class.forName("org.bukkit.ChatColor");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    static {
        isDebug = false;
        fallbackName = "Fallback";
    }
}

