/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.lang;

import org.bukkit.ChatColor;

public interface ITranslateContainer {
    public String getLocaleCode();

    default public String getLanguage() {
        return this.translate("lang_name");
    }

    default public String getFallbackLanguage() {
        return this.getFallbackContainer() != null ? this.getFallbackContainer().getLanguage() : null;
    }

    default public String translate(String key) {
        return this.translate(key, null);
    }

    public String translate(String var1, String var2);

    default public String translate(String key, String def, boolean prefix) {
        return this.translate(key, def, prefix, null);
    }

    default public String translate(String key, String def, boolean prefix, String customPrefix) {
        if (prefix) {
            return this.translateWithPrefix(key, def, customPrefix);
        }
        return this.translate(key, def);
    }

    default public String translate(String key, boolean prefix) {
        return this.translate(key, null, prefix);
    }

    default public String getPrefix() {
        return this.translate("prefix", "");
    }

    default public String translateWithPrefix(String key) {
        return this.translateWithPrefix(key, null);
    }

    default public String translateWithPrefix(String key, String def) {
        return this.translateWithPrefix(key, def, null);
    }

    default public String translateWithPrefix(String key, String def, String customPrefix) {
        String prefix;
        String value = "";
        String string = prefix = customPrefix != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)customPrefix) : this.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            value = value + prefix + '\u00a7' + "r ";
        }
        value = value + this.translate(key, def);
        return value;
    }

    public ITranslateContainer getFallbackContainer();
}

