/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.nms.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.screamingsandals.bedwars.lib.nms.accessors.ComponentAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.EntityAccessor;
import org.screamingsandals.bedwars.lib.nms.utils.ClassStorage;
import org.screamingsandals.bedwars.lib.nms.utils.InstanceMethod;
import org.screamingsandals.bedwars.lib.nms.utils.Version;
import org.screamingsandals.bedwars.tab.TabManager;

public class EntityNMS
implements EntityAccessor {
    protected Object handler;

    protected EntityNMS() {
    }

    public EntityNMS(Object handler) {
        this.handler = handler;
    }

    public EntityNMS(Entity entity) {
        this(ClassStorage.getHandle(entity));
    }

    public Location getLocation() {
        if (Version.isVersion(1, 16)) {
            float pitch;
            float yaw;
            double locX = (Double)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_X.get()).invoke(new Object[0]);
            double locY = (Double)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_Y.get()).invoke(new Object[0]);
            double locZ = (Double)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_Z.get()).invoke(new Object[0]);
            if (Version.isVersion(1, 17)) {
                yaw = ((Float)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_YROT.get()).invoke(new Object[0])).floatValue();
                pitch = ((Float)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_XROT.get()).invoke(new Object[0])).floatValue();
            } else {
                yaw = ((Float)ClassStorage.getField(this.handler, (Field)FIELD_Y_ROT.get())).floatValue();
                pitch = ((Float)ClassStorage.getField(this.handler, (Field)FIELD_X_ROT.get())).floatValue();
            }
            Object world = ClassStorage.getMethod(this.handler, (Method)METHOD_GET_COMMAND_SENDER_WORLD.get()).invoke(new Object[0]);
            World craftWorld = (World)ClassStorage.getMethod(world, "getWorld", new Class[0]).invoke(new Object[0]);
            return new Location(craftWorld, locX, locY, locZ, yaw, pitch);
        }
        double locX = (Double)ClassStorage.getField(this.handler, (Field)FIELD_X.get());
        double locY = (Double)ClassStorage.getField(this.handler, (Field)FIELD_Y.get());
        double locZ = (Double)ClassStorage.getField(this.handler, (Field)FIELD_Z.get());
        float yaw = ((Float)ClassStorage.getField(this.handler, (Field)FIELD_Y_ROT.get())).floatValue();
        float pitch = ((Float)ClassStorage.getField(this.handler, (Field)FIELD_X_ROT.get())).floatValue();
        Object world = ClassStorage.getMethod(this.handler, (Method)METHOD_GET_COMMAND_SENDER_WORLD.get()).invoke(new Object[0]);
        World craftWorld = (World)ClassStorage.getMethod(world, "getWorld", new Class[0]).invoke(new Object[0]);
        return new Location(craftWorld, locX, locY, locZ, yaw, pitch);
    }

    public void setLocation(Location location) {
        Object world = ClassStorage.getMethod(this.handler, (Method)METHOD_GET_COMMAND_SENDER_WORLD.get()).invoke(new Object[0]);
        World craftWorld = (World)ClassStorage.getMethod(world, "getWorld", new Class[0]).invoke(new Object[0]);
        if (!location.getWorld().equals(craftWorld)) {
            ClassStorage.setField(this.handler, (Field)FIELD_LEVEL.get(), ClassStorage.getHandle(location.getWorld()));
        }
        ClassStorage.getMethod(this.handler, (Method)METHOD_ABS_SNAP_TO.get()).invoke(location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    public Object getHandler() {
        return this.handler;
    }

    public int getId() {
        return (Integer)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_ID.get()).invoke(new Object[0]);
    }

    public UUID getUUID() {
        return (UUID)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_UUID.get()).invoke(new Object[0]);
    }

    public double getX() {
        return (Double)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_X.get()).invoke(new Object[0]);
    }

    public double getY() {
        return (Double)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_Y.get()).invoke(new Object[0]);
    }

    public double getZ() {
        return (Double)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_Z.get()).invoke(new Object[0]);
    }

    public float getXRot() {
        return ((Float)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_XROT.get()).invoke(new Object[0])).floatValue();
    }

    public float getYRot() {
        return ((Float)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_YROT.get()).invoke(new Object[0])).floatValue();
    }

    public float getYHeadRot() {
        return ((Float)ClassStorage.getMethod(this.handler, (Method)METHOD_GET_YHEAD_ROT.get()).invoke(new Object[0])).floatValue();
    }

    public Object getType() {
        return ClassStorage.getMethod(this.handler, (Method)METHOD_GET_TYPE.get()).invoke(new Object[0]);
    }

    public Object getDelta() {
        return ClassStorage.getMethod(this.handler, (Method)METHOD_GET_DELTA_MOVEMENT.get()).invoke(new Object[0]);
    }

    public Object getDataWatcher() {
        return ClassStorage.getMethod(this.handler, (Method)METHOD_GET_ENTITY_DATA.get()).invoke(new Object[0]);
    }

    public void setCustomName(String name) {
        InstanceMethod method = ClassStorage.getMethod(this.handler, (Method)METHOD_SET_CUSTOM_NAME.get());
        if (method.getReflectedMethod() != null) {
            method.invoke(TabManager.serialize(name));
        } else {
            ClassStorage.getMethod(this.handler, (Method)METHOD_SET_CUSTOM_NAME_1.get()).invoke(name);
        }
    }

    public String getCustomName() {
        Object textComponent = ClassStorage.getMethod(this.handler, (Method)METHOD_GET_CUSTOM_NAME.get()).invoke(new Object[0]);
        String text = "";
        text = ComponentAccessor.TYPE.get().isInstance(textComponent) ? (String)ClassStorage.getMethod(textComponent, ComponentAccessor.METHOD_GET_COLORED_STRING.get()).invoke(new Object[0]) : textComponent.toString();
        return text;
    }

    public void setCustomNameVisible(boolean visible) {
        ClassStorage.getMethod(this.handler, (Method)METHOD_SET_CUSTOM_NAME_VISIBLE.get()).invoke(visible);
    }

    public boolean isCustomNameVisible() {
        return (Boolean)ClassStorage.getMethod(this.handler, (Method)METHOD_IS_CUSTOM_NAME_VISIBLE.get()).invoke(new Object[0]);
    }

    public void setInvisible(boolean invisible) {
        ClassStorage.getMethod(this.handler, (Method)METHOD_SET_INVISIBLE.get()).invoke(invisible);
    }

    public boolean isInvisible() {
        return (Boolean)ClassStorage.getMethod(this.handler, (Method)METHOD_IS_INVISIBLE.get()).invoke(new Object[0]);
    }

    public void setGravity(boolean gravity) {
        ClassStorage.getMethod(this.handler, (Method)METHOD_SET_NO_GRAVITY.get()).invoke(!gravity);
    }

    public boolean isGravity() {
        return (Boolean)ClassStorage.getMethod(this.handler, (Method)METHOD_IS_NO_GRAVITY.get()).invoke(new Object[0]) == false;
    }
}

