/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.nms.entity;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.lib.debug.Debug;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundAddMobPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundRemoveEntitiesPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundSetEntityDataPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundTeleportEntityPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.PositionMoveRotationAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.SynchedEntityDataAccessor;
import org.screamingsandals.bedwars.lib.nms.entity.EntityNMS;
import org.screamingsandals.bedwars.lib.nms.utils.ClassStorage;

public class FakeEntityNMS<E extends Entity>
extends EntityNMS
implements Listener {
    protected final List<Player> viewers = new ArrayList<Player>();
    private E entity;
    private boolean visible;

    protected FakeEntityNMS(Object nmsEntity) {
        try {
            this.entity = (Entity)ClassStorage.getMethod(nmsEntity, "getBukkitEntity", new Class[0]).invoke(new Object[0]);
            this.handler = nmsEntity;
        }
        catch (Throwable t) {
            Debug.warn("Could not create FakeEntityNMS: " + t.getMessage());
        }
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (visible) {
                this.viewers.forEach(this::onViewerAdded);
            } else {
                this.viewers.forEach(viewer -> ClassStorage.sendPacket(viewer, this.createDespawnPacket()));
            }
        }
    }

    public void setHealth(double health) {
        if (this.entity instanceof Damageable) {
            Damageable entity = (Damageable)this.entity;
            entity.setHealth(health * (entity.getMaxHealth() - 0.1) + 0.1);
            Object metadataPacket = this.createMetadataPacket();
            this.viewers.forEach(viewer -> ClassStorage.sendPacket(viewer, metadataPacket));
        }
    }

    public void addViewer(Player viewer) {
        if (this.viewers.isEmpty()) {
            Main.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Main.getInstance());
        }
        if (!this.viewers.contains(viewer)) {
            this.viewers.add(viewer);
            this.onViewerAdded(viewer);
        }
    }

    public void removeViewer(Player viewer) {
        if (this.viewers.contains(viewer)) {
            this.onViewerRemoved(viewer);
            this.viewers.remove(viewer);
        }
        if (this.viewers.isEmpty()) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public void onViewerAdded(Player viewer) {
        if (this.visible) {
            ClassStorage.sendPacket(viewer, this.createSpawnPacket());
            this.teleport(viewer, this.createPosition(viewer));
        }
    }

    public void onViewerRemoved(Player viewer) {
        if (this.visible) {
            ClassStorage.sendPacket(viewer, this.createDespawnPacket());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player viewer = event.getPlayer();
        if (this.viewers.contains(viewer) && this.visible) {
            this.teleport(viewer, this.createPosition(viewer));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player viewer = event.getPlayer();
        if (this.viewers.contains(viewer) && this.visible) {
            this.teleport(viewer, this.createPosition(event.getTo()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player viewer = event.getPlayer();
        if (this.viewers.contains(viewer) && this.visible) {
            this.teleport(viewer, this.createPosition(viewer));
        }
    }

    public Location createPosition(Player viewer) {
        return this.createPosition(viewer.getLocation());
    }

    public Location createPosition(Location position) {
        Location clone = position.clone();
        clone.setPitch(clone.getPitch() - 30.0f);
        clone.setYaw(clone.getYaw());
        clone.add(clone.getDirection().multiply(40));
        return clone;
    }

    public Object createSpawnPacket() {
        if (this.entity instanceof LivingEntity) {
            try {
                return ClientboundAddMobPacketAccessor.CONSTRUCTOR_0.get().newInstance(this.handler);
            }
            catch (Throwable t) {
                Debug.warn("Failed to create Spawn packet for fake entity!: " + t.getMessage());
            }
        }
        return null;
    }

    public Object createDespawnPacket() {
        try {
            return ClientboundRemoveEntitiesPacketAccessor.CONSTRUCTOR_1.get().newInstance(new Object[]{new int[]{this.entity.getEntityId()}});
        }
        catch (Throwable t) {
            Debug.warn("Failed to create De-spawn packet for fake entity!: " + t.getMessage());
            return null;
        }
    }

    public Object createLocationPacket() {
        try {
            if (ClientboundTeleportEntityPacketAccessor.CONSTRUCTOR_1.get() != null) {
                Object move = ClassStorage.getMethod(PositionMoveRotationAccessor.METHOD_OF.get()).invokeStatic(this.handler);
                return ClientboundTeleportEntityPacketAccessor.CONSTRUCTOR_1.get().newInstance(this.entity.getEntityId(), move, Collections.emptySet(), this.entity.isOnGround());
            }
            return ClientboundTeleportEntityPacketAccessor.CONSTRUCTOR_0.get().newInstance(this.handler);
        }
        catch (Throwable t) {
            Debug.warn("Failed to create location packet for fake entity!: " + t.getMessage());
            return null;
        }
    }

    public void teleport(Player viewer, Location location) {
        try {
            ClassStorage.getMethod(this.handler, (Method)METHOD_ABS_SNAP_TO.get()).invoke(location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()));
        }
        catch (Throwable t) {
            Debug.warn("Failed to set location for fake entity!: " + t.getMessage());
        }
        ClassStorage.sendPacket(viewer, this.createLocationPacket());
    }

    @Override
    public String getCustomName() {
        return this.entity.getCustomName();
    }

    @Override
    public void setCustomName(String name) {
        this.entity.setCustomName(name);
        Object metadataPacket = this.createMetadataPacket();
        this.viewers.forEach(viewer -> ClassStorage.sendPacket(viewer, metadataPacket));
    }

    public void metadata(int position, Object data) {
        Object dataWatcher = this.getDataWatcher();
        if (dataWatcher != null) {
            try {
                SynchedEntityDataAccessor.METHOD_WATCH.get().invoke(dataWatcher, position, data);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object metadataPacket = this.createMetadataPacket();
            this.viewers.forEach(viewer -> ClassStorage.sendPacket(viewer, metadataPacket));
        }
    }

    public Object createMetadataPacket() {
        try {
            Object dataWatcher = this.getDataWatcher();
            return ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_0.get().newInstance(this.entity.getEntityId(), dataWatcher, false);
        }
        catch (Throwable t) {
            Debug.warn("Failed to create metadata packet for fake entity!: " + t.getMessage());
            return null;
        }
    }

    public void destroy() {
        HandlerList.unregisterAll((Listener)this);
        for (Player viewer : new ArrayList<Player>(this.viewers)) {
            this.teleport(viewer, null);
        }
    }

    @Generated
    public E getEntity() {
        return this.entity;
    }

    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Generated
    public List<Player> getViewers() {
        return this.viewers;
    }
}

