/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.nms.holograms;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundAddEntityPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundAddMobPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundRemoveEntitiesPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundSetEntityDataPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ClientboundTeleportEntityPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.Display$TextDisplayAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.EntityAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.PositionMoveRotationAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.SynchedEntityDataAccessor;
import org.screamingsandals.bedwars.lib.nms.entity.ArmorStandNMS;
import org.screamingsandals.bedwars.lib.nms.entity.EntityNMS;
import org.screamingsandals.bedwars.lib.nms.entity.EntityTextDisplayNMS;
import org.screamingsandals.bedwars.lib.nms.holograms.HologramManager;
import org.screamingsandals.bedwars.lib.nms.holograms.TouchHandler;
import org.screamingsandals.bedwars.lib.nms.utils.ClassStorage;
import org.screamingsandals.bedwars.lib.nms.utils.Version;

public class Hologram {
    public static final int VISIBILITY_DISTANCE_SQUARED = 4096;
    public static final boolean DISPLAY_ENTITIES_AVAILABLE = Display$TextDisplayAccessor.TYPE.get() != null;
    private List<Player> viewers = new ArrayList<Player>();
    private List<String> lines = new ArrayList<String>();
    private Location loc;
    private List<EntityNMS> entities = new ArrayList<EntityNMS>();
    private boolean touchable = false;
    private List<TouchHandler> handlers = new ArrayList<TouchHandler>();
    private HologramManager manager;

    Hologram(HologramManager manager, List<Player> players, Location loc, String[] lines) {
        this(manager, players, loc, lines, false);
    }

    Hologram(HologramManager manager, List<Player> players, Location loc, String[] lines, boolean touchable) {
        this.manager = manager;
        this.lines.addAll(Arrays.asList(lines));
        this.loc = loc;
        this.updateEntities();
        this.addViewers(players);
        this.touchable = touchable;
    }

    public Location getLocation() {
        return this.loc;
    }

    public int length() {
        return this.lines.size();
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    public List<Player> getViewers() {
        return this.viewers;
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public Hologram addHandler(TouchHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
        return this;
    }

    public Hologram setHandler(TouchHandler handler) {
        this.handlers.clear();
        if (handler != null) {
            this.handlers.add(handler);
        }
        return this;
    }

    public Hologram addViewer(Player player) {
        return this.addViewers(Collections.singletonList(player));
    }

    public Hologram addViewers(List<Player> players) {
        for (Player player : players) {
            if (this.viewers.contains(player)) continue;
            this.viewers.add(player);
            try {
                this.update(player, this.getAllSpawnPackets(), true);
            }
            catch (Throwable throwable) {}
        }
        return this;
    }

    public Hologram removeViewer(Player player) {
        return this.removeViewers(Arrays.asList(player));
    }

    public Hologram removeViewers(List<Player> players) {
        for (Player player : players) {
            if (!this.viewers.contains(player)) continue;
            this.viewers.remove(player);
            try {
                this.update(player, this.getAllDestroyPackets(), true);
            }
            catch (Throwable throwable) {}
        }
        return this;
    }

    public Hologram setLine(int index, String message) {
        if (this.lines.size() <= index) {
            return this.addLine(message);
        }
        this.lines.set(index, message);
        this.updateEntities(index, true);
        return this;
    }

    public Hologram addLine(String message) {
        this.lines.add(message);
        this.updateEntities();
        return this;
    }

    public Hologram removeLine() {
        return this.removeLine(this.lines.size() - 1);
    }

    public Hologram removeLine(int index) {
        this.lines.remove(index);
        this.updateEntities(index, false);
        return this;
    }

    public Hologram destroy() {
        this.lines.clear();
        this.updateEntities();
        return this;
    }

    public boolean handleTouch(Player player, int entityId) throws Throwable {
        if (!this.touchable) {
            return false;
        }
        if (!this.isItMyId(entityId)) {
            return false;
        }
        for (TouchHandler handler : this.handlers) {
            handler.handle(player, this);
        }
        return true;
    }

    public boolean isItMyId(int id) throws Throwable {
        for (EntityNMS entity : this.entities) {
            if (entity.getId() != id) continue;
            return true;
        }
        return false;
    }

    private void updateEntities() {
        this.updateEntities(0, false);
    }

    private void updateEntities(int startIndex, boolean justThisIndex) {
        try {
            ArrayList packets = new ArrayList();
            boolean positionChanged = !justThisIndex && this.lines.size() != this.entities.size();
            for (int i2 = startIndex; !(i2 >= this.lines.size() || justThisIndex && i2 != startIndex); ++i2) {
                EntityTextDisplayNMS display;
                Object metadataPacket;
                Object watcherInList;
                ArmorStandNMS stand;
                String line = this.lines.get(i2);
                if (i2 < this.entities.size() && this.entities.get(i2) != null) {
                    Object teleportPacket;
                    EntityNMS entity = this.entities.get(i2);
                    if (entity instanceof ArmorStandNMS) {
                        stand = (ArmorStandNMS)entity;
                        stand.setCustomName(line);
                        if (ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_1.get() != null) {
                            watcherInList = ClassStorage.getMethod(stand.getDataWatcher(), SynchedEntityDataAccessor.METHOD_PACK_DIRTY.get()).invoke(new Object[0]);
                            if (watcherInList != null) {
                                metadataPacket = ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_1.get().newInstance(stand.getId(), watcherInList);
                                packets.add(metadataPacket);
                                ClassStorage.getMethod(stand.getDataWatcher(), SynchedEntityDataAccessor.METHOD_CLEAR_DIRTY.get()).invoke(new Object[0]);
                            }
                        } else {
                            Object metadataPacket2 = ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_0.get().newInstance(stand.getId(), stand.getDataWatcher(), false);
                            packets.add(metadataPacket2);
                        }
                    } else if (entity instanceof EntityTextDisplayNMS) {
                        display = (EntityTextDisplayNMS)entity;
                        display.setText(line);
                        watcherInList = ClassStorage.getMethod(display.getDataWatcher(), SynchedEntityDataAccessor.METHOD_PACK_DIRTY.get()).invoke(new Object[0]);
                        if (watcherInList != null) {
                            metadataPacket = ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_1.get().newInstance(display.getId(), watcherInList);
                            packets.add(metadataPacket);
                        }
                    }
                    if (!positionChanged) continue;
                    Location localLoc = this.loc.clone().add(0.0, (double)(this.lines.size() - i2) * 0.3, 0.0);
                    entity.setLocation(localLoc);
                    if (ClientboundTeleportEntityPacketAccessor.CONSTRUCTOR_1.get() != null) {
                        Object move = ClassStorage.getMethod(PositionMoveRotationAccessor.METHOD_OF.get()).invokeStatic(entity.getHandler());
                        teleportPacket = ClientboundTeleportEntityPacketAccessor.CONSTRUCTOR_1.get().newInstance(entity.getId(), move, Collections.emptySet(), ClassStorage.getMethod(entity.getHandler(), EntityAccessor.METHOD_ON_GROUND.get()).invoke(new Object[0]));
                    } else {
                        teleportPacket = ClientboundTeleportEntityPacketAccessor.CONSTRUCTOR_0.get().newInstance(entity.getHandler());
                    }
                    packets.add(teleportPacket);
                    continue;
                }
                Location localLoc = this.loc.clone().add(0.0, (double)(this.lines.size() - i2) * 0.3, 0.0);
                if (!this.touchable && DISPLAY_ENTITIES_AVAILABLE && Main.getConfigurator().config.getBoolean("prefer-1-19-4-display-entities")) {
                    display = new EntityTextDisplayNMS(localLoc);
                    display.setText(line);
                    if (ClientboundAddEntityPacketAccessor.CONSTRUCTOR_1.get() != null) {
                        packets.add(ClientboundAddEntityPacketAccessor.CONSTRUCTOR_1.get().newInstance(display.getHandler()));
                    } else {
                        packets.add(ClientboundAddEntityPacketAccessor.CONSTRUCTOR_2.get().newInstance(display.getId(), display.getUUID(), display.getX(), display.getY(), display.getZ(), Float.valueOf(display.getXRot()), Float.valueOf(display.getYRot()), display.getType(), 0, display.getDelta(), Float.valueOf(display.getYHeadRot())));
                    }
                    watcherInList = ClassStorage.getMethod(display.getDataWatcher(), SynchedEntityDataAccessor.METHOD_PACK_DIRTY.get()).invoke(new Object[0]);
                    if (watcherInList != null) {
                        metadataPacket = ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_1.get().newInstance(display.getId(), watcherInList);
                        packets.add(metadataPacket);
                    }
                    if (this.entities.size() <= i2) {
                        this.entities.add(display);
                        continue;
                    }
                    this.entities.set(i2, display);
                    continue;
                }
                stand = new ArmorStandNMS(localLoc);
                stand.setCustomName(line);
                stand.setCustomNameVisible(true);
                stand.setInvisible(true);
                stand.setSmall(!this.touchable);
                stand.setArms(false);
                stand.setBasePlate(false);
                stand.setGravity(false);
                stand.setMarker(!this.touchable);
                Object spawnLivingPacket = ClientboundAddMobPacketAccessor.TYPE.get() != null ? ClientboundAddMobPacketAccessor.CONSTRUCTOR_0.get().newInstance(stand.getHandler()) : (ClientboundAddEntityPacketAccessor.CONSTRUCTOR_0.get() != null ? ClientboundAddEntityPacketAccessor.CONSTRUCTOR_0.get().newInstance(stand.getHandler()) : (ClientboundAddEntityPacketAccessor.CONSTRUCTOR_1.get() != null ? ClientboundAddEntityPacketAccessor.CONSTRUCTOR_1.get().newInstance(stand.getHandler()) : ClientboundAddEntityPacketAccessor.CONSTRUCTOR_2.get().newInstance(stand.getId(), stand.getUUID(), stand.getX(), stand.getY(), stand.getZ(), Float.valueOf(stand.getXRot()), Float.valueOf(stand.getYRot()), stand.getType(), 0, stand.getDelta(), Float.valueOf(stand.getYHeadRot()))));
                packets.add(spawnLivingPacket);
                if (Version.isVersion(1, 15)) {
                    if (ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_1.get() != null) {
                        Object watcherInList2 = ClassStorage.getMethod(stand.getDataWatcher(), SynchedEntityDataAccessor.METHOD_PACK_DIRTY.get()).invoke(new Object[0]);
                        if (watcherInList2 != null) {
                            Object metadataPacket3 = ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_1.get().newInstance(stand.getId(), watcherInList2);
                            packets.add(metadataPacket3);
                            ClassStorage.getMethod(stand.getDataWatcher(), SynchedEntityDataAccessor.METHOD_CLEAR_DIRTY.get()).invoke(new Object[0]);
                        }
                    } else {
                        metadataPacket = ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_0.get().newInstance(stand.getId(), stand.getDataWatcher(), false);
                        packets.add(metadataPacket);
                    }
                }
                if (this.entities.size() <= i2) {
                    this.entities.add(stand);
                    continue;
                }
                this.entities.set(i2, stand);
            }
            ArrayList<Integer> forRemoval = new ArrayList<Integer>();
            if (this.entities.size() > this.lines.size()) {
                int i3 = this.lines.size();
                while (i3 < this.entities.size()) {
                    forRemoval.add(this.entities.get(i3).getId());
                    this.entities.remove(i3);
                }
            }
            if (ClientboundRemoveEntitiesPacketAccessor.CONSTRUCTOR_0.get() != null) {
                Constructor<?> constructor = ClientboundRemoveEntitiesPacketAccessor.CONSTRUCTOR_0.get();
                for (Integer integer : forRemoval) {
                    packets.add(constructor.newInstance(integer));
                }
            } else {
                Object destroyPacket = ClientboundRemoveEntitiesPacketAccessor.CONSTRUCTOR_1.get().newInstance(new Object[]{forRemoval.stream().mapToInt(i -> i).toArray()});
                packets.add(destroyPacket);
            }
            this.viewers.forEach(player -> this.update((Player)player, packets, true));
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }

    void update(Player player, List<Object> packets, boolean check_distance) {
        try {
            if (!this.manager.getHolograms().contains(this)) {
                this.manager.getHolograms().add(this);
            }
            if (player.getLocation().getWorld().equals(this.loc.getWorld()) ? check_distance && player.getLocation().distanceSquared(this.loc) >= 4096.0 : check_distance) {
                return;
            }
            for (Object packet : packets) {
                ClassStorage.sendPacket(player, packet);
            }
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }

    public List<Object> getAllDestroyPackets() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArrayList<Object> packets = new ArrayList<Object>();
        if (ClientboundRemoveEntitiesPacketAccessor.CONSTRUCTOR_0.get() != null) {
            Constructor<?> constructor = ClientboundRemoveEntitiesPacketAccessor.CONSTRUCTOR_0.get();
            for (EntityNMS integer : this.entities) {
                packets.add(constructor.newInstance(integer.getId()));
            }
        } else {
            int[] removal = new int[this.entities.size()];
            for (int i = 0; i < this.entities.size(); ++i) {
                removal[i] = this.entities.get(i).getId();
            }
            packets.add(ClientboundRemoveEntitiesPacketAccessor.CONSTRUCTOR_1.get().newInstance(new Object[]{removal}));
        }
        return packets;
    }

    public List<Object> getAllSpawnPackets() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException {
        ArrayList<Object> packets = new ArrayList<Object>();
        for (EntityNMS entity : this.entities) {
            if (ClientboundAddMobPacketAccessor.TYPE.get() != null) {
                packets.add(ClientboundAddMobPacketAccessor.CONSTRUCTOR_0.get().newInstance(entity.getHandler()));
            } else if (ClientboundAddEntityPacketAccessor.CONSTRUCTOR_0.get() != null) {
                packets.add(ClientboundAddEntityPacketAccessor.CONSTRUCTOR_0.get().newInstance(entity.getHandler()));
            } else if (ClientboundAddEntityPacketAccessor.CONSTRUCTOR_1.get() != null) {
                packets.add(ClientboundAddEntityPacketAccessor.CONSTRUCTOR_1.get().newInstance(entity.getHandler()));
            } else {
                packets.add(ClientboundAddEntityPacketAccessor.CONSTRUCTOR_2.get().newInstance(entity.getId(), entity.getUUID(), entity.getX(), entity.getY(), entity.getZ(), Float.valueOf(entity.getXRot()), Float.valueOf(entity.getYRot()), entity.getType(), 0, entity.getDelta(), Float.valueOf(entity.getYHeadRot())));
            }
            if (!Version.isVersion(1, 15)) continue;
            if (ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_1.get() != null) {
                Object watcherInList = SynchedEntityDataAccessor.METHOD_GET_ALL.get() != null ? ClassStorage.getMethod(entity.getDataWatcher(), SynchedEntityDataAccessor.METHOD_GET_ALL.get()).invoke(new Object[0]) : ClassStorage.getMethod(entity.getDataWatcher(), SynchedEntityDataAccessor.METHOD_GET_NON_DEFAULT_VALUES.get()).invoke(new Object[0]);
                if (watcherInList == null) continue;
                Object metadataPacket = ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_1.get().newInstance(entity.getId(), watcherInList);
                packets.add(metadataPacket);
                continue;
            }
            Object metadataPacket = ClientboundSetEntityDataPacketAccessor.CONSTRUCTOR_0.get().newInstance(entity.getId(), entity.getDataWatcher(), true);
            packets.add(metadataPacket);
        }
        return packets;
    }
}

