/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.nms.holograms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.lib.nms.accessors.ServerboundInteractPacketAccessor;
import org.screamingsandals.bedwars.lib.nms.holograms.Hologram;
import org.screamingsandals.bedwars.lib.nms.network.inbound.AutoPacketInboundListener;
import org.screamingsandals.bedwars.lib.nms.utils.ClassStorage;

public class HologramManager
implements Listener {
    public static final int VISIBILITY_DISTANCE_SQUARED = 4096;
    private final List<Hologram> HOLOGRAMS = new ArrayList<Hologram>();
    private Plugin pl;

    public HologramManager(Plugin pl) {
        this.pl = pl;
        this.pl.getServer().getPluginManager().registerEvents((Listener)this, this.pl);
        new AutoPacketInboundListener(pl){

            @Override
            protected Object handle(Player sender, Object packet) throws Throwable {
                block1: {
                    Hologram h;
                    if (!ServerboundInteractPacketAccessor.TYPE.get().isInstance(packet)) break block1;
                    int a = (Integer)ClassStorage.getField(packet, ServerboundInteractPacketAccessor.FIELD_ENTITY_ID.get());
                    Iterator iterator = HologramManager.this.HOLOGRAMS.iterator();
                    while (iterator.hasNext() && !(h = (Hologram)iterator.next()).handleTouch(sender, a)) {
                    }
                }
                return packet;
            }
        };
    }

    public Hologram spawnHologram(Location loc, String ... lines) {
        return new Hologram(this, Collections.emptyList(), loc, lines);
    }

    public Hologram spawnHologramTouchable(Location loc, String ... lines) {
        return new Hologram(this, Collections.emptyList(), loc, lines, true);
    }

    public Hologram spawnHologram(Player player, Location loc, String ... lines) {
        return this.spawnHologram(Arrays.asList(player), loc, lines);
    }

    public Hologram spawnHologramTouchable(Player player, Location loc, String ... lines) {
        return this.spawnHologramTouchable(Arrays.asList(player), loc, lines);
    }

    public Hologram spawnHologram(List<Player> players, Location loc, String ... lines) {
        return new Hologram(this, players, loc, lines);
    }

    public Hologram spawnHologramTouchable(List<Player> players, Location loc, String ... lines) {
        return new Hologram(this, players, loc, lines, true);
    }

    public List<Hologram> getHolograms() {
        return this.HOLOGRAMS;
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (this.HOLOGRAMS.isEmpty()) {
            return;
        }
        ArrayList<Hologram> copy = new ArrayList<Hologram>(this.HOLOGRAMS);
        for (Hologram hologram : copy) {
            if (hologram.isEmpty() || !hologram.hasViewers()) {
                this.HOLOGRAMS.remove(hologram);
                continue;
            }
            try {
                Player player = event.getPlayer();
                List<Player> viewers = hologram.getViewers();
                Location loc = hologram.getLocation();
                if (!viewers.contains(player) || !player.getWorld().equals(loc.getWorld())) continue;
                if (event.getTo().distanceSquared(loc) < 4096.0 && event.getFrom().distanceSquared(loc) >= 4096.0) {
                    hologram.update(player, hologram.getAllSpawnPackets(), false);
                    continue;
                }
                if (!(event.getTo().distanceSquared(loc) >= 4096.0) || !(event.getFrom().distanceSquared(loc) < 4096.0)) continue;
                hologram.update(player, hologram.getAllDestroyPackets(), false);
            }
            catch (Throwable throwable) {}
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (this.HOLOGRAMS.isEmpty()) {
            return;
        }
        ArrayList<Hologram> copy = new ArrayList<Hologram>(this.HOLOGRAMS);
        for (final Hologram hologram : copy) {
            if (hologram.isEmpty() || !hologram.hasViewers()) {
                this.HOLOGRAMS.remove(hologram);
                continue;
            }
            try {
                final Player player = event.getPlayer();
                List<Player> viewers = hologram.getViewers();
                Location loc = hologram.getLocation();
                if (!viewers.contains(player) || !player.getWorld().equals(loc.getWorld()) || event.getFrom().equals(loc.getWorld()) || !(player.getLocation().distanceSquared(loc) < 4096.0)) continue;
                new BukkitRunnable(){

                    public void run() {
                        try {
                            hologram.update(player, hologram.getAllSpawnPackets(), false);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }.runTaskLater(this.pl, 20L);
            }
            catch (Throwable throwable) {}
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.HOLOGRAMS.isEmpty()) {
            return;
        }
        ArrayList<Hologram> copy = new ArrayList<Hologram>(this.HOLOGRAMS);
        for (final Hologram hologram : copy) {
            if (hologram.isEmpty() || !hologram.hasViewers()) {
                this.HOLOGRAMS.remove(hologram);
                continue;
            }
            try {
                final Player player = event.getPlayer();
                List<Player> viewers = hologram.getViewers();
                Location loc = hologram.getLocation();
                if (!viewers.contains(player) || !event.getRespawnLocation().getWorld().equals(loc.getWorld()) || !(player.getLocation().distanceSquared(loc) < 4096.0)) continue;
                new BukkitRunnable(){

                    public void run() {
                        try {
                            hologram.update(player, hologram.getAllSpawnPackets(), false);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }.runTaskLater(this.pl, 20L);
            }
            catch (Throwable throwable) {}
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.HOLOGRAMS.isEmpty() || !event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            return;
        }
        ArrayList<Hologram> copy = new ArrayList<Hologram>(this.HOLOGRAMS);
        for (final Hologram hologram : copy) {
            if (hologram.isEmpty() || !hologram.hasViewers()) {
                this.HOLOGRAMS.remove(hologram);
                continue;
            }
            try {
                final Player player = event.getPlayer();
                List<Player> viewers = hologram.getViewers();
                Location loc = hologram.getLocation();
                if (!viewers.contains(player) || !player.getWorld().equals(loc.getWorld())) continue;
                if (event.getTo().distanceSquared(loc) < 4096.0 && event.getFrom().distanceSquared(loc) >= 4096.0) {
                    new BukkitRunnable(){

                        public void run() {
                            try {
                                hologram.update(player, hologram.getAllSpawnPackets(), false);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.runTaskLater(this.pl, 10L);
                    continue;
                }
                if (!(event.getTo().distanceSquared(loc) >= 4096.0) || !(event.getFrom().distanceSquared(loc) < 4096.0)) continue;
                new BukkitRunnable(){

                    public void run() {
                        try {
                            hologram.update(player, hologram.getAllDestroyPackets(), false);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }.runTaskLater(this.pl, 10L);
            }
            catch (Throwable throwable) {}
        }
    }

    @EventHandler
    public void onPlayersQuit(PlayerQuitEvent event) {
        if (this.HOLOGRAMS.isEmpty()) {
            return;
        }
        ArrayList<Hologram> copy = new ArrayList<Hologram>(this.HOLOGRAMS);
        for (Hologram hologram : copy) {
            if (hologram.getViewers().contains(event.getPlayer())) {
                hologram.removeViewer(event.getPlayer());
            }
            if (!hologram.isEmpty() && hologram.hasViewers()) continue;
            this.HOLOGRAMS.remove(hologram);
        }
    }
}

