/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.nms.network.inbound;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Field;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.lib.nms.accessors.ConnectionAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ServerCommonPacketListenerImplAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ServerGamePacketListenerImplAccessor;
import org.screamingsandals.bedwars.lib.nms.utils.ClassStorage;

public abstract class PacketInboundListener
implements ServerGamePacketListenerImplAccessor {
    private static int ID = 0;
    private final String channelName = PacketInboundListener.class.getCanonicalName() + "-" + ID++;

    public void addPlayer(final Player player) {
        try {
            Channel ch = this.getChannel(player);
            if (ch.pipeline().get(this.channelName) == null) {
                ChannelDuplexHandler handler = new ChannelDuplexHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        try {
                            msg = PacketInboundListener.this.handle(player, msg);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (msg != null) {
                            super.channelRead(ctx, msg);
                        }
                    }
                };
                ch.pipeline().addBefore("packet_handler", this.channelName, (ChannelHandler)handler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removePlayer(Player player) {
        try {
            Channel ch = this.getChannel(player);
            if (ch.pipeline().get(this.channelName) != null) {
                ch.pipeline().remove(this.channelName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Channel getChannel(Player player) {
        try {
            Object manager = ServerCommonPacketListenerImplAccessor.FIELD_CONNECTION.get() != null ? ClassStorage.getField(ClassStorage.getPlayerConnection(player), ServerCommonPacketListenerImplAccessor.FIELD_CONNECTION.get()) : ClassStorage.getField(ClassStorage.getPlayerConnection(player), (Field)FIELD_CONNECTION.get());
            Channel channel = (Channel)ClassStorage.getField(manager, ConnectionAccessor.FIELD_CHANNEL.get());
            return channel;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected abstract Object handle(Player var1, Object var2) throws Throwable;
}

