/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.lib.sgui.builder.FormatBuilder;
import org.screamingsandals.bedwars.lib.sgui.inventory.CloseCallback;
import org.screamingsandals.bedwars.lib.sgui.inventory.Column;
import org.screamingsandals.bedwars.lib.sgui.inventory.GuiHolder;
import org.screamingsandals.bedwars.lib.sgui.inventory.LocalOptions;
import org.screamingsandals.bedwars.lib.sgui.inventory.OpenCallback;
import org.screamingsandals.bedwars.lib.sgui.inventory.Options;
import org.screamingsandals.bedwars.lib.sgui.inventory.Origin;
import org.screamingsandals.bedwars.lib.sgui.item.BuyCallback;
import org.screamingsandals.bedwars.lib.sgui.item.ItemInfo;
import org.screamingsandals.bedwars.lib.sgui.item.ItemProperty;
import org.screamingsandals.bedwars.lib.sgui.item.PlayerItemInfo;
import org.screamingsandals.bedwars.lib.sgui.item.PostClickCallback;
import org.screamingsandals.bedwars.lib.sgui.item.PreClickCallback;
import org.screamingsandals.bedwars.lib.sgui.item.RenderCallback;
import org.screamingsandals.bedwars.lib.sgui.loaders.Loader;
import org.screamingsandals.bedwars.lib.sgui.loaders.LoaderRegister;
import org.screamingsandals.bedwars.lib.sgui.operations.OperationParser;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.Condition;
import org.screamingsandals.bedwars.lib.sgui.placeholders.AdvancedPlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.PAPIPlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.PagePlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.PermissionPlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.PlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.PlayerPlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.RuntimeDefinedPlaceholder;
import org.screamingsandals.bedwars.lib.sgui.placeholders.ThisPlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.WorldPlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.utils.InventoryUtils;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;

public class SimpleInventories {
    private final List<Origin> data = new ArrayList<Origin>();
    private final List<ItemInfo> generatedData = new ArrayList<ItemInfo>();
    private int lastpos = 0;
    private ItemInfo previous = null;
    private Map<String, ItemInfo> ids = new HashMap<String, ItemInfo>();
    private boolean animationsEnabled = false;
    private Plugin pluginForRunnables = null;
    private boolean genericShopEnabled = false;
    private boolean genericShopPriceTypeRequired = false;
    private boolean showPageNumber = true;
    private boolean allowAccessToConsole = false;
    private boolean allowBungeecord = false;
    private Map<String, PlaceholderParser> placeholders = new HashMap<String, PlaceholderParser>();
    private Map<String, AdvancedPlaceholderParser> advancedPlaceholders = new HashMap<String, AdvancedPlaceholderParser>();
    private final Map<ItemInfo, Map<Integer, List<ItemInfo>>> infoByAbsolutePosition = new HashMap<ItemInfo, Map<Integer, List<ItemInfo>>>();
    private final Map<ItemInfo, Integer> lastPageNumbers = new HashMap<ItemInfo, Integer>();
    private final String prefix;
    private final List<Map.Entry<String, List<Object>>> insertingBuffer = new ArrayList<Map.Entry<String, List<Object>>>();
    private static final List<String> POSITION_PROPERTIES = Arrays.asList("row", "column", "skip", "linebreak", "pagebreak", "absolute");
    private List<OpenCallback> openCallbacks = new ArrayList<OpenCallback>();
    private List<RenderCallback> renderCallbacks = new ArrayList<RenderCallback>();
    private List<PreClickCallback> preClickCallbacks = new ArrayList<PreClickCallback>();
    private List<BuyCallback> buyCallbacks = new ArrayList<BuyCallback>();
    private List<PostClickCallback> postClickCallbacks = new ArrayList<PostClickCallback>();
    private List<CloseCallback> closeCallbacks = new ArrayList<CloseCallback>();
    private LocalOptions localOptions;

    public SimpleInventories(Options options) {
        this.prefix = options.getPrefix();
        this.animationsEnabled = options.isAnimationsEnabled();
        this.pluginForRunnables = options.getPlugin();
        this.genericShopEnabled = options.isGenericShop();
        this.genericShopPriceTypeRequired = options.isGenericShopPriceTypeRequired();
        this.showPageNumber = options.isShowPageNumber();
        this.allowAccessToConsole = options.isAllowAccessToConsole();
        this.allowBungeecord = options.isAllowBungeecordPlayerSending();
        this.initPlaceholders();
        this.placeholders.putAll(options.getPlaceholders());
        this.advancedPlaceholders.putAll(options.getAdvancedPlaceholders());
        this.localOptions = new LocalOptions(options);
    }

    private void initPlaceholders() {
        this.placeholders.put("player", new PlayerPlaceholderParser());
        this.placeholders.put("permission", new PermissionPlaceholderParser());
        this.placeholders.put("world", new WorldPlaceholderParser());
        this.placeholders.put("papi", new PAPIPlaceholderParser());
        ThisPlaceholderParser thisParser = new ThisPlaceholderParser();
        this.advancedPlaceholders.put("this", thisParser);
        this.advancedPlaceholders.put("self", thisParser);
        this.advancedPlaceholders.put("page", new PagePlaceholderParser());
    }

    public SimpleInventories carrigeReturn() {
        this.lastpos -= (this.lastpos - this.localOptions.getItems_on_row()) % this.localOptions.getItems_on_row();
        return this;
    }

    public SimpleInventories lineBreak() {
        this.lastpos += this.localOptions.getItems_on_row() - this.lastpos % this.localOptions.getItems_on_row();
        return this;
    }

    public SimpleInventories pageBreak() {
        this.lastpos += this.localOptions.getItemsOnPage() - this.lastpos % this.localOptions.getItemsOnPage();
        return this;
    }

    public SimpleInventories jump(int number) {
        this.lastpos += number;
        if (this.lastpos < 0) {
            this.lastpos = 0;
        }
        return this;
    }

    public SimpleInventories absolute(int position) {
        this.lastpos = position;
        return this;
    }

    public SimpleInventories column(Column column) {
        return this.column(column.convert(this.localOptions.getItems_on_row()));
    }

    public SimpleInventories column(int column) {
        this.lastpos = this.lastpos - this.lastpos % this.localOptions.getItems_on_row() + column;
        return this;
    }

    public SimpleInventories row(int row) {
        this.lastpos = this.lastpos - this.lastpos % this.localOptions.getItemsOnPage() + (row - 1) * this.localOptions.getItems_on_row() + this.lastpos % this.localOptions.getItems_on_row();
        return this;
    }

    public SimpleInventories clearInput() {
        this.data.clear();
        this.previous = null;
        return this;
    }

    public SimpleInventories purgeData() {
        this.clearInput();
        this.ids.clear();
        this.generatedData.clear();
        this.lastpos = 0;
        this.infoByAbsolutePosition.clear();
        this.lastPageNumbers.clear();
        this.insertingBuffer.clear();
        return this;
    }

    public List<Origin> cloneCurrentInput() {
        return new ArrayList<Origin>(this.data);
    }

    public SimpleInventories load(List<Object> data) {
        this.data.add(new Origin(data));
        return this;
    }

    public SimpleInventories load(Origin origin) {
        this.data.add(origin);
        return this;
    }

    public SimpleInventories load(FormatBuilder builder) {
        this.data.add(new Origin(builder, builder.getResult()));
        return this;
    }

    public SimpleInventories load(String fileName) throws Exception {
        return this.load(new File(fileName), "data");
    }

    public SimpleInventories load(String fileName, String configPath) throws Exception {
        return this.load(new File(fileName), configPath);
    }

    public SimpleInventories loadFromDataFolder(File pluginDataFolder, String fileName) throws Exception {
        return this.load(new File(pluginDataFolder, fileName), "data");
    }

    public SimpleInventories loadFromDataFolder(File pluginDataFolder, String fileName, String configPath) throws Exception {
        return this.load(new File(pluginDataFolder, fileName), configPath);
    }

    public SimpleInventories load(File file) throws Exception {
        return this.load(file, "data");
    }

    public SimpleInventories load(File file, String configPath) throws Exception {
        return this.load(file, configPath, LoaderRegister.getLoader(file));
    }

    public SimpleInventories load(File file, Loader loader) throws Exception {
        return this.load(file, "data", loader);
    }

    public SimpleInventories load(File file, String configPath, Loader loader) throws Exception {
        this.data.add(loader.readData(file, configPath, this.localOptions));
        return this;
    }

    public boolean isAnimationsEnabled() {
        return this.animationsEnabled && this.pluginForRunnables != null;
    }

    public boolean isGenericShopEnabled() {
        return this.genericShopEnabled;
    }

    public boolean isPriceTypeRequired() {
        return this.genericShopPriceTypeRequired;
    }

    public Plugin getPluginForRunnables() {
        return this.pluginForRunnables;
    }

    public List<Origin> getData() {
        return this.data;
    }

    public String processPlaceholders(Player player, String text, PlayerItemInfo info) {
        char[] characters = text.toCharArray();
        int lastEscapeIndex = -2;
        String buf = "";
        for (int i = 0; i < characters.length; ++i) {
            char c = characters[i];
            if (c == '{' && lastEscapeIndex != i - 1) {
                int bracketEnd = characters.length;
                int alastEscapeIndex = -2;
                String bracketBuf = "";
                for (int j = i + 1; j < characters.length; ++j) {
                    char cc = characters[j];
                    if (cc == '\\' && alastEscapeIndex != j - 1) {
                        alastEscapeIndex = j;
                        continue;
                    }
                    if (cc == '}' && alastEscapeIndex != j - 1) {
                        bracketEnd = j;
                        break;
                    }
                    bracketBuf = bracketBuf + cc;
                }
                i = bracketEnd;
                buf = buf + String.valueOf(OperationParser.getFinalOperation(this, bracketBuf).resolveFor(player, info));
                continue;
            }
            if (c == '\\' && lastEscapeIndex != i - 1) {
                lastEscapeIndex = i;
                continue;
            }
            buf = buf + c;
        }
        text = buf;
        Pattern pat = Pattern.compile("%[^%]+%");
        Matcher matcher = pat.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String matched = matcher.group();
            matched = matcher.group().substring(1, matched.length() - 1);
            String[] args = matched.split("(?<!\\.)\\.(?!\\.)");
            String[] gargs = new String[args.length - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i].replaceAll("\\.+", ".");
                if (i <= 0) continue;
                gargs[i - 1] = args[i];
            }
            String key = args[0];
            if (this.advancedPlaceholders.containsKey(key) && info != null) {
                matcher.appendReplacement(sb, this.advancedPlaceholders.get(key).processPlaceholder(key, player, info, gargs));
                continue;
            }
            if (!this.placeholders.containsKey(key)) continue;
            matcher.appendReplacement(sb, this.placeholders.get(key).processPlaceholder(key, player, gargs));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public SimpleInventories generateData() {
        for (Origin origin : this.data) {
            this.openCallbacks.addAll(origin.getOpenCallbacks());
            this.renderCallbacks.addAll(origin.getRenderCallbacks());
            this.preClickCallbacks.addAll(origin.getPreClickCallbacks());
            this.buyCallbacks.addAll(origin.getBuyCallbacks());
            this.postClickCallbacks.addAll(origin.getPostClickCallbacks());
            this.closeCallbacks.addAll(origin.getCloseCallbacks());
            for (Object object : origin.getContent()) {
                this.lastpos = this.generateItem(null, object, this.lastpos, origin, this.localOptions);
            }
        }
        for (ItemInfo info : this.generatedData) {
            if (!info.isWritten()) continue;
            if (!this.infoByAbsolutePosition.containsKey(info.getParent())) {
                this.infoByAbsolutePosition.put(info.getParent(), new HashMap());
            }
            LocalOptions parentOptions = info.getParent() != null ? info.getParent().getLocalOptions() : this.localOptions;
            int page = info.getPosition() / parentOptions.getItemsOnPage();
            Map<Integer, List<ItemInfo>> map = this.infoByAbsolutePosition.get(info.getParent());
            if (!map.containsKey(page)) {
                map.put(page, new ArrayList());
            }
            map.get(page).add(info);
            if (!this.lastPageNumbers.containsKey(info.getParent())) {
                this.lastPageNumbers.put(info.getParent(), page);
                continue;
            }
            int lastPage = this.lastPageNumbers.get(info.getParent());
            if (page <= lastPage) continue;
            this.lastPageNumbers.put(info.getParent(), page);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private int generateItem(ItemInfo parent, Object original, int lastpos, Origin origin, LocalOptions currentOptions) {
        HashMap<String, Object> nobject;
        int times;
        void var13_57;
        String obj;
        HashMap<String, Object> object = new HashMap<String, Object>();
        if (original instanceof Map) {
            object.putAll((Map)original);
        } else {
            obj = original.toString().trim();
            if (obj.startsWith("define")) {
                String[] definition = obj.split(" ", 2);
                if (definition.length == 2) {
                    object.put("define", definition[1]);
                }
            } else {
                void var13_44;
                char[] characters = obj.toCharArray();
                int lastEscapeIndex = -2;
                boolean buildingString = false;
                int building = -1;
                String buf = "";
                boolean bl = false;
                while (var13_44 < characters.length) {
                    char c = characters[var13_44];
                    if (building == -1) {
                        if (c == '@') {
                            object.put("include", obj.substring(1));
                            break;
                        }
                        building = 0;
                    }
                    if (c == '\\' && lastEscapeIndex != var13_44 - true) {
                        lastEscapeIndex = var13_44;
                    } else if (buildingString) {
                        if ((c == '\"' || c == '\'') && lastEscapeIndex != var13_44 - true) {
                            buildingString = false;
                        } else {
                            buf = buf + c;
                        }
                    } else if (building < 2 && buf.endsWith("repeat")) {
                        buf = buf.substring(0, buf.length() - 6).trim();
                        if (building == 0) {
                            if (buf.equalsIgnoreCase("cosmetic")) {
                                object.put("stack", currentOptions.getCosmeticItem().clone());
                            } else {
                                object.put("stack", buf);
                            }
                        } else {
                            object.put("price", buf);
                        }
                        building = 2;
                        buf = "";
                    } else if (building == 0 && buf.endsWith("for")) {
                        building = 1;
                        if ((buf = buf.substring(0, buf.length() - 3).trim()).equalsIgnoreCase("cosmetic")) {
                            object.put("stack", currentOptions.getCosmeticItem().clone());
                        } else {
                            object.put("stack", buf);
                        }
                        buf = "";
                    } else if ((c == '\"' || c == '\'') && lastEscapeIndex != var13_44 - true) {
                        buildingString = true;
                        lastEscapeIndex = var13_44;
                    } else {
                        buf = buf + c;
                    }
                    ++var13_44;
                }
                if (building == 0) {
                    if ((buf = buf.trim()).equalsIgnoreCase("cosmetic")) {
                        object.put("stack", currentOptions.getCosmeticItem().clone());
                    } else {
                        object.put("stack", buf);
                    }
                } else if (building == 1) {
                    object.put("price", buf.trim());
                } else if (building == 2) {
                    try {
                        object.put("times", Integer.parseInt(buf.trim()));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        if (object.containsKey("guihack")) {
            String hack = object.get("guihack").toString();
            if (hack.equalsIgnoreCase("noheader")) {
                currentOptions.setRender_header_start(55);
                currentOptions.setRender_offset(0);
                if (currentOptions.getRows() < 6) {
                    currentOptions.setRows(currentOptions.getRows() + 1);
                }
            } else if (hack.equalsIgnoreCase("nofooter")) {
                currentOptions.setRender_footer_start(55);
                if (currentOptions.getRows() < 6) {
                    currentOptions.setRows(currentOptions.getRows() + 1);
                }
            } else if (hack.equalsIgnoreCase("noheaderfooter")) {
                currentOptions.setRender_header_start(55);
                currentOptions.setRender_footer_start(55);
                currentOptions.setRender_offset(0);
                if (currentOptions.getRows() < 5) {
                    currentOptions.setRows(currentOptions.getRows() + 2);
                } else if (currentOptions.getRows() < 6) {
                    currentOptions.setRows(currentOptions.getRows() + 1);
                }
            }
            return lastpos;
        }
        if (object.containsKey("define")) {
            AdvancedPlaceholderParser parser;
            String placeholderArguments;
            String definition = object.get("define").toString();
            String[] defsplit = definition.split(" as ", 2);
            String key = defsplit[0].trim();
            if (key.startsWith("%")) {
                key = key.substring(1);
            }
            if (key.endsWith("%")) {
                key = key.substring(0, key.length() - 1);
            }
            String[] placeholderFormat = key.split("(?<!\\.)\\.(?!\\.)", 2);
            key = placeholderFormat[0];
            String string = placeholderArguments = placeholderFormat.length == 1 ? "" : placeholderFormat[1];
            if (this.placeholders.containsKey(key)) {
                Bukkit.getLogger().severe("[SimpleInventories] Placeholder " + key + " is already defined as non-dynamic placeholder!");
                return lastpos;
            }
            if (!this.advancedPlaceholders.containsKey(key)) {
                this.advancedPlaceholders.put(key, new RuntimeDefinedPlaceholder());
            }
            if ((parser = this.advancedPlaceholders.get(key)) instanceof RuntimeDefinedPlaceholder) {
                if (defsplit.length == 2) {
                    RuntimeDefinedPlaceholder runtimeDefinedPlaceholder = (RuntimeDefinedPlaceholder)parser;
                    if (!placeholderArguments.isEmpty()) {
                        runtimeDefinedPlaceholder.register(placeholderArguments, defsplit[1].trim());
                    } else {
                        runtimeDefinedPlaceholder.putDefault(defsplit[1].trim());
                    }
                }
            } else {
                Bukkit.getLogger().severe("[SimpleInventories] Placeholder " + key + " is already defined as non-dynamic advanced placeholder!");
            }
            return lastpos;
        }
        if (object.containsKey("include")) {
            String path = object.get("include").toString();
            String data = "data";
            String loaderType = null;
            String[] splitByAt = path.split("@", 2);
            if (splitByAt.length == 2) {
                loaderType = splitByAt[0];
                path = splitByAt[1];
                String[] second_split = loaderType.split(":", 2);
                if (second_split.length == 2) {
                    loaderType = second_split[0];
                    data = second_split[1];
                }
            }
            if (loaderType != null) {
                loaderType = loaderType.trim();
            }
            data = data.trim();
            File file = new File(path);
            try {
                Loader loader = loaderType == null || "".equals(loaderType) ? LoaderRegister.getLoader(file) : LoaderRegister.getLoader(loaderType);
                Origin origin2 = loader.readData(file, data, currentOptions);
                List<Object> items = origin2.getContent();
                for (Object item : items) {
                    lastpos = this.generateItem(parent, item, lastpos, origin2, currentOptions);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return lastpos;
        }
        if (object.containsKey("insert")) {
            obj = object.get("insert");
            if (obj instanceof String) {
                String insert = obj;
                if ("main".equalsIgnoreCase(insert)) {
                    if (object.containsKey("items")) {
                        List items = (List)object.get("items");
                        for (Object itemObject : items) {
                            this.lastpos = this.generateItem(null, itemObject, this.lastpos, origin, this.localOptions);
                        }
                    }
                    return parent == null ? this.lastpos : lastpos;
                }
                if (insert.startsWith("\u00a7") || insert.startsWith("$")) {
                    ItemInfo inserted = this.ids.get(insert.substring(1));
                    if (object.containsKey("items")) {
                        List items = (List)object.get("items");
                        if (inserted != null) {
                            for (Object itemObject : items) {
                                inserted.lastpos = this.generateItem(inserted, itemObject, inserted.lastpos, origin, inserted.getLocalOptions());
                            }
                            return parent == inserted ? inserted.lastpos : lastpos;
                        }
                        this.insertingBuffer.add(new AbstractMap.SimpleEntry<String, List>(insert.substring(1), items));
                        return lastpos;
                    }
                }
            } else if (obj instanceof List) {
                boolean yes_main = false;
                boolean yes_inserted = false;
                for (Object ob : (List)((Object)obj)) {
                    if (!(ob instanceof String)) continue;
                    String insert = (String)ob;
                    if ("main".equalsIgnoreCase(insert)) {
                        if (object.containsKey("items")) {
                            List list = (List)object.get("items");
                            for (Object itemObject : list) {
                                this.lastpos = this.generateItem(null, itemObject, this.lastpos, origin, this.localOptions);
                            }
                        }
                        if (yes_main) continue;
                        yes_main = parent == null;
                        continue;
                    }
                    if (!insert.startsWith("\u00a7") && !insert.startsWith("$")) continue;
                    ItemInfo itemInfo = this.ids.get(insert.substring(1));
                    if (!object.containsKey("items")) continue;
                    List items = (List)object.get("items");
                    if (itemInfo != null) {
                        Object itemObject;
                        itemObject = items.iterator();
                        while (itemObject.hasNext()) {
                            Object itemObject2 = itemObject.next();
                            itemInfo.lastpos = this.generateItem(itemInfo, itemObject2, itemInfo.lastpos, origin, itemInfo.getLocalOptions());
                        }
                        if (yes_inserted) continue;
                        yes_inserted = parent == itemInfo;
                        continue;
                    }
                    this.insertingBuffer.add(new AbstractMap.SimpleEntry<String, List>(insert.substring(1), items));
                }
                return yes_main ? this.lastpos : (yes_inserted ? parent.lastpos : lastpos);
            }
        }
        if (object.containsKey("clone") && (obj = object.get("clone")) instanceof String && obj != null) {
            ItemInfo cloned;
            String clone;
            String cloneMethod;
            Object obj2;
            boolean cloneOverride = false;
            boolean cloneListIncrement = false;
            if (object.containsKey("clone-method") && (obj2 = object.get("clone-method")) instanceof String && obj != null && !"default".equalsIgnoreCase(cloneMethod = (String)obj2) && !"missing".equalsIgnoreCase(cloneMethod)) {
                if ("override".equalsIgnoreCase(cloneMethod)) {
                    cloneOverride = true;
                } else if ("increment".equalsIgnoreCase(cloneMethod) || "increment-default".equalsIgnoreCase(cloneMethod) || "increment-missing".equalsIgnoreCase(cloneMethod)) {
                    cloneListIncrement = true;
                } else if ("increment-override".equalsIgnoreCase(cloneMethod)) {
                    cloneOverride = true;
                    cloneListIncrement = true;
                }
            }
            if ("previous".equalsIgnoreCase(clone = obj)) {
                if (this.previous != null) {
                    for (Map.Entry<String, Object> entry : this.previous.getData().entrySet()) {
                        void var13_52;
                        if (this.isPositionProperty(entry.getKey())) continue;
                        Object object2 = entry.getValue();
                        if (object2 instanceof List) {
                            boolean containsObjectList = object.containsKey(entry.getKey());
                            if (containsObjectList) {
                                if (cloneListIncrement) {
                                    Object originalList = object.get(entry.getKey());
                                    ArrayList newList = new ArrayList();
                                    newList.addAll((List)object2);
                                    if (originalList instanceof List) {
                                        newList.addAll((List)originalList);
                                    }
                                    object.put((String)entry.getKey(), newList);
                                    continue;
                                }
                                if (!cloneOverride) continue;
                                object.put((String)entry.getKey(), object2);
                                continue;
                            }
                            object.put((String)entry.getKey(), object2);
                            continue;
                        }
                        if (object.containsKey(entry.getKey()) && !cloneOverride) continue;
                        if (object2 instanceof ItemStack) {
                            ItemStack itemStack = ((ItemStack)object2).clone();
                        }
                        object.put((String)entry.getKey(), var13_52);
                    }
                }
            } else if ("cosmetic".equalsIgnoreCase(clone)) {
                object.put("stack", this.localOptions.getCosmeticItem().clone());
            } else if ((clone.startsWith("\u00a7") || clone.startsWith("$")) && (cloned = this.ids.get(clone.substring(1))) != null) {
                for (Map.Entry entry : cloned.getData().entrySet()) {
                    if (this.isPositionProperty((String)entry.getKey())) continue;
                    Object val = entry.getValue();
                    if (val instanceof List) {
                        boolean containsObjectList = object.containsKey(entry.getKey());
                        if (containsObjectList) {
                            if (cloneListIncrement) {
                                Object originalList = object.get(entry.getKey());
                                ArrayList newList = new ArrayList();
                                newList.addAll((List)val);
                                if (originalList instanceof List) {
                                    newList.addAll((List)originalList);
                                }
                                object.put((String)entry.getKey(), newList);
                                continue;
                            }
                            if (!cloneOverride) continue;
                            object.put((String)entry.getKey(), val);
                            continue;
                        }
                        object.put((String)entry.getKey(), val);
                        continue;
                    }
                    if (object.containsKey(entry.getKey()) && !cloneOverride) continue;
                    if (val instanceof ItemStack) {
                        val = ((ItemStack)val).clone();
                    }
                    object.put((String)entry.getKey(), val);
                }
            }
        }
        ItemStack stack = new ItemStack(Material.AIR);
        if (object.containsKey("stack")) {
            stack = StackParser.parse(object.get("stack"));
        }
        int positionC = lastpos;
        int linebreakC = 0;
        int pagebreakC = 0;
        if (object.containsKey("linebreak")) {
            String lnBreak = (String)object.get("linebreak");
            if ("before".equalsIgnoreCase(lnBreak)) {
                linebreakC = 1;
            } else if ("after".equalsIgnoreCase(lnBreak)) {
                linebreakC = 2;
            } else if ("both".equalsIgnoreCase(lnBreak)) {
                linebreakC = 3;
            }
        }
        if (object.containsKey("pagebreak")) {
            String pgBreak = (String)object.get("pagebreak");
            if ("before".equalsIgnoreCase(pgBreak)) {
                pagebreakC = 1;
            } else if ("after".equalsIgnoreCase(pgBreak)) {
                pagebreakC = 2;
            } else if ("both".equalsIgnoreCase(pgBreak)) {
                pagebreakC = 3;
            }
        }
        if (pagebreakC == 1 || pagebreakC == 3) {
            positionC += currentOptions.getItemsOnPage() - positionC % currentOptions.getItemsOnPage();
        }
        if (object.containsKey("row")) {
            positionC = positionC - positionC % currentOptions.getItemsOnPage() + ((Integer)object.get("row") - 1) * this.localOptions.getItems_on_row() + positionC % this.localOptions.getItems_on_row();
        }
        if (object.containsKey("column")) {
            Object cl = object.get("column");
            int column = 0;
            column = "left".equals(cl) || "first".equals(cl) ? 0 : ("middle".equals(cl) || "center".equals(cl) ? this.localOptions.getItems_on_row() / 2 : ("right".equals(cl) || "last".equals(cl) ? this.localOptions.getItems_on_row() - 1 : (Integer)cl));
            positionC = positionC - positionC % this.localOptions.getItems_on_row() + column;
        }
        if (linebreakC == 1 || linebreakC == 3) {
            positionC += this.localOptions.getItems_on_row() - positionC % this.localOptions.getItems_on_row();
        }
        if (object.containsKey("skip")) {
            positionC += ((Integer)object.get("skip")).intValue();
        }
        if (object.containsKey("absolute")) {
            positionC = (Integer)object.get("absolute");
        }
        String id = object.containsKey("id") ? (String)object.get("id") : null;
        ArrayList<ItemProperty> properties = new ArrayList<ItemProperty>();
        if (object.containsKey("properties")) {
            final Object v = object.get("properties");
            if (v instanceof List) {
                List propertiesList = (List)v;
                for (final Object obj2 : propertiesList) {
                    if (obj2 instanceof Map) {
                        Map propertyMap = (Map)obj2;
                        ItemProperty pr = new ItemProperty(this, propertyMap.containsKey("name") ? (String)propertyMap.get("name") : null, propertyMap);
                        properties.add(pr);
                        continue;
                    }
                    if (!(obj2 instanceof String)) continue;
                    properties.add(new ItemProperty(this, (String)obj2, (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("name", (String)obj2);
                        }
                    }));
                }
            } else if (v instanceof String) {
                properties.add(new ItemProperty(this, (String)v, (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("name", (String)v);
                    }
                }));
            }
        }
        Object var13_55 = null;
        if (object.containsKey("animation")) {
            List anim = (List)object.get("animation");
            List<ItemStack> list = StackParser.parseAll(anim);
        }
        HashMap<Condition, Map<String, Object>> conditions = new HashMap<Condition, Map<String, Object>>();
        if (object.containsKey("conditions")) {
            List configuredConditions = (List)object.get("conditions");
            for (Map entry : configuredConditions) {
                String f_if = (String)entry.get("if");
                if (entry.containsKey("then")) {
                    Condition f_cond_then = OperationParser.getFinalCondition(this, f_if);
                    Map f_then = (Map)entry.get("then");
                    conditions.put(f_cond_then, f_then);
                }
                if (!entry.containsKey("else")) continue;
                Condition f_cond_else = OperationParser.getFinalNegation(this, f_if);
                Map f_else = (Map)entry.get("else");
                conditions.put(f_cond_else, f_else);
            }
        }
        ArrayList<RenderCallback> callbacks = new ArrayList<RenderCallback>();
        Boolean f_visible = object.getOrDefault("visible", true);
        boolean visible = true;
        if (f_visible instanceof Boolean) {
            visible = f_visible;
        } else if (f_visible instanceof Predicate) {
            callbacks.add(info -> info.setVisible(((Predicate)((Object)f_visible)).test(info)));
        } else if (f_visible instanceof String) {
            Condition f_visible_cond = OperationParser.getFinalCondition(this, ((Object)f_visible).toString());
            callbacks.add(info -> info.setVisible(f_visible_cond.process(info.getPlayer(), info)));
        }
        Boolean f_disabled = object.getOrDefault("disabled", false);
        boolean disabled = false;
        if (f_disabled instanceof Boolean) {
            disabled = f_disabled;
        } else if (f_disabled instanceof Predicate) {
            callbacks.add(info -> info.setDisabled(((Predicate)((Object)f_disabled)).test(info)));
        } else if (f_disabled instanceof String) {
            Condition f_disabled_cond = OperationParser.getFinalCondition(this, ((Object)f_disabled).toString());
            callbacks.add(info -> info.setDisabled(f_disabled_cond.process(info.getPlayer(), info)));
        }
        if (object.containsKey("price") && !object.containsKey("price-type")) {
            Object f_price = object.get("price");
            String price = f_price.toString().trim();
            int index = price.toLowerCase().indexOf("of");
            if (index > 0 && price.length() > index + 2) {
                try {
                    double pr = Double.parseDouble(price.substring(0, index).trim());
                    String price_type = price.substring(index + 2).trim();
                    object.put("price", pr);
                    object.put("price-type", price_type);
                }
                catch (Throwable pr) {}
            } else {
                String pr = "";
                String price_type = "";
                for (int i = 0; i < price.length(); ++i) {
                    char c = price.charAt(i);
                    if (!Character.isDigit(c) && c != '.') {
                        price_type = price.substring(i).trim();
                        break;
                    }
                    pr = pr + c;
                }
                try {
                    if (!pr.isEmpty()) {
                        object.put("price", Double.parseDouble(pr));
                        object.put("price-type", price_type);
                    }
                }
                catch (Throwable i) {
                    // empty catch block
                }
            }
        }
        if (object.containsKey("rendercallbacks")) {
            List render = (List)object.get("rendercallbacks");
            for (Object o : render) {
                if (!(o instanceof RenderCallback)) continue;
                callbacks.add((RenderCallback)o);
            }
        }
        LocalOptions options = null;
        if (object.containsKey("options")) {
            Object opt = object.get("options");
            if (opt instanceof LocalOptions) {
                options = (LocalOptions)opt;
            } else if (opt instanceof Map) {
                MemoryConfiguration memory = new MemoryConfiguration();
                memory.addDefaults((Map)opt);
                options = LocalOptions.deserialize(this.localOptions, (ConfigurationSection)memory);
            }
        }
        boolean write = object.containsKey("write") ? Boolean.parseBoolean("write") : true;
        ItemInfo info2 = new ItemInfo(this, parent, stack.clone(), positionC, visible, disabled, id, properties, object, (List<ItemStack>)var13_57, conditions, origin, write, callbacks, options);
        if (id != null && !this.insertingBuffer.isEmpty()) {
            for (Map.Entry<String, List<Object>> entry : new ArrayList<Map.Entry<String, List<Object>>>(this.insertingBuffer)) {
                if (!((String)entry.getKey()).equals(id)) continue;
                this.insertingBuffer.remove(entry);
                for (Object itemObject : (List)entry.getValue()) {
                    info2.lastpos = this.generateItem(info2, itemObject, info2.lastpos, origin, info2.getLocalOptions());
                }
            }
        }
        if (object.containsKey("items")) {
            List items = (List)object.get("items");
            for (Object itemObject : items) {
                info2.lastpos = this.generateItem(info2, itemObject, info2.lastpos, origin, info2.getLocalOptions());
            }
        } else if (object.containsKey("book")) {
            List pages = (List)object.get("book");
            ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
            BookMeta meta = (BookMeta)book.getItemMeta();
            for (Map page : pages) {
                String text = (String)page.get("text");
                meta.addPage(new String[]{text});
            }
            book.setItemMeta((ItemMeta)meta);
            info2.setBook(book);
        }
        this.generatedData.add(info2);
        this.previous = info2;
        if (id != null) {
            this.ids.put(id, info2);
        }
        int nextPosition = positionC;
        if (pagebreakC >= 2) {
            nextPosition += currentOptions.getItemsOnPage() - nextPosition % currentOptions.getItemsOnPage();
        }
        if (linebreakC >= 2) {
            nextPosition += currentOptions.getItems_on_row() - nextPosition % currentOptions.getItems_on_row();
        }
        if (pagebreakC < 2 && linebreakC < 2) {
            ++nextPosition;
        }
        if (write) {
            lastpos = nextPosition;
        }
        if (object.containsKey("times") && (times = ((Number)(nobject = new HashMap<String, Object>(object)).get("times")).intValue()) > 1) {
            if (nobject.containsKey("times-methods")) {
                Object met = nobject.get("times-methods");
                if (met instanceof List) {
                    List methods = (List)met;
                    for (String method : methods) {
                        if (method.equalsIgnoreCase("cancel-positioning")) {
                            for (String property : POSITION_PROPERTIES) {
                                if (!nobject.containsKey(property)) continue;
                                nobject.remove(property);
                            }
                            continue;
                        }
                        if (!method.equalsIgnoreCase("no-id") || !nobject.containsKey("id")) continue;
                        nobject.remove("id");
                    }
                } else {
                    String method = met.toString();
                    if (method.equalsIgnoreCase("cancel-positioning")) {
                        for (String property : POSITION_PROPERTIES) {
                            if (!nobject.containsKey(property)) continue;
                            nobject.remove(property);
                        }
                    } else if (method.equalsIgnoreCase("no-id") && nobject.containsKey("id")) {
                        nobject.remove("id");
                    }
                }
            }
            nobject.put("times", times - 1);
            lastpos = this.generateItem(parent, nobject, lastpos, origin, currentOptions);
        }
        return lastpos;
    }

    private boolean isPositionProperty(String key) {
        return POSITION_PROPERTIES.contains(key);
    }

    public Map<ItemInfo, Map<Integer, List<ItemInfo>>> getDynamicInfo() {
        return this.infoByAbsolutePosition;
    }

    public Map<ItemInfo, Integer> getLastPageNumbers() {
        return this.lastPageNumbers;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean getShowPageNumber() {
        return this.showPageNumber;
    }

    public SimpleInventories openForPlayer(Player player) {
        new GuiHolder(player, this, null, 0);
        return this;
    }

    public GuiHolder getCurrentGuiHolder(Player player) {
        Inventory top = player.getOpenInventory().getTopInventory();
        if (top != null) {
            InventoryHolder holder = InventoryUtils.getInventoryHolderWithoutSnapshot(top);
            if (holder instanceof GuiHolder) {
                return (GuiHolder)holder;
            }
            if (GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.containsKey(top)) {
                return GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.get(top);
            }
        }
        return null;
    }

    public boolean isAllowedToExecuteConsoleCommands() {
        return this.allowAccessToConsole;
    }

    public ItemInfo findItemInfoById(String id) {
        if (id.startsWith("\u00a7") || id.startsWith("$")) {
            id = id.substring(1);
        }
        return this.ids.get(id);
    }

    public boolean isAllowBungeecord() {
        return this.allowBungeecord;
    }

    public List<OpenCallback> getOpenCallbacks() {
        return this.openCallbacks;
    }

    public List<RenderCallback> getRenderCallbacks() {
        return this.renderCallbacks;
    }

    public List<PreClickCallback> getPreClickCallbacks() {
        return this.preClickCallbacks;
    }

    public List<BuyCallback> getBuyCallbacks() {
        return this.buyCallbacks;
    }

    public List<PostClickCallback> getPostClickCallbacks() {
        return this.postClickCallbacks;
    }

    public List<CloseCallback> getCloseCallbacks() {
        return this.closeCallbacks;
    }

    public LocalOptions getLocalOptions() {
        return this.localOptions;
    }
}

