/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;

public class FormatBuilder {
    private final List<Object> result;

    public FormatBuilder() {
        this(new ArrayList<Object>());
    }

    public List<Object> getResult() {
        return this.result;
    }

    public Item add(String shortFormat) {
        return this.add(StackParser.parseShortStack(shortFormat));
    }

    public Item add(Material mat) {
        return this.add(new ItemStack(mat));
    }

    public Item add(Material mat, int amount) {
        return this.add(new ItemStack(mat, amount));
    }

    @Deprecated
    public Item add(Material mat, int amount, short damage) {
        return this.add(new ItemStack(mat, amount, damage));
    }

    public Item add(ItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stack", stack);
        this.result.add(map);
        return new Item(map);
    }

    public FormatBuilder(List<Object> result) {
        this.result = result;
    }

    public static class Item {
        private Map<String, Object> map;

        public Item set(String key, Object value) {
            this.map.put(key, value);
            return this;
        }

        public Item setIf(String condition, String key, Object value) {
            return this.setIf(condition, key, value, null);
        }

        public Item setIf(String condition, final String key, final Object value, final Object elseValue) {
            if (!this.map.containsKey("conditions")) {
                this.map.put("conditions", new ArrayList());
            }
            HashMap<String, Object> nmap = new HashMap<String, Object>();
            nmap.put("if", condition);
            nmap.put("then", new HashMap<String, Object>(){
                {
                    this.put(key, value);
                }
            });
            if (elseValue != null) {
                nmap.put("else", new HashMap<String, Object>(){
                    {
                        this.put(key, elseValue);
                    }
                });
            }
            ((List)this.map.get("conditions")).add(nmap);
            return this;
        }

        public Item setVisible(boolean visible) {
            return this.set("visible", visible);
        }

        public Item setVisible(String condition) {
            return this.setIf(condition, "visible", true, false);
        }

        public Item setDisabled(boolean disabled) {
            return this.set("disabled", disabled);
        }

        public Item setDisabled(String condition) {
            return this.setIf(condition, "disabled", true, false);
        }

        public Item setId(String id) {
            return this.set("id", id);
        }

        public Item add(String shortFormat) {
            return this.add(StackParser.parseShortStack(shortFormat));
        }

        public Item add(Material mat) {
            return this.add(new ItemStack(mat));
        }

        public Item add(Material mat, int amount) {
            return this.add(new ItemStack(mat, amount));
        }

        @Deprecated
        public Item add(Material mat, int amount, short damage) {
            return this.add(new ItemStack(mat, amount, damage));
        }

        public Item add(ItemStack stack) {
            if (!this.map.containsKey("items")) {
                this.map.put("items", new ArrayList());
            }
            HashMap<String, Object> nmap = new HashMap<String, Object>();
            nmap.put("stack", stack);
            ((List)this.map.get("items")).add(nmap);
            return new Item(nmap);
        }

        public Item(Map<String, Object> map) {
            this.map = map;
        }
    }
}

