/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.dependencies;

import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DependencyLoader {
    private final String checkClass;
    private final String dependencyName;
    private final String dependencyVersion;

    public void load() {
        try {
            File library;
            File lib = new File("libs/");
            if (!lib.exists()) {
                lib.mkdir();
            }
            if (!(library = new File(lib, this.dependencyName.toLowerCase() + ".jar")).exists()) {
                Bukkit.getLogger().info("[ScreamingDependencyHelper] Obtaining " + this.dependencyName.toLowerCase() + ".jar version " + this.dependencyVersion + " for your server");
                Files.copy(new URL("https://repo.screamingsandals.org/public/org/screamingsandals/misc/" + this.dependencyName.toLowerCase() + "/" + this.dependencyVersion + "/" + this.dependencyName.toLowerCase() + "-" + this.dependencyVersion.toLowerCase() + ".jar").openStream(), Paths.get(library.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                Files.write(Paths.get(new File(lib, this.dependencyName.toLowerCase() + ".version").getAbsolutePath(), new String[0]), Collections.singletonList(this.dependencyVersion), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            if (!library.exists()) {
                throw new Exception("[ScreamingDependencyHelper] Can't obtain dependency: " + this.dependencyName);
            }
            Bukkit.getLogger().info("[ScreamingDependencyHelper] Loading " + this.dependencyName.toLowerCase() + ".jar");
            Plugin plugin = Bukkit.getPluginManager().loadPlugin(library);
            Bukkit.getPluginManager().enablePlugin(plugin);
            Bukkit.getLogger().info("[ScreamingDependencyHelper] " + this.dependencyName + " is loaded! Don't disable or reload this plugin!");
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public String getCheckClass() {
        return this.checkClass;
    }

    public String getDependencyName() {
        return this.dependencyName;
    }

    public String getDependencyVersion() {
        return this.dependencyVersion;
    }

    public DependencyLoader(String checkClass, String dependencyName, String dependencyVersion) {
        this.checkClass = checkClass;
        this.dependencyName = dependencyName;
        this.dependencyVersion = dependencyVersion;
    }
}

