/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.item.ItemProperty;
import org.screamingsandals.bedwars.lib.sgui.item.PlayerItemInfo;

public class ShopTransactionEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final SimpleInventories format;
    private final int price;
    private final String type;
    private final ItemStack stack;
    private final PlayerItemInfo item;
    private boolean cancel = false;
    private final ClickType clickType;
    private final boolean hasExecutions;
    private boolean runExecutions = false;

    public ShopTransactionEvent(Player player, SimpleInventories format, PlayerItemInfo item, int price, String type, ClickType clickType, boolean hasExecutions) {
        this.player = player;
        this.format = format;
        this.item = item;
        this.stack = item.getOriginal().getItem().clone();
        if (this.stack.hasItemMeta()) {
            ItemMeta meta = this.stack.getItemMeta();
            if (meta.hasDisplayName()) {
                meta.setDisplayName(format.processPlaceholders(player, meta.getDisplayName(), item));
            }
            if (meta.hasLore()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String str : meta.getLore()) {
                    lore.add(format.processPlaceholders(player, str, item));
                }
                meta.setLore(lore);
            }
            this.stack.setItemMeta(meta);
        }
        this.price = price;
        this.type = type;
        this.clickType = clickType;
        this.hasExecutions = hasExecutions;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean hasPlayerInInventory() {
        return this.hasPlayerInInventory(this.stack);
    }

    public boolean hasPlayerInInventory(ItemStack stack) {
        return this.player.getInventory().containsAtLeast(stack, stack.getAmount());
    }

    public HashMap<Integer, ItemStack> sellStack() {
        return this.sellStack(this.stack);
    }

    public HashMap<Integer, ItemStack> sellStack(ItemStack stack) {
        return this.player.getInventory().removeItem(new ItemStack[]{stack});
    }

    public HashMap<Integer, ItemStack> buyStack() {
        return this.buyStack(this.stack);
    }

    public HashMap<Integer, ItemStack> buyStack(ItemStack stack) {
        return this.player.getInventory().addItem(new ItemStack[]{stack});
    }

    public List<ItemProperty> getProperties() {
        return this.item.getProperties();
    }

    public boolean hasProperties() {
        return this.item.hasProperties();
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    public Player getPlayer() {
        return this.player;
    }

    public SimpleInventories getFormat() {
        return this.format;
    }

    public int getPrice() {
        return this.price;
    }

    public String getType() {
        return this.type;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public PlayerItemInfo getItem() {
        return this.item;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    public boolean isHasExecutions() {
        return this.hasExecutions;
    }

    public boolean isRunExecutions() {
        return this.runExecutions;
    }

    public void setRunExecutions(boolean runExecutions) {
        this.runExecutions = runExecutions;
    }
}

