/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.groovy.builder;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.screamingsandals.bedwars.lib.sgui.groovy.builder.GroovyItemBuilder;
import org.screamingsandals.bedwars.lib.sgui.groovy.builder.GroovyOnlyItemBuilder;
import org.screamingsandals.bedwars.lib.sgui.groovy.builder.IGroovyLocalOptionsBuilder;
import org.screamingsandals.bedwars.lib.sgui.groovy.utils.GroovyUtils;

public abstract class GroovyBuilder {
    public void category(String material) {
        this.item(material);
    }

    public void category(Material material) {
        this.item(material);
    }

    public void category(String material, Closure<GroovyItemBuilder> closure) {
        this.item(material, closure);
    }

    public void category(Material material, Closure<GroovyItemBuilder> closure) {
        this.item(material, closure);
    }

    public void item(String material) {
        this.internalAddItem(material);
    }

    public void item(Material material) {
        this.internalAddItem(material);
    }

    public void item(String material, Closure<GroovyItemBuilder> closure) {
        GroovyUtils.internalCallClosure(closure, new GroovyItemBuilder(this.internalAddItem(material)));
    }

    public void item(Material material, Closure<GroovyItemBuilder> closure) {
        GroovyUtils.internalCallClosure(closure, new GroovyItemBuilder(this.internalAddItem(material)));
    }

    public void categoryOptions(Closure<IGroovyLocalOptionsBuilder> closure) {
        GroovyUtils.internalCallClosure(closure, this.getCategoryOptions());
    }

    public abstract IGroovyLocalOptionsBuilder getCategoryOptions();

    public void cosmetic() {
        this.putItem(new HashMap<String, Object>(){
            {
                this.put("clone", "cosmetic");
            }
        });
    }

    public void cosmetic(Closure<GroovyItemBuilder> closure) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("clone", "cosmetic");
            }
        };
        this.putItem(map);
        GroovyUtils.internalCallClosure(closure, new GroovyItemBuilder((Map<String, Object>)map));
    }

    public void itemClone(final String clone) {
        this.putItem(new HashMap<String, Object>(){
            {
                this.put("clone", clone);
            }
        });
    }

    public void itemClone(final String clone, Closure<GroovyItemBuilder> closure) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("clone", clone);
            }
        };
        this.putItem(map);
        GroovyUtils.internalCallClosure(closure, new GroovyItemBuilder((Map<String, Object>)map));
    }

    public void include(final String include) {
        this.putItem(new HashMap<String, Object>(){
            {
                this.put("include", include);
            }
        });
    }

    public void hidden(final String id, Closure<GroovyOnlyItemBuilder> closure) {
        final ArrayList<Object> items = new ArrayList<Object>();
        this.putItem(new HashMap<String, Object>(){
            {
                this.put("id", id);
                this.put("write", false);
                this.put("items", items);
            }
        });
        GroovyUtils.internalCallClosure(closure, new GroovyOnlyItemBuilder(items));
    }

    public void hidden(final String id) {
        this.putItem(new HashMap<String, Object>(){
            {
                this.put("id", id);
                this.put("write", false);
            }
        });
    }

    public void insert(String insert, Closure<GroovyOnlyItemBuilder> closure) {
        this.insert(Collections.singletonList(insert), closure);
    }

    public void insert(final List<String> insert, Closure<GroovyOnlyItemBuilder> closure) {
        final ArrayList<Object> items = new ArrayList<Object>();
        this.putItem(new HashMap<String, Object>(){
            {
                this.put("insert", insert);
                this.put("items", items);
            }
        });
        GroovyUtils.internalCallClosure(closure, new GroovyOnlyItemBuilder(items));
    }

    protected abstract void putItem(Object var1);

    private Map<String, Object> internalAddItem(Object material) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> stack = new HashMap<String, Object>();
        if (material instanceof Material) {
            stack.put("type", material);
        } else {
            String obj = material.toString();
            char[] characters = obj.toCharArray();
            int lastEscapeIndex = -2;
            boolean buildingString = false;
            int building = 0;
            String buf = "";
            for (int i = 0; i < characters.length; ++i) {
                char c = characters[i];
                if (c == '\\' && lastEscapeIndex != i - 1) {
                    lastEscapeIndex = i;
                    continue;
                }
                if (buildingString) {
                    if ((c == '\"' || c == '\'') && lastEscapeIndex != i - 1) {
                        buildingString = false;
                        continue;
                    }
                    buf = buf + c;
                    continue;
                }
                if (building < 2 && buf.endsWith("repeat")) {
                    buf = buf.substring(0, buf.length() - 6).trim();
                    if (building == 0) {
                        stack.put("type", buf);
                    } else {
                        map.put("price", buf);
                    }
                    building = 2;
                    buf = "";
                    continue;
                }
                if (building == 0 && buf.endsWith("for")) {
                    building = 1;
                    buf = buf.substring(0, buf.length() - 3).trim();
                    stack.put("type", buf);
                    buf = "";
                    continue;
                }
                if ((c == '\"' || c == '\'') && lastEscapeIndex != i - 1) {
                    buildingString = true;
                    lastEscapeIndex = i;
                    continue;
                }
                buf = buf + c;
            }
            if (building == 0) {
                buf = buf.trim();
                stack.put("type", buf);
            } else if (building == 1) {
                map.put("price", buf);
            } else if (building == 2) {
                try {
                    map.put("times", Integer.parseInt(buf.trim()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        map.put("stack", stack);
        this.putItem(map);
        return map;
    }

    public void call(Closure<GroovyBuilder> closure) {
        GroovyUtils.internalCallClosure(closure, this);
    }
}

