/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.groovy.builder;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.screamingsandals.bedwars.lib.sgui.groovy.builder.IGroovyStackBuilder;
import org.screamingsandals.bedwars.lib.sgui.utils.EnchantmentSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.MaterialSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.PotionTypeSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.PotionTypeSearchEngine1_20_5;
import org.screamingsandals.bedwars.lib.sgui.utils.PotionTypeSearchEngine1_8_8;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;

public class GroovyBukkitStackBuilder
implements IGroovyStackBuilder {
    private final ItemStack stack;

    @Override
    public void amount(int amount) {
        this.stack.setAmount(amount);
    }

    @Override
    public void lore(List<String> lore) {
        ItemMeta meta = this.stack.getItemMeta();
        meta.setLore(lore);
        this.stack.setItemMeta(meta);
    }

    @Override
    public void name(String name) {
        ItemMeta meta = this.stack.getItemMeta();
        meta.setDisplayName(name);
        this.stack.setItemMeta(meta);
    }

    @Override
    public void type(String type) {
        ItemStack shortStack = StackParser.parseShortStack(type);
        this.type(shortStack.getType());
        this.durability(shortStack.getDurability());
        this.amount(shortStack.getAmount());
        ItemMeta shortMeta = shortStack.getItemMeta();
        if (shortMeta.hasDisplayName()) {
            this.name(shortMeta.getDisplayName());
        }
        if (shortMeta.hasLore()) {
            this.lore(shortMeta.getLore());
        }
    }

    @Override
    public void type(Material type) {
        this.stack.setType(type);
    }

    @Override
    public void durability(short durability) {
        this.stack.setDurability(durability);
    }

    @Override
    public void customModelData(int data) {
        ItemMeta meta = this.stack.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(data));
        this.stack.setItemMeta(meta);
    }

    @Override
    public void repair(int repair) {
        ItemMeta meta = this.stack.getItemMeta();
        if (meta instanceof Repairable) {
            ((Repairable)meta).setRepairCost(repair);
            this.stack.setItemMeta(meta);
        }
    }

    @Override
    public void flags(List<Object> flags) {
        ItemMeta meta = this.stack.getItemMeta();
        for (Object str : flags) {
            try {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)str.toString())});
            }
            catch (Throwable throwable) {}
        }
        this.stack.setItemMeta(meta);
    }

    @Override
    public void unbreakable(boolean unbreakable) {
        ItemMeta meta = this.stack.getItemMeta();
        meta.setUnbreakable(unbreakable);
        this.stack.setItemMeta(meta);
    }

    @Override
    public void enchant(String enchant, int level) {
        this.enchant(EnchantmentSearchEngine.searchEnchantment(enchant), level);
    }

    @Override
    public void enchant(Enchantment enchant, int level) {
        if (enchant != null) {
            ItemMeta meta = this.stack.getItemMeta();
            meta.addEnchant(enchant, level, true);
            this.stack.setItemMeta(meta);
        }
    }

    @Override
    public void potion(String potion) {
        if (MaterialSearchEngine.getVersionNumber() == 108) {
            this.stack.setDurability(PotionTypeSearchEngine1_8_8.find(potion).toDamageValue());
        } else {
            ItemMeta meta = this.stack.getItemMeta();
            if (meta instanceof PotionMeta) {
                if (MaterialSearchEngine.getVersionNumber() > 120 || MaterialSearchEngine.isV1_20_5()) {
                    PotionTypeSearchEngine1_20_5.setPotionType((PotionMeta)meta, PotionTypeSearchEngine1_20_5.find(potion));
                    this.stack.setItemMeta(meta);
                } else {
                    ((PotionMeta)meta).setBasePotionData(PotionTypeSearchEngine.find(potion));
                    this.stack.setItemMeta(meta);
                }
            }
        }
    }

    @Override
    public void potion(PotionType potion) {
        ItemMeta meta = this.stack.getItemMeta();
        if (meta instanceof PotionMeta) {
            if (MaterialSearchEngine.getVersionNumber() > 120 || MaterialSearchEngine.isV1_20_5()) {
                PotionTypeSearchEngine1_20_5.setPotionType((PotionMeta)meta, potion);
            } else {
                ((PotionMeta)meta).setBasePotionData(new PotionData(potion));
                this.stack.setItemMeta(meta);
            }
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public GroovyBukkitStackBuilder(ItemStack stack) {
        this.stack = stack;
    }
}

