/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.groovy.callback;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.lib.sgui.groovy.builder.GroovyAnimationBuilder;
import org.screamingsandals.bedwars.lib.sgui.groovy.builder.GroovyBukkitStackBuilder;
import org.screamingsandals.bedwars.lib.sgui.groovy.builder.GroovyLongStackBuilder;
import org.screamingsandals.bedwars.lib.sgui.groovy.builder.IGroovyStackBuilder;
import org.screamingsandals.bedwars.lib.sgui.groovy.utils.GroovyUtils;
import org.screamingsandals.bedwars.lib.sgui.item.PlayerItemInfo;
import org.screamingsandals.bedwars.lib.sgui.item.RenderCallback;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;

public class GroovyRenderCallback
implements RenderCallback {
    private final Closure<GroovyRenderBuilder> closure;

    @Override
    public void render(PlayerItemInfo info) {
        GroovyRenderBuilder builder = new GroovyRenderBuilder(info);
        GroovyUtils.internalCallClosure(this.closure, builder);
        if (builder.animationList != null) {
            info.setAnimation(StackParser.parseAll(builder.animationList));
        }
        if (builder.purgeStack != null) {
            info.setStack(StackParser.parse(builder.purgeStack));
        }
    }

    public Closure<GroovyRenderBuilder> getClosure() {
        return this.closure;
    }

    public GroovyRenderCallback(Closure<GroovyRenderBuilder> closure) {
        this.closure = closure;
    }

    public static class GroovyRenderBuilder {
        private final PlayerItemInfo info;
        private List<Object> animationList;
        private Map<String, Object> purgeStack;

        public void disabled(boolean disabled) {
            this.info.setDisabled(disabled);
        }

        public void visible(boolean visible) {
            this.info.setVisible(visible);
        }

        public GroovyAnimationBuilder getAnimation() {
            if (this.animationList == null) {
                this.animationList = new ArrayList<Object>();
            }
            return new GroovyAnimationBuilder(this.animationList);
        }

        public void animation(Closure<GroovyAnimationBuilder> closure) {
            GroovyUtils.internalCallClosure(closure, this.getAnimation());
        }

        public IGroovyStackBuilder getStack() {
            if (this.purgeStack != null) {
                return new GroovyLongStackBuilder(this.purgeStack);
            }
            return new GroovyBukkitStackBuilder(this.info.getStack());
        }

        public IGroovyStackBuilder getClearStack() {
            if (this.purgeStack == null) {
                this.purgeStack = new HashMap<String, Object>();
            }
            return new GroovyLongStackBuilder(this.purgeStack);
        }

        public void stack(Closure<IGroovyStackBuilder> closure) {
            GroovyUtils.internalCallClosure(closure, this.getStack());
        }

        public void clearStack(Closure<IGroovyStackBuilder> closure) {
            GroovyUtils.internalCallClosure(closure, this.getClearStack());
        }

        public String process(String raw) {
            return this.info.getFormat().processPlaceholders(this.info.getPlayer(), raw, this.info);
        }

        public Player getPlayer() {
            return this.info.getPlayer();
        }

        public void player(Closure<Player> closure) {
            GroovyUtils.internalCallClosure(closure, this.getPlayer());
        }

        public GroovyRenderBuilder(PlayerItemInfo info) {
            this.info = info;
        }

        public PlayerItemInfo getInfo() {
            return this.info;
        }
    }
}

