/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.events.GenerateItemEvent;
import org.screamingsandals.bedwars.lib.sgui.events.OpenInventoryEvent;
import org.screamingsandals.bedwars.lib.sgui.inventory.GuiAnimator;
import org.screamingsandals.bedwars.lib.sgui.inventory.LocalOptions;
import org.screamingsandals.bedwars.lib.sgui.item.ItemInfo;
import org.screamingsandals.bedwars.lib.sgui.item.PlayerItemInfo;
import org.screamingsandals.bedwars.lib.sgui.utils.AnvilGUI;
import org.screamingsandals.bedwars.lib.sgui.utils.InventoryUtils;

public class GuiHolder
implements InventoryHolder {
    public static final Map<Inventory, GuiHolder> TILE_ENTITY_HOLDER_CONVERTOR = new ConcurrentHashMap<Inventory, GuiHolder>();
    private final Player player;
    private final Inventory inv;
    private SimpleInventories format;
    private List<ItemInfo> items;
    private Map<Integer, PlayerItemInfo> itemsInInventory;
    private ItemInfo parent;
    private int page;
    private boolean animationExists = false;
    private List<PlayerItemInfo> itemsWithAnimation;
    private GuiAnimator animator;
    private LocalOptions localOptions;

    public GuiHolder(Player player, SimpleInventories format, ItemInfo parent, int page) {
        this.format = format;
        this.parent = parent;
        this.page = page;
        this.items = this.getItemsInfo();
        this.player = player;
        LocalOptions localOptions = this.localOptions = parent != null ? parent.getLocalOptions() : format.getLocalOptions();
        if (this.localOptions.getInventoryType() == InventoryType.CHEST) {
            this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(this.localOptions.getItems_on_row() * this.localOptions.getRender_actual_rows()), (String)(format.getPrefix() + (format.getShowPageNumber() ? "\u00a7r - " + (page + 1) : "")));
        } else if (this.localOptions.getInventoryType() == InventoryType.ANVIL) {
            AnvilGUI gui = new AnvilGUI(format.getPluginForRunnables(), player, this, new AnvilGUI.AnvilClickEventHandler(){

                @Override
                public void onAnvilClick(AnvilGUI.AnvilClickEvent event) {
                }
            });
            gui.setTitle(format.getPrefix() + (format.getShowPageNumber() ? "\u00a7r - " + (page + 1) : ""));
            gui.setDefaultText("");
            this.inv = gui;
        } else {
            this.inv = Bukkit.createInventory((InventoryHolder)this, (InventoryType)this.localOptions.getInventoryType(), (String)(format.getPrefix() + (format.getShowPageNumber() ? "\u00a7r - " + (page + 1) : "")));
        }
        this.itemsInInventory = new HashMap<Integer, PlayerItemInfo>();
        this.itemsWithAnimation = new ArrayList<PlayerItemInfo>();
        this.repaint();
        OpenInventoryEvent event = new OpenInventoryEvent(this.player, this.format, this.inv, this.parent, this.page);
        format.getOpenCallbacks().forEach(openCallback -> openCallback.open(event));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (InventoryUtils.getInventoryHolderWithoutSnapshot(this.inv) != this) {
            TILE_ENTITY_HOLDER_CONVERTOR.put(this.inv, this);
        }
        if (this.inv instanceof AnvilGUI) {
            ((AnvilGUI)this.inv).open();
            TILE_ENTITY_HOLDER_CONVERTOR.put(((AnvilGUI)this.inv).inventory, this);
        } else {
            this.player.openInventory(this.inv);
        }
    }

    public void repaint() {
        int a;
        this.animationExists = false;
        this.inv.clear();
        this.itemsInInventory.clear();
        this.itemsWithAnimation.clear();
        if (this.animator != null) {
            try {
                this.animator.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.animator = null;
        }
        if (this.parent != null) {
            this.safePutStackToInventory(this.localOptions.getRender_header_start(), this.localOptions.getBackItem().clone());
        } else {
            this.safePutStackToInventory(this.localOptions.getRender_header_start(), this.localOptions.getCosmeticItem().clone());
        }
        for (a = 1; a < this.localOptions.getItems_on_row(); ++a) {
            this.safePutStackToInventory(this.localOptions.getRender_header_start() + a, this.localOptions.getCosmeticItem().clone());
        }
        if (this.page > 0) {
            this.safePutStackToInventory(this.localOptions.getRender_footer_start(), this.localOptions.getPageBackItem().clone());
        } else {
            this.safePutStackToInventory(this.localOptions.getRender_footer_start(), this.localOptions.getCosmeticItem().clone());
        }
        for (a = 1; a < this.localOptions.getItems_on_row(); ++a) {
            this.safePutStackToInventory(this.localOptions.getRender_footer_start() + a, this.localOptions.getCosmeticItem().clone());
        }
        if (this.format.getLastPageNumbers().get(this.parent) > this.page) {
            this.safePutStackToInventory(this.localOptions.getRender_footer_start() + this.localOptions.getItems_on_row() - 1, this.localOptions.getPageForwardItem());
        } else {
            this.safePutStackToInventory(this.localOptions.getRender_footer_start() + this.localOptions.getItems_on_row() - 1, this.localOptions.getCosmeticItem());
        }
        for (ItemInfo item : this.items) {
            ItemStack stack = item.getItem();
            ItemStack cloned = stack.clone();
            PlayerItemInfo playersInfo = new PlayerItemInfo(this.player, item, cloned, item.isVisible(), item.isDisabled());
            if (cloned.hasItemMeta()) {
                ItemMeta meta = cloned.getItemMeta();
                if (meta.hasDisplayName()) {
                    meta.setDisplayName(this.format.processPlaceholders(this.player, meta.getDisplayName(), playersInfo));
                }
                if (meta.hasLore()) {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String str : meta.getLore()) {
                        lore.add(this.format.processPlaceholders(this.player, str, playersInfo));
                    }
                    meta.setLore(lore);
                }
                cloned.setItemMeta(meta);
                playersInfo.setStack(cloned);
            }
            GenerateItemEvent event = new GenerateItemEvent(this.format, playersInfo, this.player);
            Bukkit.getPluginManager().callEvent((Event)event);
            int cpos = item.getPosition() % this.localOptions.getItemsOnPage() + this.localOptions.getRender_offset();
            if (!playersInfo.isVisible()) continue;
            if (playersInfo.hasAnimation()) {
                this.animationExists = true;
                this.itemsWithAnimation.add(playersInfo);
            }
            this.safePutStackToInventory(cpos, event.getStack());
            this.itemsInInventory.put(cpos, playersInfo);
        }
        if (this.animationExists && this.format.isAnimationsEnabled()) {
            this.animator = new GuiAnimator(this, this.itemsWithAnimation);
            this.animator.runTaskTimer(this.format.getPluginForRunnables(), 0L, 20L);
        }
    }

    public PlayerItemInfo getItemInfoOnPosition(int position) {
        return this.itemsInInventory.get(position);
    }

    public SimpleInventories getFormat() {
        return this.format;
    }

    public void setFormat(SimpleInventories format) {
        this.format = format;
        this.items = this.getItemsInfo();
    }

    public List<ItemInfo> getItems() {
        return new ArrayList<ItemInfo>(this.items);
    }

    public ItemInfo getParent() {
        return this.parent;
    }

    public int getPage() {
        return this.page;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public void safePutStackToInventory(int i, ItemStack stack) {
        if (i < this.inv.getSize()) {
            this.inv.setItem(i, stack);
        }
    }

    private List<ItemInfo> getItemsInfo() {
        Map<Integer, List<ItemInfo>> map;
        ArrayList<ItemInfo> items = new ArrayList<ItemInfo>();
        if (this.format.getDynamicInfo().containsKey(null) && (map = this.format.getDynamicInfo().get(this.parent)).containsKey(this.page)) {
            items.addAll((Collection<ItemInfo>)map.get(this.page));
        }
        return items;
    }

    public LocalOptions getLocalOptions() {
        return this.localOptions;
    }
}

