/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.inventory;

import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;

public class LocalOptions {
    public static final int ROWS = 4;
    public static final int ITEMS_ON_ROW = 9;
    public static final int RENDER_ACTUAL_ROWS = 6;
    public static final int RENDER_OFFSET = 9;
    public static final int RENDER_HEADER_START = 0;
    public static final int RENDER_FOOTER_START = 45;
    private ItemStack backItem = new ItemStack(Material.BARRIER);
    private ItemStack pageBackItem = new ItemStack(Material.ARROW);
    private ItemStack pageForwardItem = new ItemStack(Material.ARROW);
    private ItemStack cosmeticItem = new ItemStack(Material.AIR);
    private int rows = 4;
    private int items_on_row = 9;
    private int render_actual_rows = 6;
    private int render_offset = 9;
    private int render_header_start = 0;
    private int render_footer_start = 45;
    private InventoryType inventoryType = InventoryType.CHEST;

    public LocalOptions(LocalOptions parent) {
        this.setBackItem(parent.getBackItem().clone());
        this.setPageBackItem(parent.getPageBackItem().clone());
        this.setPageForwardItem(parent.getPageForwardItem().clone());
        this.setCosmeticItem(parent.getCosmeticItem().clone());
        this.setRows(parent.getRows());
        this.setItems_on_row(parent.getItems_on_row());
        this.setRender_actual_rows(parent.getRender_actual_rows());
        this.setRender_offset(parent.getRender_offset());
        this.setRender_header_start(parent.getRender_header_start());
        this.setRender_footer_start(parent.getRender_footer_start());
        this.setInventoryType(parent.getInventoryType());
    }

    public int getItemsOnPage() {
        return this.items_on_row * this.rows;
    }

    public static LocalOptions deserialize(ConfigurationSection map) {
        LocalOptions options = new LocalOptions();
        options.deserializeInternal(map);
        return options;
    }

    public static LocalOptions deserialize(LocalOptions parent, ConfigurationSection map) {
        LocalOptions options = new LocalOptions(parent);
        options.deserializeInternal(map);
        return options;
    }

    protected void deserializeInternal(ConfigurationSection map) {
        LocalOptions.entry(map, "backItem", entry -> this.setBackItem(StackParser.parse(entry)));
        LocalOptions.entry(map, "pageBackItem", entry -> this.setPageBackItem(StackParser.parse(entry)));
        LocalOptions.entry(map, "pageForwardItem", entry -> this.setPageForwardItem(StackParser.parse(entry)));
        LocalOptions.entry(map, "cosmeticItem", entry -> this.setCosmeticItem(StackParser.parse(entry)));
        LocalOptions.entry(map, "rows", entry -> this.setRows(((Number)entry).intValue()));
        LocalOptions.entry(map, "render_actual_rows", entry -> this.setRender_actual_rows(((Number)entry).intValue()));
        LocalOptions.entry(map, "render_offset", entry -> this.setRender_offset(((Number)entry).intValue()));
        LocalOptions.entry(map, "render_header_start", entry -> this.setRender_header_start(((Number)entry).intValue()));
        LocalOptions.entry(map, "render_footer_start", entry -> this.setRender_footer_start(((Number)entry).intValue()));
        LocalOptions.entry(map, "inventoryType", entry -> this.setInventoryType(InventoryType.valueOf((String)entry.toString().toUpperCase())));
        LocalOptions.entry(map, "items_on_row", entry -> this.setItems_on_row(((Number)entry).intValue()));
    }

    protected static void entry(ConfigurationSection map, String path, Consumer<Object> consumer) {
        if (map.contains(path)) {
            try {
                consumer.accept(map.get(path));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ItemStack getBackItem() {
        return this.backItem;
    }

    public ItemStack getPageBackItem() {
        return this.pageBackItem;
    }

    public ItemStack getPageForwardItem() {
        return this.pageForwardItem;
    }

    public ItemStack getCosmeticItem() {
        return this.cosmeticItem;
    }

    public int getRows() {
        return this.rows;
    }

    public int getItems_on_row() {
        return this.items_on_row;
    }

    public int getRender_actual_rows() {
        return this.render_actual_rows;
    }

    public int getRender_offset() {
        return this.render_offset;
    }

    public int getRender_header_start() {
        return this.render_header_start;
    }

    public int getRender_footer_start() {
        return this.render_footer_start;
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public void setBackItem(ItemStack backItem) {
        this.backItem = backItem;
    }

    public void setPageBackItem(ItemStack pageBackItem) {
        this.pageBackItem = pageBackItem;
    }

    public void setPageForwardItem(ItemStack pageForwardItem) {
        this.pageForwardItem = pageForwardItem;
    }

    public void setCosmeticItem(ItemStack cosmeticItem) {
        this.cosmeticItem = cosmeticItem;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setItems_on_row(int items_on_row) {
        this.items_on_row = items_on_row;
    }

    public void setRender_actual_rows(int render_actual_rows) {
        this.render_actual_rows = render_actual_rows;
    }

    public void setRender_offset(int render_offset) {
        this.render_offset = render_offset;
    }

    public void setRender_header_start(int render_header_start) {
        this.render_header_start = render_header_start;
    }

    public void setRender_footer_start(int render_footer_start) {
        this.render_footer_start = render_footer_start;
    }

    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalOptions)) {
            return false;
        }
        LocalOptions other = (LocalOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getItems_on_row() != other.getItems_on_row()) {
            return false;
        }
        if (this.getRender_actual_rows() != other.getRender_actual_rows()) {
            return false;
        }
        if (this.getRender_offset() != other.getRender_offset()) {
            return false;
        }
        if (this.getRender_header_start() != other.getRender_header_start()) {
            return false;
        }
        if (this.getRender_footer_start() != other.getRender_footer_start()) {
            return false;
        }
        ItemStack this$backItem = this.getBackItem();
        ItemStack other$backItem = other.getBackItem();
        if (this$backItem == null ? other$backItem != null : !this$backItem.equals(other$backItem)) {
            return false;
        }
        ItemStack this$pageBackItem = this.getPageBackItem();
        ItemStack other$pageBackItem = other.getPageBackItem();
        if (this$pageBackItem == null ? other$pageBackItem != null : !this$pageBackItem.equals(other$pageBackItem)) {
            return false;
        }
        ItemStack this$pageForwardItem = this.getPageForwardItem();
        ItemStack other$pageForwardItem = other.getPageForwardItem();
        if (this$pageForwardItem == null ? other$pageForwardItem != null : !this$pageForwardItem.equals(other$pageForwardItem)) {
            return false;
        }
        ItemStack this$cosmeticItem = this.getCosmeticItem();
        ItemStack other$cosmeticItem = other.getCosmeticItem();
        if (this$cosmeticItem == null ? other$cosmeticItem != null : !this$cosmeticItem.equals(other$cosmeticItem)) {
            return false;
        }
        InventoryType this$inventoryType = this.getInventoryType();
        InventoryType other$inventoryType = other.getInventoryType();
        return !(this$inventoryType == null ? other$inventoryType != null : !this$inventoryType.equals(other$inventoryType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRows();
        result = result * 59 + this.getItems_on_row();
        result = result * 59 + this.getRender_actual_rows();
        result = result * 59 + this.getRender_offset();
        result = result * 59 + this.getRender_header_start();
        result = result * 59 + this.getRender_footer_start();
        ItemStack $backItem = this.getBackItem();
        result = result * 59 + ($backItem == null ? 43 : $backItem.hashCode());
        ItemStack $pageBackItem = this.getPageBackItem();
        result = result * 59 + ($pageBackItem == null ? 43 : $pageBackItem.hashCode());
        ItemStack $pageForwardItem = this.getPageForwardItem();
        result = result * 59 + ($pageForwardItem == null ? 43 : $pageForwardItem.hashCode());
        ItemStack $cosmeticItem = this.getCosmeticItem();
        result = result * 59 + ($cosmeticItem == null ? 43 : $cosmeticItem.hashCode());
        InventoryType $inventoryType = this.getInventoryType();
        result = result * 59 + ($inventoryType == null ? 43 : $inventoryType.hashCode());
        return result;
    }

    public String toString() {
        return "LocalOptions(backItem=" + this.getBackItem() + ", pageBackItem=" + this.getPageBackItem() + ", pageForwardItem=" + this.getPageForwardItem() + ", cosmeticItem=" + this.getCosmeticItem() + ", rows=" + this.getRows() + ", items_on_row=" + this.getItems_on_row() + ", render_actual_rows=" + this.getRender_actual_rows() + ", render_offset=" + this.getRender_offset() + ", render_header_start=" + this.getRender_header_start() + ", render_footer_start=" + this.getRender_footer_start() + ", inventoryType=" + this.getInventoryType() + ")";
    }

    public LocalOptions() {
    }
}

