/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.inventory;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.lib.sgui.inventory.LocalOptions;
import org.screamingsandals.bedwars.lib.sgui.placeholders.AdvancedPlaceholderParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.PlaceholderConstantParser;
import org.screamingsandals.bedwars.lib.sgui.placeholders.PlaceholderParser;

public class Options
extends LocalOptions {
    private final Plugin plugin;
    private boolean genericShop = false;
    private boolean genericShopPriceTypeRequired = true;
    private boolean animationsEnabled = false;
    private boolean showPageNumber = true;
    private String prefix = "Inventory";
    private final Map<String, PlaceholderParser> placeholders = new HashMap<String, PlaceholderParser>();
    private final Map<String, AdvancedPlaceholderParser> advancedPlaceholders = new HashMap<String, AdvancedPlaceholderParser>();
    private boolean allowAccessToConsole = false;
    private boolean allowBungeecordPlayerSending = false;

    public boolean registerPlaceholder(String name, String value) {
        return this.registerPlaceholder(name, new PlaceholderConstantParser(value));
    }

    public boolean registerPlaceholder(String name, PlaceholderParser parser) {
        if (name.contains(".") || name.contains(":") || name.contains("%") || name.contains(" ")) {
            return false;
        }
        this.placeholders.put(name, parser);
        return true;
    }

    public boolean registerPlaceholder(String name, AdvancedPlaceholderParser parser) {
        if (name.contains(".") || name.contains(":") || name.contains("%") || name.contains(" ")) {
            return false;
        }
        this.advancedPlaceholders.put(name, parser);
        return true;
    }

    public static Options deserialize(ConfigurationSection map, Plugin plugin) {
        Options options = new Options(plugin);
        options.deserializeInternal(map);
        return options;
    }

    @Override
    protected void deserializeInternal(ConfigurationSection map) {
        super.deserializeInternal(map);
        Options.entry(map, "genericShop", entry -> this.setGenericShop((Boolean)entry));
        Options.entry(map, "genericShopPriceTypeRequired", entry -> this.setGenericShopPriceTypeRequired((Boolean)entry));
        Options.entry(map, "animationsEnabled", entry -> this.setAnimationsEnabled((Boolean)entry));
        Options.entry(map, "showPageNumber", entry -> this.setShowPageNumber((Boolean)entry));
        Options.entry(map, "prefix", entry -> this.setPrefix(entry.toString()));
        Options.entry(map, "allowAccessToConsole", entry -> this.setAllowAccessToConsole((Boolean)entry));
        Options.entry(map, "allowBungeecordPlayerSending", entry -> this.setAllowBungeecordPlayerSending((Boolean)entry));
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isGenericShop() {
        return this.genericShop;
    }

    public boolean isGenericShopPriceTypeRequired() {
        return this.genericShopPriceTypeRequired;
    }

    public boolean isAnimationsEnabled() {
        return this.animationsEnabled;
    }

    public boolean isShowPageNumber() {
        return this.showPageNumber;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Map<String, PlaceholderParser> getPlaceholders() {
        return this.placeholders;
    }

    public Map<String, AdvancedPlaceholderParser> getAdvancedPlaceholders() {
        return this.advancedPlaceholders;
    }

    public boolean isAllowAccessToConsole() {
        return this.allowAccessToConsole;
    }

    public boolean isAllowBungeecordPlayerSending() {
        return this.allowBungeecordPlayerSending;
    }

    public void setGenericShop(boolean genericShop) {
        this.genericShop = genericShop;
    }

    public void setGenericShopPriceTypeRequired(boolean genericShopPriceTypeRequired) {
        this.genericShopPriceTypeRequired = genericShopPriceTypeRequired;
    }

    public void setAnimationsEnabled(boolean animationsEnabled) {
        this.animationsEnabled = animationsEnabled;
    }

    public void setShowPageNumber(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setAllowAccessToConsole(boolean allowAccessToConsole) {
        this.allowAccessToConsole = allowAccessToConsole;
    }

    public void setAllowBungeecordPlayerSending(boolean allowBungeecordPlayerSending) {
        this.allowBungeecordPlayerSending = allowBungeecordPlayerSending;
    }

    public Options(Plugin plugin) {
        this.plugin = plugin;
    }
}

