/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.item;

import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.inventory.LocalOptions;
import org.screamingsandals.bedwars.lib.sgui.inventory.Origin;
import org.screamingsandals.bedwars.lib.sgui.item.ItemProperty;
import org.screamingsandals.bedwars.lib.sgui.item.RenderCallback;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.Condition;
import org.screamingsandals.bedwars.lib.sgui.utils.MapReader;

public class ItemInfo {
    private ItemInfo parent;
    private int position;
    private ItemStack item;
    private List<ItemStack> animation;
    private boolean visible = false;
    private boolean disabled = false;
    private String id;
    private List<ItemProperty> properties;
    private Map<String, Object> data;
    private ItemStack book;
    private SimpleInventories format;
    private Map<Condition, Map<String, Object>> conditions;
    private Origin origin;
    private boolean written;
    private LocalOptions localOptions;
    private List<RenderCallback> renderCallbacks;
    public int lastpos = 0;

    public ItemInfo(SimpleInventories format, ItemInfo parent, ItemStack item, int position, boolean visible, boolean disabled, String id, List<ItemProperty> properties, Map<String, Object> data, List<ItemStack> animation, Map<Condition, Map<String, Object>> conditions, Origin origin, boolean written, List<RenderCallback> renderCallbacks, LocalOptions localOptions) {
        this.format = format;
        this.parent = parent;
        this.item = item;
        this.position = position;
        this.visible = visible;
        this.disabled = disabled;
        this.id = id;
        this.properties = properties;
        this.data = data;
        this.animation = animation;
        this.conditions = conditions;
        this.origin = origin;
        this.written = written;
        this.renderCallbacks = renderCallbacks;
        this.localOptions = localOptions;
    }

    public LocalOptions getLocalOptions() {
        return this.localOptions != null ? this.localOptions : (this.parent != null ? this.parent.getLocalOptions() : this.format.getLocalOptions());
    }

    public int getPosition() {
        return this.position;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemInfo getParent() {
        return this.parent;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getId() {
        return this.id;
    }

    public List<ItemProperty> getProperties() {
        return this.properties;
    }

    @Deprecated
    public Map<String, Object> getData() {
        return this.data;
    }

    public MapReader getReader(Player owner) {
        return new MapReader(this.format, this.data, owner, null);
    }

    public List<ItemStack> getAnimation() {
        return this.animation;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasAnimation() {
        return this.animation != null && !this.animation.isEmpty();
    }

    public ItemStack getBook() {
        return this.book;
    }

    public void setBook(ItemStack book) {
        this.book = book;
    }

    public boolean hasBook() {
        return this.book != null;
    }

    public SimpleInventories getFormat() {
        return this.format;
    }

    public Map<Condition, Map<String, Object>> getConditions() {
        return this.conditions;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public boolean isWritten() {
        return this.written;
    }

    public List<RenderCallback> getRenderCallbacks() {
        return this.renderCallbacks;
    }
}

