/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.inventory.Origin;
import org.screamingsandals.bedwars.lib.sgui.item.ItemInfo;
import org.screamingsandals.bedwars.lib.sgui.item.ItemProperty;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.Condition;
import org.screamingsandals.bedwars.lib.sgui.utils.MapReader;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;

public class PlayerItemInfo {
    private ItemInfo original;
    private ItemStack stack;
    private boolean visible;
    private boolean disabled;
    private List<ItemStack> animation;
    private Player player;
    private Map<String, Object> data;

    public PlayerItemInfo(Player player, ItemInfo original, ItemStack stack, boolean visible, boolean disabled) {
        this.player = player;
        this.original = original;
        this.stack = stack;
        this.visible = visible;
        this.disabled = disabled;
        if (original.hasAnimation()) {
            this.animation = new ArrayList<ItemStack>();
            for (ItemStack anim : original.getAnimation()) {
                this.animation.add(anim.clone());
            }
        }
        this.data = original.getData();
        Map<Condition, Map<String, Object>> conditions = original.getConditions();
        for (Map.Entry<Condition, Map<String, Object>> entry : conditions.entrySet()) {
            Condition cond = entry.getKey();
            if (!cond.process(player, this)) continue;
            for (Map.Entry<String, Object> change : entry.getValue().entrySet()) {
                this.data.put(change.getKey(), change.getValue());
                if (change.getKey().equals("visible")) {
                    this.visible = (Boolean)change.getValue();
                    continue;
                }
                if (change.getKey().equals("disabled")) {
                    this.disabled = (Boolean)change.getValue();
                    continue;
                }
                if (change.getKey().equals("stack")) {
                    this.stack = StackParser.parse(change.getValue());
                    continue;
                }
                if (!change.getKey().equals("animation")) continue;
                this.animation = StackParser.parseAll((List)change.getValue());
            }
        }
        original.getRenderCallbacks().forEach(callback -> callback.render(this));
        this.getFormat().getRenderCallbacks().forEach(renderCallback -> renderCallback.render(this));
    }

    @Deprecated
    public ItemInfo getOriginal() {
        return this.original;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getId() {
        return this.original.getId();
    }

    public ItemInfo getParent() {
        return this.original.getParent();
    }

    public int getPosition() {
        return this.original.getPosition();
    }

    public List<ItemProperty> getProperties() {
        return this.original.getProperties();
    }

    @Deprecated
    public Map<String, Object> getData() {
        return this.data;
    }

    public MapReader getReader() {
        return new MapReader(this.original.getFormat(), this.data, this.player, this);
    }

    public boolean hasId() {
        return this.getId() != null;
    }

    public boolean hasProperties() {
        return this.getProperties() != null && !this.getProperties().isEmpty();
    }

    public boolean hasData() {
        return this.getData() != null && !this.getData().isEmpty();
    }

    public boolean hasAnimation() {
        return this.animation != null && !this.animation.isEmpty();
    }

    public List<ItemStack> getAnimation() {
        return this.animation;
    }

    public void setAnimation(List<ItemStack> animation) {
        this.animation = animation;
    }

    public SimpleInventories getFormat() {
        return this.original.getFormat();
    }

    public Map<Condition, Map<String, Object>> getConditions() {
        return this.original.getConditions();
    }

    public Origin getOrigin() {
        return this.original.getOrigin();
    }

    public Player getPlayer() {
        return this.player;
    }
}

