/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.listeners;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.events.CloseInventoryEvent;
import org.screamingsandals.bedwars.lib.sgui.events.PostActionEvent;
import org.screamingsandals.bedwars.lib.sgui.events.PreActionEvent;
import org.screamingsandals.bedwars.lib.sgui.events.ShopTransactionEvent;
import org.screamingsandals.bedwars.lib.sgui.inventory.GuiHolder;
import org.screamingsandals.bedwars.lib.sgui.inventory.LocalOptions;
import org.screamingsandals.bedwars.lib.sgui.item.BuyCallback;
import org.screamingsandals.bedwars.lib.sgui.item.ItemInfo;
import org.screamingsandals.bedwars.lib.sgui.item.PlayerItemInfo;
import org.screamingsandals.bedwars.lib.sgui.item.PostClickCallback;
import org.screamingsandals.bedwars.lib.sgui.item.PreClickCallback;
import org.screamingsandals.bedwars.lib.sgui.utils.BookUtils;
import org.screamingsandals.bedwars.lib.sgui.utils.InventoryUtils;
import org.screamingsandals.bedwars.lib.sgui.utils.MapReader;

public class InventoryListener
implements Listener {
    public static void init(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(), plugin);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.isCancelled() || !(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory primaryInventory = e.getInventory();
        InventoryHolder possibleHolder = InventoryUtils.getInventoryHolderWithoutSnapshot(primaryInventory);
        if (GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.containsKey(primaryInventory)) {
            possibleHolder = GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.get(primaryInventory);
        }
        if (possibleHolder instanceof GuiHolder) {
            Player player = (Player)e.getWhoClicked();
            Inventory inventory = this.getInventory(e.getView(), e.getRawSlot());
            if (!primaryInventory.equals(inventory)) {
                if (e.getClick().isShiftClick() || e.getClick().isKeyboardClick() || e.getClick().isCreativeAction()) {
                    e.setCancelled(true);
                }
                return;
            }
            e.setCancelled(true);
            GuiHolder holder = (GuiHolder)possibleHolder;
            ItemInfo parent = holder.getParent();
            int page = holder.getPage();
            int slot = e.getSlot();
            SimpleInventories format = holder.getFormat();
            PlayerItemInfo playersItem = holder.getItemInfoOnPosition(slot);
            ItemInfo originalItem = playersItem != null ? playersItem.getOriginal() : null;
            LocalOptions localOptions = parent != null ? parent.getLocalOptions() : format.getLocalOptions();
            PreActionEvent event = new PreActionEvent(player, format, inventory, parent, playersItem, e.getClick());
            if (playersItem != null && playersItem.getReader().containsKey("preclickcallbacks")) {
                List preclickcallbacks = (List)playersItem.getReader().get("preclickcallbacks");
                preclickcallbacks.forEach(callback -> ((PreClickCallback)callback).preClick(event));
            }
            format.getPreClickCallbacks().forEach(preClickCallback -> preClickCallback.preClick(event));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                player.closeInventory();
                return;
            }
            if (playersItem == null) {
                ItemStack cur = e.getCurrentItem();
                ItemStack back = localOptions.getBackItem();
                ItemStack pageBack = localOptions.getPageBackItem();
                ItemStack pageForward = localOptions.getPageForwardItem();
                if (back.equals((Object)cur) && slot == localOptions.getRender_header_start()) {
                    if (parent != null) {
                        ItemInfo parentOfParent = parent.getParent();
                        LocalOptions localOptionsOfParentOfParent = parentOfParent != null ? parentOfParent.getLocalOptions() : format.getLocalOptions();
                        int pageOfParent = 0;
                        if (parent.isWritten()) {
                            pageOfParent = parent.getPosition() / localOptionsOfParentOfParent.getItemsOnPage();
                        }
                        new GuiHolder(player, format, parentOfParent, pageOfParent);
                    }
                } else if (pageBack.equals((Object)cur) && slot == localOptions.getRender_footer_start()) {
                    if (page > 0) {
                        new GuiHolder(player, format, parent, page - 1);
                    }
                } else if (pageForward.equals((Object)cur) && slot == localOptions.getRender_footer_start() + localOptions.getItems_on_row() - 1 && format.getLastPageNumbers().get(parent) > page) {
                    new GuiHolder(player, format, parent, page + 1);
                }
                return;
            }
            if (playersItem.isDisabled()) {
                return;
            }
            if (format.getDynamicInfo().containsKey(originalItem)) {
                new GuiHolder(player, format, originalItem, 0);
                return;
            }
            if (playersItem.getOriginal().hasBook()) {
                player.closeInventory();
                ItemStack book = playersItem.getOriginal().getBook();
                int heldslot = player.getInventory().getHeldItemSlot();
                ItemStack oldItem = player.getInventory().getItem(heldslot);
                player.getInventory().setItem(heldslot, book);
                BookUtils.openBook(player);
                player.getInventory().setItem(heldslot, oldItem);
                return;
            }
            MapReader originalData = playersItem.getReader();
            if (originalData.containsKey("locate")) {
                String locate = originalData.getString("locate");
                if (locate.startsWith("\u00a7") || locate.startsWith("$")) {
                    ItemInfo info = format.findItemInfoById(locate);
                    if (info != null && format.getDynamicInfo().containsKey(info)) {
                        new GuiHolder(player, format, info, 0);
                        return;
                    }
                } else if (locate.equalsIgnoreCase("main")) {
                    new GuiHolder(player, format, null, 0);
                    return;
                }
            }
            if (format.isGenericShopEnabled() && originalData.containsKey("price") && (originalData.containsKey("price-type") || !format.isPriceTypeRequired())) {
                int price = originalData.getInt("price");
                String type = originalData.getString("price-type", "default");
                ShopTransactionEvent shopEvent = new ShopTransactionEvent(player, format, playersItem, price, type, e.getClick(), originalData.containsKey("execute"));
                if (playersItem.getReader().containsKey("buycallbacks")) {
                    List buycallbacks = (List)playersItem.getReader().get("buycallbacks");
                    buycallbacks.forEach(callback -> ((BuyCallback)callback).buy(shopEvent));
                }
                format.getBuyCallbacks().forEach(buyCallback -> buyCallback.buy(shopEvent));
                Bukkit.getPluginManager().callEvent((Event)shopEvent);
                if (shopEvent.isHasExecutions() && shopEvent.isRunExecutions()) {
                    this.runExecutions(originalData.get("execute"), format, player);
                }
                if (InventoryUtils.getInventoryHolderWithoutSnapshot(player.getOpenInventory().getTopInventory()) == holder) {
                    holder.repaint();
                }
                return;
            }
            if (originalData.containsKey("execute")) {
                this.runExecutions(originalData.get("execute"), format, player);
            }
            PostActionEvent postEvent = new PostActionEvent(player, format, inventory, parent, playersItem, e.getClick());
            if (playersItem.getReader().containsKey("postclickcallbacks")) {
                List postclickcallbacks = (List)playersItem.getReader().get("postclickcallbacks");
                postclickcallbacks.forEach(callback -> ((PostClickCallback)callback).postClick(postEvent));
            }
            format.getPostClickCallbacks().forEach(postClickCallback -> postClickCallback.postClick(postEvent));
            Bukkit.getPluginManager().callEvent((Event)postEvent);
            if (InventoryUtils.getInventoryHolderWithoutSnapshot(player.getOpenInventory().getTopInventory()) == holder) {
                holder.repaint();
            }
        }
    }

    private void runExecutions(Object obj, SimpleInventories format, Player player) {
        List<String> list = obj instanceof List ? (List<String>)obj : Collections.singletonList(obj.toString());
        for (String str : list) {
            if ((str = str.trim()).startsWith("console:")) {
                if (!format.isAllowedToExecuteConsoleCommands()) continue;
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), str.substring(8).trim());
                continue;
            }
            if (str.startsWith("bungee:")) {
                if (!format.isAllowBungeecord()) continue;
                String server = str.substring(7).trim();
                Bukkit.getScheduler().runTask(format.getPluginForRunnables(), () -> {
                    try {
                        if (!Bukkit.getMessenger().getOutgoingChannels(format.getPluginForRunnables()).contains("BungeeCord")) {
                            Bukkit.getMessenger().registerOutgoingPluginChannel(format.getPluginForRunnables(), "BungeeCord");
                        }
                        ByteArrayDataOutput out = ByteStreams.newDataOutput();
                        out.writeUTF("Connect");
                        out.writeUTF(server);
                        player.sendPluginMessage(format.getPluginForRunnables(), "BungeeCord", out.toByteArray());
                    }
                    catch (Throwable throwable) {
                        System.out.println("Something went wrong while teleporting player through bungeecord: " + throwable.getMessage());
                        throwable.printStackTrace();
                    }
                });
                continue;
            }
            if (str.startsWith("player:")) {
                str = str.substring(7).trim();
            }
            Bukkit.getServer().dispatchCommand((CommandSender)player, str);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Inventory inventory = event.getInventory();
        InventoryHolder possibleHolder = InventoryUtils.getInventoryHolderWithoutSnapshot(inventory);
        if (GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.containsKey(inventory)) {
            possibleHolder = GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.get(inventory);
        }
        if (possibleHolder instanceof GuiHolder) {
            GuiHolder holder = (GuiHolder)possibleHolder;
            SimpleInventories format = holder.getFormat();
            CloseInventoryEvent closeInventoryEvent = new CloseInventoryEvent(player, format, holder, inventory);
            format.getCloseCallbacks().forEach(closeCallback -> closeCallback.close(closeInventoryEvent));
            Bukkit.getPluginManager().callEvent((Event)closeInventoryEvent);
            if (closeInventoryEvent.isCancelled()) {
                format.openForPlayer(player);
            } else if (InventoryUtils.getInventoryHolderWithoutSnapshot(inventory) != holder) {
                GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.remove(inventory);
            }
        }
    }

    @EventHandler
    public void onItemDrag(InventoryDragEvent event) {
        if (event.isCancelled() || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory primaryInventory = event.getInventory();
        InventoryHolder possibleHolder = InventoryUtils.getInventoryHolderWithoutSnapshot(primaryInventory);
        if (GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.containsKey(primaryInventory)) {
            possibleHolder = GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.get(primaryInventory);
        }
        if (possibleHolder instanceof GuiHolder) {
            Player player = (Player)event.getWhoClicked();
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                Inventory inventory = this.getInventory(event.getView(), slot);
                if (!primaryInventory.equals(inventory)) continue;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onItemMove(InventoryMoveItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        InventoryHolder possibleHolder = InventoryUtils.getInventoryHolderWithoutSnapshot(event.getSource());
        if (GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.containsKey(event.getSource())) {
            possibleHolder = GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.get(event.getSource());
        }
        InventoryHolder possibleDestHolder = InventoryUtils.getInventoryHolderWithoutSnapshot(event.getDestination());
        if (GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.containsKey(event.getDestination())) {
            possibleDestHolder = GuiHolder.TILE_ENTITY_HOLDER_CONVERTOR.get(event.getDestination());
        }
        if (possibleHolder instanceof GuiHolder || possibleDestHolder instanceof GuiHolder) {
            event.setCancelled(true);
        }
    }

    public final Inventory getInventory(InventoryView view, int rawSlot) {
        if (rawSlot == -999) {
            return null;
        }
        if (rawSlot < view.getTopInventory().getSize()) {
            return view.getTopInventory();
        }
        return view.getBottomInventory();
    }
}

