/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.loaders;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.screamingsandals.bedwars.lib.sgui.loaders.CsvLoader;
import org.screamingsandals.bedwars.lib.sgui.loaders.GroovyLoader;
import org.screamingsandals.bedwars.lib.sgui.loaders.Loader;
import org.screamingsandals.bedwars.lib.sgui.loaders.YamlLoader;

public final class LoaderRegister {
    private static final Map<String, Loader> REGISTER = new HashMap<String, Loader>();
    private static final Loader FALLBACK = new YamlLoader();

    public static Loader getLoader(String extension) {
        if (!(extension = extension.toLowerCase()).startsWith(".")) {
            extension = "." + extension;
        }
        if (REGISTER.containsKey(extension)) {
            return REGISTER.get(extension);
        }
        return FALLBACK;
    }

    public static Loader getLoader(File file) {
        String extension = "";
        int i = file.getAbsolutePath().lastIndexOf(46);
        if (i > -1) {
            extension = file.getAbsolutePath().substring(i + 1);
        }
        return LoaderRegister.getLoader(extension);
    }

    static {
        YamlLoader yaml = FALLBACK;
        REGISTER.put(".yml", yaml);
        REGISTER.put(".yaml", yaml);
        REGISTER.put(".json", yaml);
        CsvLoader csv = new CsvLoader();
        REGISTER.put(".csv", csv);
        REGISTER.put(".txt", csv);
        GroovyLoader groovy = new GroovyLoader();
        REGISTER.put(".groovy", groovy);
    }
}

