/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.operations.BlankOperation;
import org.screamingsandals.bedwars.lib.sgui.operations.Operation;
import org.screamingsandals.bedwars.lib.sgui.operations.arithmetic.AdditionArithmetic;
import org.screamingsandals.bedwars.lib.sgui.operations.arithmetic.DivisionArithmetic;
import org.screamingsandals.bedwars.lib.sgui.operations.arithmetic.ModuloArithmetic;
import org.screamingsandals.bedwars.lib.sgui.operations.arithmetic.MultiplicationArithmetic;
import org.screamingsandals.bedwars.lib.sgui.operations.arithmetic.SubstractionArithmetic;
import org.screamingsandals.bedwars.lib.sgui.operations.bitwise.AndBitwise;
import org.screamingsandals.bedwars.lib.sgui.operations.bitwise.ComplimentBitwise;
import org.screamingsandals.bedwars.lib.sgui.operations.bitwise.LeftShiftBitwise;
import org.screamingsandals.bedwars.lib.sgui.operations.bitwise.OrBitwise;
import org.screamingsandals.bedwars.lib.sgui.operations.bitwise.RightShiftBitwise;
import org.screamingsandals.bedwars.lib.sgui.operations.bitwise.XorBitwise;
import org.screamingsandals.bedwars.lib.sgui.operations.bitwise.ZeroFillRightShiftBitwise;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.AndCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.BooleanCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.Condition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.EqualsCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.FullEqualsCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.GreaterThanCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.GreaterThanOrEqualCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.NegationCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.NotEqualCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.NotFullEqualsCondition;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.OrCondition;

public class OperationParser {
    public static final List<String> STRING_BEGIN_END = Arrays.asList("\"", "'");
    public static final List<String> DUAL_OPERATORS = Arrays.asList("==", "===", "!=", "!==", "<>", ">", "<", ">=", "<=", "&&", "||", "+", "-", "*", "/", "%", "&", "|", "^", "<<", ">>", ">>>");
    public static final List<String> SINGLE_OPERATORS = Arrays.asList("!", "~");
    public static final List<String> ESCAPE_SYMBOLS = Arrays.asList("\\");
    public static final List<String> BRACKET_START_OR_END = Arrays.asList("(", ")");
    public static final String BRACKET_START = "(";
    public static final String BRACKET_END = ")";
    private static final List<List<String>> PRIORITIES = new ArrayList<List<String>>();

    public static Condition getFinalCondition(SimpleInventories format, String operationString) {
        Operation op = OperationParser.getFinalOperation(format, operationString);
        if (op instanceof Condition) {
            return (Condition)op;
        }
        if (op instanceof BlankOperation) {
            return new BooleanCondition(format, ((BlankOperation)op).getBlankObject());
        }
        return new BooleanCondition(format, op);
    }

    public static Condition getFinalNegation(SimpleInventories format, String operationString) {
        Operation op = OperationParser.getFinalOperation(format, operationString);
        if (op instanceof BlankOperation) {
            return new NegationCondition(format, ((BlankOperation)op).getBlankObject());
        }
        return new NegationCondition(format, op);
    }

    public static Operation getFinalOperation(SimpleInventories format, String operationString) {
        char[] chars = operationString.toCharArray();
        int lastIndexOfEscape = -2;
        ArrayList<Object> firstResult = new ArrayList<Object>();
        String operand = "";
        boolean buildingString = false;
        boolean includeBuildingStringWith = false;
        boolean finalizeStringAfterBuild = true;
        String buildingStringWith = "";
        for (int i = 0; i < chars.length; ++i) {
            String c = String.valueOf(chars[i]);
            String pair = c + (i < chars.length - 1 ? Character.valueOf(chars[i + 1]) : "");
            String triplet = pair + (i < chars.length - 2 ? Character.valueOf(chars[i + 2]) : "");
            if (ESCAPE_SYMBOLS.contains(c) && lastIndexOfEscape != i - 1) {
                lastIndexOfEscape = i;
                continue;
            }
            if (buildingString) {
                if (lastIndexOfEscape != i - 1 && c.equals(buildingStringWith)) {
                    buildingString = false;
                    if (includeBuildingStringWith) {
                        operand = buildingStringWith + operand + buildingStringWith;
                    }
                    if (finalizeStringAfterBuild) {
                        firstResult.add(new Operand(operand.trim()));
                        operand = "";
                    }
                    includeBuildingStringWith = false;
                    finalizeStringAfterBuild = true;
                    continue;
                }
                operand = operand + c;
                continue;
            }
            if (BRACKET_START_OR_END.contains(c) && lastIndexOfEscape != i - 1) {
                if (!operand.equals("")) {
                    firstResult.add(new Operand(operand.trim()));
                    operand = "";
                }
                firstResult.add(BRACKET_START.equals(c) ? new OpenBracket() : new CloseBracket());
                continue;
            }
            if (STRING_BEGIN_END.contains(c) && lastIndexOfEscape != i - 1 && operand.equals("")) {
                buildingString = true;
                buildingStringWith = c;
                continue;
            }
            if ((DUAL_OPERATORS.contains(c) || DUAL_OPERATORS.contains(pair) || DUAL_OPERATORS.contains(triplet)) && lastIndexOfEscape != i - 1) {
                if (!operand.equals("")) {
                    firstResult.add(new Operand(operand.trim()));
                    operand = "";
                } else if (c.equals("%")) {
                    buildingString = true;
                    buildingStringWith = "%";
                    includeBuildingStringWith = true;
                    finalizeStringAfterBuild = false;
                    continue;
                }
                if (DUAL_OPERATORS.contains(triplet)) {
                    i += 2;
                    firstResult.add(new Operator(triplet, true));
                    continue;
                }
                if (DUAL_OPERATORS.contains(pair)) {
                    ++i;
                    firstResult.add(new Operator(pair, true));
                    continue;
                }
                if (!(!c.equals("+") && !c.equals("-") || firstResult.size() != 0 && firstResult.get(firstResult.size() - 1) instanceof Operand)) {
                    firstResult.add(new Operator("u" + c, false));
                    continue;
                }
                firstResult.add(new Operator(c, true));
                continue;
            }
            if (SINGLE_OPERATORS.contains(c) && lastIndexOfEscape != i - 1) {
                if (!operand.equals("")) {
                    firstResult.add(new Operand(operand.trim()));
                    operand = "";
                }
                firstResult.add(new Operator(c, false));
                continue;
            }
            if (operand.equals("") && c.trim().equals("")) continue;
            operand = operand + c;
        }
        if (!operand.equals("")) {
            firstResult.add(new Operand(operand.trim()));
        }
        return OperationParser.internalProcess(format, firstResult);
    }

    private static Operation internalProcess(SimpleInventories format, List<Object> firstResult) {
        ArrayList<Object> operations = new ArrayList<Object>();
        for (int priority = 0; priority < PRIORITIES.size(); ++priority) {
            ArrayList<Object> results = new ArrayList<Object>(priority == 0 ? firstResult : operations);
            List<String> operatorForThisPriority = PRIORITIES.get(priority);
            operations.clear();
            Object lastOperand = null;
            Operator lastOperation = null;
            for (int i = 0; i < results.size(); ++i) {
                Object member = results.get(i);
                if (member instanceof Operator) {
                    Operator operator = (Operator)member;
                    if (operator.isBinary) {
                        if (lastOperand == null) {
                            throw new RuntimeException("Invalid operation: There is dual operator but first object is missing!");
                        }
                        if (operatorForThisPriority.contains(operator.string)) {
                            lastOperation = operator;
                            continue;
                        }
                        if (lastOperand != null) {
                            if (operations.size() == 0) {
                                operations.add(lastOperand);
                            } else if (lastOperand instanceof Operand) {
                                if (!operations.get(operations.size() - 1).equals(lastOperand)) {
                                    operations.add(((Operand)lastOperand).string);
                                }
                            } else if (operations.get(operations.size() - 1) != lastOperand) {
                                operations.add(lastOperand);
                            }
                            lastOperand = null;
                        }
                        operations.add(operator);
                        continue;
                    }
                    if (lastOperand != null) {
                        throw new RuntimeException("Invalid operation: There are two operands but this operator is just for one operand!");
                    }
                    lastOperation = operator;
                    continue;
                }
                if (member instanceof OpenBracket) {
                    int bracketEnd = results.size();
                    int openedBrackets = 1;
                    ArrayList<Object> internalFirstResult = new ArrayList<Object>();
                    for (int k = i + 1; k < results.size(); ++k) {
                        Object kk = results.get(k);
                        if (kk instanceof OpenBracket) {
                            ++openedBrackets;
                        } else if (kk instanceof CloseBracket && --openedBrackets == 0) {
                            bracketEnd = k;
                            break;
                        }
                        internalFirstResult.add(kk);
                    }
                    i = bracketEnd;
                    Operation operand = OperationParser.internalProcess(format, internalFirstResult);
                    if (lastOperand != null && lastOperation == null) {
                        throw new RuntimeException("Invalid operation: There are two operands without operator!");
                    }
                    if (lastOperation != null) {
                        Operation op = OperationParser.getOperation(format, lastOperation, lastOperand, operand);
                        lastOperand = op;
                        lastOperation = null;
                        if (op == null) continue;
                        operations.add(op);
                        continue;
                    }
                    lastOperand = operand;
                    continue;
                }
                Object operand = member;
                if (lastOperand != null && lastOperation == null) {
                    throw new RuntimeException("Invalid operation: There are two operands without operator!");
                }
                if (lastOperation != null) {
                    Operation op = OperationParser.getOperation(format, lastOperation, lastOperand, operand);
                    if (operations.size() != 0 && operations.get(operations.size() - 1).equals(lastOperand)) {
                        operations.remove(operations.size() - 1);
                    }
                    lastOperand = op;
                    lastOperation = null;
                    if (op == null) continue;
                    operations.add(op);
                    continue;
                }
                lastOperand = operand;
            }
            if (lastOperand != null && !operations.contains(lastOperand)) {
                if (lastOperand instanceof Operand) {
                    lastOperand = ((Operand)lastOperand).string;
                }
                operations.add(lastOperand);
            }
            if (operations.size() != 1) continue;
            if (operations.get(0) instanceof Operation) {
                return (Operation)operations.get(0);
            }
            return new BlankOperation(format, operations.get(0));
        }
        throw new RuntimeException("Parsing error!");
    }

    private static Operation getOperation(SimpleInventories format, Operator lastOperation, Object lastOperand, Object operand) {
        if (lastOperand instanceof Operand) {
            lastOperand = ((Operand)lastOperand).string;
        }
        if (operand instanceof Operand) {
            operand = ((Operand)operand).string;
        }
        switch (lastOperation.string) {
            case "==": {
                return new EqualsCondition(format, lastOperand, operand);
            }
            case "===": {
                return new FullEqualsCondition(format, lastOperand, operand);
            }
            case "!=": 
            case "<>": {
                return new NotEqualCondition(format, lastOperand, operand);
            }
            case "!==": {
                return new NotFullEqualsCondition(format, lastOperand, operand);
            }
            case "<=": {
                return new GreaterThanOrEqualCondition(format, operand, lastOperand);
            }
            case ">=": {
                return new GreaterThanOrEqualCondition(format, lastOperand, operand);
            }
            case "<": {
                return new GreaterThanCondition(format, operand, lastOperand);
            }
            case ">": {
                return new GreaterThanCondition(format, lastOperand, operand);
            }
            case "!": {
                return new NegationCondition(format, operand);
            }
            case "&&": {
                return new AndCondition(format, lastOperand, operand);
            }
            case "||": {
                return new OrCondition(format, lastOperand, operand);
            }
            case "+": {
                return new AdditionArithmetic(format, lastOperand, operand);
            }
            case "-": {
                return new SubstractionArithmetic(format, lastOperand, operand);
            }
            case "*": {
                return new MultiplicationArithmetic(format, lastOperand, operand);
            }
            case "/": {
                return new DivisionArithmetic(format, lastOperand, operand);
            }
            case "%": {
                return new ModuloArithmetic(format, lastOperand, operand);
            }
            case "u+": {
                return new AdditionArithmetic(format, 0, operand);
            }
            case "u-": {
                return new SubstractionArithmetic(format, 0, operand);
            }
            case "&": {
                return new AndBitwise(format, lastOperand, operand);
            }
            case "|": {
                return new OrBitwise(format, lastOperand, operand);
            }
            case "^": {
                return new XorBitwise(format, lastOperand, operand);
            }
            case "~": {
                return new ComplimentBitwise(format, operand);
            }
            case "<<": {
                return new LeftShiftBitwise(format, lastOperand, operand);
            }
            case ">>": {
                return new RightShiftBitwise(format, lastOperand, operand);
            }
            case ">>>": {
                return new ZeroFillRightShiftBitwise(format, lastOperand, operand);
            }
        }
        return null;
    }

    static {
        PRIORITIES.add(Arrays.asList("!", "u+", "u-", "~"));
        PRIORITIES.add(Arrays.asList("*", "/", "%"));
        PRIORITIES.add(Arrays.asList("+", "-"));
        PRIORITIES.add(Arrays.asList("<<", ">>", ">>>"));
        PRIORITIES.add(Arrays.asList(">", "<", ">=", "<="));
        PRIORITIES.add(Arrays.asList("==", "!=", "<>", "===", "!=="));
        PRIORITIES.add(Arrays.asList("&"));
        PRIORITIES.add(Arrays.asList("^"));
        PRIORITIES.add(Arrays.asList("|"));
        PRIORITIES.add(Arrays.asList("&&"));
        PRIORITIES.add(Arrays.asList("||"));
    }

    private static class CloseBracket
    extends Bracket {
        private CloseBracket() {
        }
    }

    private static class OpenBracket
    extends Bracket {
        private OpenBracket() {
        }
    }

    private static abstract class Bracket
    implements OperationMember {
        private Bracket() {
        }
    }

    private static class Operator
    implements OperationMember {
        public String string;
        public boolean isBinary;

        public Operator(String string, boolean isBinary) {
            this.string = string;
            this.isBinary = isBinary;
        }

        public String toString() {
            return this.string;
        }
    }

    private static class Operand
    implements OperationMember {
        public String string;

        public Operand(String string) {
            this.string = string;
        }

        public boolean equals(Object operand) {
            if (!(operand instanceof Operand)) {
                return false;
            }
            return ((Operand)operand).string.equals(this.string);
        }

        public String toString() {
            return this.string;
        }
    }

    private static interface OperationMember {
    }
}

