/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.operations.conditions;

import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.item.PlayerItemInfo;
import org.screamingsandals.bedwars.lib.sgui.operations.Operation;
import org.screamingsandals.bedwars.lib.sgui.operations.conditions.Condition;

public class BooleanCondition
implements Condition {
    protected SimpleInventories format;
    protected Object obj;

    public BooleanCondition(SimpleInventories format, Object obj) {
        this.format = format;
        this.obj = obj;
    }

    @Override
    public boolean process(Player player, PlayerItemInfo info) {
        Object ob = this.obj;
        if (ob instanceof Operation) {
            ob = ((Operation)ob).resolveFor(player, info);
        }
        if (ob instanceof Boolean) {
            return (Boolean)ob;
        }
        if (ob instanceof Number) {
            return ((Number)ob).doubleValue() != 0.0;
        }
        if (ob instanceof String) {
            try {
                double number = Double.parseDouble((String)ob);
                return number != 0.0;
            }
            catch (Throwable throwable) {
                ob = this.format.processPlaceholders(player, (String)ob, info);
                return !((String)ob).isEmpty() && !"false".equalsIgnoreCase((String)ob) && !"null".equalsIgnoreCase((String)ob);
            }
        }
        return ob != null;
    }

    public String toString() {
        return this.getClass().getName() + "[format=" + this.format + ";obj=" + this.obj + "]";
    }
}

