/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public class EnchantmentSearchEngine {
    private static final Map<String, String> LEGACY_MAPPING = new HashMap<String, String>(){
        {
            this.put("power", "ARROW_DAMAGE");
            this.put("flame", "ARROW_FIRE");
            this.put("infinity", "ARROW_INFINITE");
            this.put("punch", "ARROW_KNOCKBACK");
            this.put("sharpness", "DAMAGE_ALL");
            this.put("bane_of_arthropods", "DAMAGE_ARTHROPODS");
            this.put("smite", "DAMAGE_UNDEAD");
            this.put("efficiency", "DIG_SPEED");
            this.put("unbreaking", "DURABILITY");
            this.put("fortune", "LOOT_BONUS_BLOCKS");
            this.put("looting", "LOOT_BONUS_MOBS");
            this.put("luck_of_the_sea", "LUCK");
            this.put("respiration", "OXYGEN");
            this.put("protection", "PROTECTION_ENVIRONMENTAL");
            this.put("blast_protection", "PROTECTION_EXPLOSIONS");
            this.put("feather_falling", "PROTECTION_FALL");
            this.put("fire_protection", "PROTECTION_FIRE");
            this.put("projectile_protection", "PROTECTION_PROJECTILE");
            this.put("sweeping", "SWEEPING_EDGE");
            this.put("aqua_affinity", "WATER_WORKER");
        }
    };

    public static Enchantment searchEnchantment(Object enchantObj) {
        if (enchantObj instanceof Enchantment) {
            return (Enchantment)enchantObj;
        }
        String enchant = enchantObj.toString();
        Enchantment en = Enchantment.getByName((String)enchant.toUpperCase());
        if (en != null) {
            return en;
        }
        try {
            String[] split = enchant.toLowerCase().split(":", 2);
            if (split.length == 2) {
                return Enchantment.getByKey((NamespacedKey)new NamespacedKey(split[0], split[1]));
            }
            return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchant.toLowerCase()));
        }
        catch (Throwable throwable) {
            enchant = enchant.toLowerCase(Locale.ROOT);
            if (enchant.startsWith("minecraft:")) {
                enchant = enchant.substring(10);
            }
            return Enchantment.getByName((String)LEGACY_MAPPING.get(enchant));
        }
    }
}

