/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.screamingsandals.bedwars.lib.sgui.SimpleInventories;
import org.screamingsandals.bedwars.lib.sgui.item.PlayerItemInfo;
import org.screamingsandals.bedwars.lib.sgui.operations.OperationParser;
import org.screamingsandals.bedwars.lib.sgui.utils.StackParser;

public class MapReader {
    private Map<String, Object> map;
    private SimpleInventories format;
    private Player player;
    private PlayerItemInfo info;

    @Deprecated
    public MapReader(SimpleInventories format, Map<String, Object> map, Player player) {
        this(format, map, player, null);
    }

    public MapReader(SimpleInventories format, Map<String, Object> map, Player player, PlayerItemInfo info) {
        this.map = map;
        this.format = format;
        this.player = player;
        this.info = info;
    }

    public SimpleInventories getFormat() {
        return this.format;
    }

    public Player getOwnerOfReader() {
        return this.player;
    }

    public MapReader getMap(String key) {
        Object obj = this.map.get(key);
        if (obj instanceof Map) {
            return new MapReader(this.format, (Map)obj, this.player, this.info);
        }
        return null;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String def) {
        Object obj = this.get(key);
        return obj != null ? obj.toString() : def;
    }

    private Number getNumber(String key, Number def) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            String s = (String)obj;
            try {
                Double number = Double.parseDouble(s);
                return number;
            }
            catch (NumberFormatException e) {
                try {
                    Object ob = OperationParser.getFinalOperation(this.format, s).resolveFor(this.player, this.info);
                    if (ob instanceof Number) {
                        return (Number)ob;
                    }
                    if (ob instanceof String) {
                        Double number = Double.parseDouble((String)ob);
                        return number;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        return def;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int def) {
        return this.getNumber(key, def).intValue();
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float def) {
        return this.getNumber(key, Float.valueOf(def)).floatValue();
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double def) {
        return this.getNumber(key, def).doubleValue();
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte def) {
        return this.getNumber(key, def).byteValue();
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short def) {
        return this.getNumber(key, def).shortValue();
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long def) {
        return this.getNumber(key, def).longValue();
    }

    public char getChar(String key) {
        return this.getChar(key, '\u0000');
    }

    public char getChar(String key, char def) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            return ((String)obj).charAt(0);
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        return def;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            return OperationParser.getFinalCondition(this.format, (String)obj).process(this.player, this.info);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return def;
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, null);
    }

    public List<String> getStringList(String key, List<String> def) {
        Object obj = this.get(key);
        if (!(obj instanceof List)) {
            return def;
        }
        ArrayList<String> newStrList = new ArrayList<String>((List)obj);
        return newStrList.isEmpty() && def != null ? def : newStrList;
    }

    public List<ItemStack> getStackList(String key) {
        return this.getStackList(key, null);
    }

    public List<ItemStack> getStackList(String key, List<ItemStack> def) {
        Object obj = this.get(key);
        if (!(obj instanceof List)) {
            return def;
        }
        List<ItemStack> newStrList = StackParser.parseAll((List)obj);
        return newStrList.isEmpty() && def != null ? def : newStrList;
    }

    public ItemStack getItemStack(String key) {
        return this.getItemStack(key, null);
    }

    public ItemStack getItemStack(String key, ItemStack def) {
        Object obj = this.get(key);
        ItemStack stack = StackParser.parseNullable(obj);
        return stack != null ? stack : def;
    }

    public List<MapReader> getMapList(String key) {
        Object obj = this.map.get(key);
        ArrayList<MapReader> newMapList = new ArrayList<MapReader>();
        if (obj instanceof List) {
            List mapList = (List)obj;
            for (Map map : mapList) {
                newMapList.add(new MapReader(this.format, map, this.player, this.info));
            }
        }
        return newMapList;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Object get(String key) {
        return this.convert(this.map.get(key));
    }

    private Object convert(Object obj) {
        ItemStack stack;
        if (obj instanceof String && ((String)(obj = this.format.processPlaceholders(this.player, (String)obj, this.info))).startsWith("(cast to ItemStack)")) {
            obj = StackParser.parseShortStack((String)obj);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            ItemStack nlist = new ArrayList();
            for (Object ob : list) {
                nlist.add(this.convert(ob));
            }
            obj = nlist;
        }
        if (obj instanceof Map) {
            String cast;
            Map map = (Map)obj;
            boolean casted = false;
            if (map.containsKey("cast") && (cast = map.get("cast").toString().toLowerCase()).endsWith("itemstack")) {
                obj = StackParser.parseLongStack(map);
                casted = true;
            }
            if (!casted) {
                HashMap<String, Object> nmap = new HashMap<String, Object>();
                for (Map.Entry entry : map.entrySet()) {
                    nmap.put((String)entry.getKey(), this.convert(entry.getValue()));
                }
                obj = nmap;
                if (nmap.containsKey("==")) {
                    obj = ConfigurationSerialization.deserializeObject(nmap);
                }
            }
        }
        if (obj instanceof ItemStack && (stack = (ItemStack)obj).hasItemMeta()) {
            ItemMeta meta = stack.getItemMeta();
            if (meta.hasDisplayName()) {
                meta.setDisplayName(this.format.processPlaceholders(this.player, meta.getDisplayName(), this.info));
            }
            if (meta.hasLore()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String str : meta.getLore()) {
                    lore.add(this.format.processPlaceholders(this.player, str, this.info));
                }
                meta.setLore(lore);
            }
            stack.setItemMeta(meta);
        }
        return obj;
    }

    public Map<String, Object> convertToMap() {
        return (Map)this.convert(this.map);
    }

    @Deprecated
    public Map<String, Object> getOriginalData() {
        return this.map;
    }
}

