/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class PotionTypeSearchEngine {
    private static final Map<String, String> regular = new HashMap<String, String>(){
        {
            this.put("empty", "UNCRAFTABLE");
            this.put("water", "WATER");
            this.put("mundane", "MUNDANE");
            this.put("thick", "THICK");
            this.put("awkward", "AWKWARD");
            this.put("night_vision", "NIGHT_VISION");
            this.put("invisibility", "INVISIBILITY");
            this.put("leaping", "JUMP");
            this.put("fire_resistance", "FIRE_RESISTANCE");
            this.put("swiftness", "SPEED");
            this.put("slowness", "SLOWNESS");
            this.put("water_breathing", "WATER_BREATHING");
            this.put("healing", "INSTANT_HEAL");
            this.put("harming", "INSTANT_DAMAGE");
            this.put("poison", "POISON");
            this.put("regeneration", "REGEN");
            this.put("strength", "STRENGTH");
            this.put("weakness", "WEAKNESS");
            this.put("luck", "LUCK");
            this.put("turtle_master", "TURTLE_MASTER");
            this.put("slow_falling", "SLOW_FALLING");
        }
    };
    private static final Map<String, String> upgradeable = new HashMap<String, String>(){
        {
            this.put("strong_leaping", "JUMP");
            this.put("strong_swiftness", "SPEED");
            this.put("strong_healing", "INSTANT_HEAL");
            this.put("strong_harming", "INSTANT_DAMAGE");
            this.put("strong_poison", "POISON");
            this.put("strong_regeneration", "REGEN");
            this.put("strong_strength", "STRENGTH");
            this.put("strong_slowness", "SLOWNESS");
            this.put("strong_turtle_master", "TURTLE_MASTER");
        }
    };
    private static final Map<String, String> extendable = new HashMap<String, String>(){
        {
            this.put("long_night_vision", "NIGHT_VISION");
            this.put("long_invisibility", "INVISIBILITY");
            this.put("long_leaping", "JUMP");
            this.put("long_fire_resistance", "FIRE_RESISTANCE");
            this.put("long_swiftness", "SPEED");
            this.put("long_slowness", "SLOWNESS");
            this.put("long_water_breathing", "WATER_BREATHING");
            this.put("long_poison", "POISON");
            this.put("long_regeneration", "REGEN");
            this.put("long_strength", "STRENGTH");
            this.put("long_weakness", "WEAKNESS");
            this.put("long_turtle_master", "TURTLE_MASTER");
            this.put("long_slow_falling", "SLOW_FALLING");
        }
    };

    public static PotionData find(String potionType) {
        String potion = potionType.toLowerCase(Locale.ROOT);
        if (potion.startsWith("minecraft:")) {
            potion = potion.substring(10);
        }
        return Attemptor.start().attempt(extendable.containsKey(potion), type -> new PotionData(PotionType.valueOf((String)extendable.get(type)), true, false)).attempt(upgradeable.containsKey(potion), type -> new PotionData(PotionType.valueOf((String)upgradeable.get(type)), false, true)).attempt(regular.containsKey(potion), type -> new PotionData(PotionType.valueOf((String)regular.get(type)), false, false)).attempt(potion.startsWith("long_"), type -> new PotionData(PotionType.valueOf((String)type.substring(5).toUpperCase()), true, false)).attempt(potion.startsWith("strong_"), type -> new PotionData(PotionType.valueOf((String)type.substring(7).toUpperCase()), false, true)).attempt(type -> new PotionData(PotionType.valueOf((String)type.toUpperCase()), false, false)).end(potion);
    }

    private static interface Attempt {
        public PotionData attempt(String var1) throws Throwable;
    }

    private static class Attemptor {
        private List<Attempt> attempts = new ArrayList<Attempt>();

        private Attemptor() {
        }

        public static Attemptor start() {
            return new Attemptor();
        }

        public Attemptor attempt(Attempt attempt) {
            this.attempts.add(attempt);
            return this;
        }

        public Attemptor attempt(boolean condition, Attempt attempt) {
            if (condition) {
                this.attempts.add(attempt);
            }
            return this;
        }

        public PotionData end(String potionType) {
            for (Attempt attempt : this.attempts) {
                try {
                    PotionData data = attempt.attempt(potionType);
                    if (data == null) continue;
                    return data;
                }
                catch (Throwable throwable) {
                }
            }
            Bukkit.getLogger().warning("[SimpleInventories] Cannot find potion type for " + potionType + "! Your configuration is invalid!");
            return new PotionData(PotionType.UNCRAFTABLE, false, false);
        }
    }
}

