/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.sgui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.lib.sgui.utils.EnchantmentSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.MaterialSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.PotionTypeEffectSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.PotionTypeSearchEngine;
import org.screamingsandals.bedwars.lib.sgui.utils.PotionTypeSearchEngine1_20_5;
import org.screamingsandals.bedwars.lib.sgui.utils.PotionTypeSearchEngine1_8_8;
import org.screamingsandals.bedwars.lib.sgui.utils.TagParser;

public class StackParser {
    public static final List<String> STRING_BEGIN_END = Arrays.asList("\"", "'");
    public static final List<String> ESCAPE_SYMBOLS = Arrays.asList("\\");
    public static final List<String> ARGUMENT_SEPARATORS = Arrays.asList(";");
    @Nullable
    public static TagParser tagParser;

    public static List<ItemStack> parseAll(Collection<Object> stacks) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        stacks.forEach(stack -> newStacks.add(StackParser.parse(stack)));
        return newStacks;
    }

    public static ItemStack parse(Object stack) {
        if (stack instanceof ItemStack) {
            return (ItemStack)stack;
        }
        if (stack instanceof Map) {
            return StackParser.parseLongStack((Map)stack);
        }
        return StackParser.parseShortStack(stack.toString());
    }

    public static ItemStack parseNullable(Object stack) {
        if (stack instanceof ItemStack) {
            return (ItemStack)stack;
        }
        if (stack instanceof Map) {
            return StackParser.parseLongStack((Map)stack);
        }
        if (stack instanceof String) {
            return StackParser.parseShortStack((String)stack);
        }
        return null;
    }

    public static ItemStack parseShortStack(String shortStack) {
        if ((shortStack = shortStack.trim()).startsWith("(cast to ItemStack)")) {
            shortStack = shortStack.substring(19).trim();
        }
        char[] characters = shortStack.toCharArray();
        ArrayList<String> arguments = new ArrayList<String>();
        int lastIndexOfEscape = -2;
        boolean workOnString = false;
        String workOnStringWith = "";
        String build = "";
        for (int i = 0; i < characters.length; ++i) {
            char character = characters[i];
            String c = String.valueOf(character);
            if (ESCAPE_SYMBOLS.contains(c) && lastIndexOfEscape != i - 1) {
                lastIndexOfEscape = i;
                continue;
            }
            if (workOnString) {
                if (lastIndexOfEscape != i - 1 && c.equals(workOnStringWith)) {
                    workOnString = false;
                    arguments.add(build.trim());
                    build = "";
                    continue;
                }
                build = build + c;
                continue;
            }
            if (STRING_BEGIN_END.contains(c) && lastIndexOfEscape != i - 1) {
                workOnString = true;
                workOnStringWith = c;
                continue;
            }
            if (ARGUMENT_SEPARATORS.contains(c) && lastIndexOfEscape != i - 1) {
                arguments.add(build);
                build = "";
                continue;
            }
            build = build + c;
        }
        if (!build.equals("")) {
            arguments.add(build);
        }
        Material mat = Material.AIR;
        short damage = 0;
        int amount = 1;
        String displayName = null;
        ArrayList<String> lore = new ArrayList<String>();
        for (int i = 0; i < arguments.size(); ++i) {
            String argument = (String)arguments.get(i);
            if (i == 0) {
                MaterialSearchEngine.Result res = MaterialSearchEngine.find(argument);
                mat = res.getMaterial();
                damage = res.getDamage();
                continue;
            }
            if (i == 1) {
                if (argument.equals("")) continue;
                amount = Integer.parseInt(argument);
                continue;
            }
            if (i == 2) {
                if (argument.equals("")) continue;
                displayName = argument;
                continue;
            }
            lore.add(argument);
        }
        ItemStack stack = new ItemStack(mat, amount, damage);
        if (mat != Material.AIR) {
            ItemMeta meta = stack.getItemMeta();
            if (displayName != null && !displayName.equals("")) {
                meta.setDisplayName(displayName);
            }
            if (!lore.isEmpty()) {
                meta.setLore(lore);
            }
            stack.setItemMeta(meta);
        }
        return stack;
    }

    public static ItemStack parseLongStack(Map<String, Object> obj) {
        ItemStack stack = obj.get("type") instanceof Material ? new ItemStack((Material)obj.get("type")) : StackParser.parseShortStack(obj.get("type").toString());
        if (stack.getType() == Material.AIR) {
            return stack;
        }
        if (tagParser != null && obj.containsKey("tag")) {
            try {
                Object dataVersionO = obj.getOrDefault("DataVersion", 0);
                int dataVersion = dataVersionO instanceof Integer ? (Integer)dataVersionO : 0;
                stack = tagParser.applyTag(stack, (String)obj.get("tag"), dataVersion);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (obj.containsKey("amount") && obj.get("amount") instanceof Number) {
            stack.setAmount(((Number)obj.get("amount")).intValue());
        }
        if (obj.containsKey("damage") && obj.get("damage") instanceof Number) {
            stack.setDurability(((Number)obj.get("damage")).shortValue());
        }
        if (obj.containsKey("durability") && obj.get("durability") instanceof Number) {
            stack.setDurability(((Number)obj.get("durability")).shortValue());
        }
        if (obj.containsKey("meta")) {
            if (obj.get("meta") instanceof ItemMeta) {
                try {
                    stack.setItemMeta((ItemMeta)obj.get("meta"));
                }
                catch (Throwable t) {}
            } else if (obj.get("meta") instanceof Map) {
                try {
                    stack.setItemMeta((ItemMeta)ConfigurationSerialization.deserializeObject((Map)((Map)obj.get("meta"))));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        ItemMeta meta = stack.getItemMeta();
        if (obj.containsKey("display-name")) {
            String str = obj.get("display-name").toString();
            meta.setDisplayName(str);
        }
        if (obj.containsKey("loc-name")) {
            String str = obj.get("loc-name").toString();
            try {
                meta.setLocalizedName(str);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (obj.containsKey("custom-model-data") && obj.get("custom-model-data") instanceof Number) {
            try {
                meta.setCustomModelData(Integer.valueOf(((Number)obj.get("custom-model-data")).intValue()));
            }
            catch (Throwable str) {
                // empty catch block
            }
        }
        if (obj.containsKey("repair-cost") && meta instanceof Repairable) {
            String str = obj.get("repair-cost").toString();
            try {
                ((Repairable)meta).setRepairCost(Integer.parseInt(str));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (obj.containsKey("ItemFlags") && obj.get("ItemFlags") instanceof List) {
            for (Object str : (List)obj.get("ItemFlags")) {
                try {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)str)});
                }
                catch (Throwable throwable) {}
            }
        }
        if (obj.containsKey("Unbreakable")) {
            try {
                meta.setUnbreakable(Boolean.parseBoolean(obj.get("Unbreakable").toString()));
            }
            catch (Throwable str) {
                // empty catch block
            }
        }
        if (obj.containsKey("lore")) {
            List lore;
            List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            if (obj.get("lore") instanceof List) {
                for (String str : (List)obj.get("lore")) {
                    lore.add(str);
                }
            } else {
                lore.add(obj.get("lore").toString());
            }
            meta.setLore(lore);
        }
        if (obj.containsKey("enchants")) {
            Enchantment ench;
            if (obj.get("enchants") instanceof List) {
                for (Object en : (List)obj.get("enchants")) {
                    ench = EnchantmentSearchEngine.searchEnchantment(en);
                    if (ench == null || meta.hasEnchant(ench)) continue;
                    if (meta instanceof EnchantmentStorageMeta) {
                        ((EnchantmentStorageMeta)meta).addStoredEnchant(ench, 1, true);
                        continue;
                    }
                    meta.addEnchant(ench, 1, true);
                }
            } else if (obj.get("enchants") instanceof Map) {
                for (Map.Entry entry : ((Map)obj.get("enchants")).entrySet()) {
                    ench = EnchantmentSearchEngine.searchEnchantment(entry.getKey());
                    int i = 1;
                    try {
                        i = ((Number)entry.getValue()).intValue();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (ench == null || meta.hasEnchant(ench)) continue;
                    if (meta instanceof EnchantmentStorageMeta) {
                        ((EnchantmentStorageMeta)meta).addStoredEnchant(ench, i, true);
                        continue;
                    }
                    meta.addEnchant(ench, i, true);
                }
            } else {
                Enchantment ench2 = EnchantmentSearchEngine.searchEnchantment(obj.get("enchants"));
                if (ench2 != null && meta.hasEnchant(ench2)) {
                    if (meta instanceof EnchantmentStorageMeta) {
                        ((EnchantmentStorageMeta)meta).addStoredEnchant(ench2, 1, true);
                    } else {
                        meta.addEnchant(ench2, 1, true);
                    }
                }
            }
        }
        if (obj.containsKey("potion-type") && meta instanceof PotionMeta) {
            Object ob = obj.get("potion-type");
            PotionMeta potion = (PotionMeta)meta;
            if (MaterialSearchEngine.getVersionNumber() == 108) {
                stack.setItemMeta(meta);
                if (ob instanceof PotionType) {
                    stack.setDurability(new Potion((PotionType)ob).toDamageValue());
                } else {
                    stack.setDurability(PotionTypeSearchEngine1_8_8.find(ob.toString()).toDamageValue());
                }
                return stack;
            }
            if (ob instanceof PotionType) {
                if (MaterialSearchEngine.isV1_20_5() || MaterialSearchEngine.getVersionNumber() > 120) {
                    PotionTypeSearchEngine1_20_5.setPotionType(potion, (PotionType)ob);
                } else {
                    potion.setBasePotionData(new PotionData((PotionType)ob));
                }
            } else if (MaterialSearchEngine.isV1_20_5() || MaterialSearchEngine.getVersionNumber() > 120) {
                PotionTypeSearchEngine1_20_5.setPotionType(potion, PotionTypeSearchEngine1_20_5.find(ob.toString()));
            } else {
                potion.setBasePotionData(PotionTypeSearchEngine.find(ob.toString()));
            }
        }
        if (obj.containsKey("effects") && meta instanceof PotionMeta) {
            PotionEffect effect1;
            Object ob = obj.get("effects");
            if (ob instanceof List) {
                for (Object o : (List)ob) {
                    PotionEffect effect12;
                    if (!(o instanceof Map) || (effect12 = StackParser.getPotionEffect((Map)o)) == null) continue;
                    ((PotionMeta)meta).addCustomEffect(effect12, true);
                }
            } else if (ob instanceof Map && (effect1 = StackParser.getPotionEffect((Map)ob)) != null) {
                ((PotionMeta)meta).addCustomEffect(effect1, true);
            }
        }
        stack.setItemMeta(meta);
        return stack;
    }

    public static PotionEffect getPotionEffect(Object ob) {
        if (ob instanceof PotionEffect) {
            return (PotionEffect)ob;
        }
        if (ob instanceof Map) {
            return StackParser.getPotionEffect((Map)ob);
        }
        return null;
    }

    public static PotionEffect getPotionEffect(Map<String, Object> map) {
        Object effect = map.get("effect");
        if (effect == null) {
            return null;
        }
        PotionEffectType potionEffect = PotionTypeEffectSearchEngine.find(effect.toString());
        HashMap<String, Object> processedMap = new HashMap<String, Object>(map);
        if (potionEffect != null) {
            processedMap.put("effect", potionEffect.getId());
        }
        if (processedMap.containsKey("particles")) {
            processedMap.put("has-particles", processedMap.get("particles"));
        }
        if (processedMap.containsKey("icon")) {
            processedMap.put("has-icon", processedMap.get("icon"));
        }
        try {
            return new PotionEffect(processedMap);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "[SimpleInventories] An error occurred while resolving custom potion effect", ex);
            return null;
        }
    }
}

