/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.signmanager;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.material.Directional;
import org.screamingsandals.bedwars.Main;

public class SignBlock {
    private final Location loc;
    private final String name;

    public SignBlock(Location loc, String name) {
        this.loc = loc;
        this.name = name;
    }

    public Location getLocation() {
        return this.loc;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Block> getBlockBehindSign() {
        return Optional.ofNullable(this.getGlassBehind());
    }

    private Block getGlassBehind() {
        Block block = this.loc.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return null;
        }
        if (!Main.isLegacy()) {
            if (block.getState().getBlockData() instanceof org.bukkit.block.data.Directional) {
                org.bukkit.block.data.Directional directional = (org.bukkit.block.data.Directional)block.getState().getBlockData();
                BlockFace blockFace = directional.getFacing().getOppositeFace();
                return block.getRelative(blockFace);
            }
        } else if (block.getState().getData() instanceof Directional) {
            Directional directional = (Directional)block.getState().getData();
            BlockFace blockFace = directional.getFacing().getOppositeFace();
            return block.getRelative(blockFace);
        }
        return block.getRelative(BlockFace.DOWN);
    }
}

