/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.signmanager;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.screamingsandals.bedwars.commands.BaseCommand;
import org.screamingsandals.bedwars.lib.nms.utils.Version;
import org.screamingsandals.bedwars.lib.signmanager.SignBlock;
import org.screamingsandals.bedwars.lib.signmanager.SignManager;
import org.screamingsandals.bedwars.lib.signmanager.SignOwner;

public class SignListener
implements Listener {
    public final List<String> SIGN_PREFIX;
    private SignOwner owner;
    private SignManager manager;

    public SignListener(SignOwner owner, SignManager manager) {
        this.owner = owner;
        this.manager = manager;
        this.SIGN_PREFIX = owner.getSignPrefixes();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getState() instanceof Sign && this.manager.isSignRegistered(event.getClickedBlock().getLocation())) {
            SignBlock sign = this.manager.getSign(event.getClickedBlock().getLocation());
            this.owner.onClick(event.getPlayer(), sign);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Location loc;
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock().getState() instanceof Sign && this.manager.isSignRegistered(loc = event.getBlock().getLocation())) {
            if (BaseCommand.hasPermission((CommandSender)event.getPlayer(), this.owner.getSignCreationPermissions(), false)) {
                this.manager.unregisterSign(loc);
            } else {
                event.getPlayer().sendMessage(this.owner.returnTranslate("sign_can_not_been_destroyed"));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onChangeSign(SignChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock().getState() instanceof Sign) {
            Location loc = event.getBlock().getLocation();
            if (this.SIGN_PREFIX.contains(event.getLine(0).toLowerCase()) && BaseCommand.hasPermission((CommandSender)event.getPlayer(), this.owner.getSignCreationPermissions(), false)) {
                if (this.manager.registerSign(loc, event.getLine(1))) {
                    event.getPlayer().sendMessage(this.owner.returnTranslate("sign_successfully_created"));
                    if (Version.isVersion(1, 20)) {
                        Sign sign = (Sign)event.getBlock().getState();
                        sign.setEditable(false);
                        sign.update(true, false);
                    }
                } else {
                    event.getPlayer().sendMessage(this.owner.returnTranslate("sign_can_not_been_created"));
                    event.setCancelled(true);
                    event.getBlock().breakNaturally();
                }
            }
        }
    }
}

