/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.signmanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.lib.signmanager.SignBlock;
import org.screamingsandals.bedwars.lib.signmanager.SignOwner;

public class SignManager {
    private final FileConfiguration config = new YamlConfiguration();
    private final File configFile;
    private final Map<Location, SignBlock> signs = new HashMap<Location, SignBlock>();
    private boolean modify = false;
    private SignOwner owner;

    public SignManager(SignOwner owner, File configFile) {
        this.owner = owner;
        this.configFile = configFile;
        Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), this::loadConfig, 5L);
    }

    public void loadConfig() {
        List conf;
        try {
            this.config.load(this.configFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.config.isSet("sign") && (conf = this.config.getList("sign")) != null) {
            for (Map c : conf) {
                Location loc;
                String name = (String)c.get("name");
                if (name == null || name.trim().isEmpty()) {
                    name = (String)c.get("game");
                }
                if ((loc = (Location)c.get("location")).getWorld() == null) {
                    Main.getInstance().getLogger().warning("A sign on location " + loc.getX() + ";" + loc.getY() + ";" + loc.getZ() + " is in unknown world! It was removed from the configuration");
                    continue;
                }
                this.signs.put(loc, new SignBlock(loc, name));
                this.owner.updateSign(this.signs.get(loc));
            }
        }
    }

    public boolean isSignRegistered(Location location) {
        return this.signs.containsKey(location);
    }

    public void unregisterSign(Location location) {
        if (this.signs.containsKey(location)) {
            this.signs.remove(location);
            this.modify = true;
        }
    }

    public boolean registerSign(Location location, String game) {
        if (this.owner.isNameExists(game)) {
            SignBlock block = new SignBlock(location, game);
            this.signs.put(location, block);
            this.modify = true;
            this.owner.updateSign(block);
            return true;
        }
        return false;
    }

    public SignBlock getSign(Location location) {
        return this.signs.get(location);
    }

    public List<SignBlock> getSignsForName(String name) {
        ArrayList<SignBlock> list = new ArrayList<SignBlock>();
        for (SignBlock sign : this.signs.values()) {
            if (!sign.getName().equals(name)) continue;
            list.add(sign);
        }
        return list;
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean force) {
        if (this.modify || force) {
            ArrayList list = new ArrayList();
            for (SignBlock sign : this.signs.values()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("location", sign.getLocation());
                map.put("name", sign.getName());
                list.add(map);
            }
            this.config.set("sign", list);
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

