/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.takenaka.accessor.mapping;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.lib.takenaka.accessor.mapping.ClassMapping;
import org.screamingsandals.bedwars.lib.takenaka.accessor.mapping.MethodMapping;
import org.screamingsandals.bedwars.lib.takenaka.accessor.platform.MapperPlatform;
import org.screamingsandals.bedwars.lib.takenaka.accessor.platform.MapperPlatforms;
import org.screamingsandals.bedwars.lib.takenaka.accessor.util.ExceptionUtil;

public class ConstructorMapping {
    private final ClassMapping parent;
    private final int index;
    private final Map<String, Map<String, String[]>> mappings;

    public ConstructorMapping(@NotNull ClassMapping parent, int index) {
        this(parent, index, new HashMap<String, Map<String, String[]>>());
    }

    public ConstructorMapping(@NotNull ClassMapping parent, int index, @NotNull Map<String, Map<String, String[]>> mappings) {
        this.parent = parent;
        this.index = index;
        this.mappings = mappings;
    }

    @Nullable
    public Map<String, String[]> getMappings(@NotNull String version) {
        return this.mappings.get(version);
    }

    @Nullable
    public String[] getName(@NotNull String version, String ... namespaces) {
        Map<String, String[]> versionMappings = this.getMappings(version);
        if (versionMappings == null) {
            return null;
        }
        for (String namespace : namespaces) {
            String[] types = versionMappings.get(namespace);
            if (types == null) continue;
            return types;
        }
        return null;
    }

    @Nullable
    public Constructor<?> getConstructor(@NotNull ClassLoader loader, @NotNull String version, String ... namespaces) {
        Class<?> clazz = this.parent.getClass(loader, version, namespaces);
        if (clazz == null) {
            return null;
        }
        String[] types = this.getName(version, namespaces);
        if (types == null) {
            return null;
        }
        Class[] paramClasses = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> paramClass = MethodMapping.parseClass(loader, types[i]);
            if (paramClass == null) {
                return null;
            }
            paramClasses[i] = paramClass;
        }
        try {
            return clazz.getConstructor(paramClasses);
        }
        catch (NoSuchMethodException ignored) {
            try {
                Constructor<?> ctor = clazz.getDeclaredConstructor(paramClasses);
                ctor.setAccessible(true);
                return ctor;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }

    @Nullable
    public Constructor<?> getConstructor(@NotNull String version, String ... namespaces) {
        return this.getConstructor(Thread.currentThread().getContextClassLoader(), version, namespaces);
    }

    @Nullable
    public Constructor<?> getConstructor(@NotNull MapperPlatform platform) {
        return this.getConstructor(platform.getClassLoader(), platform.getVersion(), platform.getMappingNamespaces());
    }

    @Nullable
    public Constructor<?> getConstructor() {
        return this.getConstructor(MapperPlatforms.getCurrentPlatform());
    }

    @Nullable
    public MethodHandle getConstructorHandle(@NotNull ClassLoader loader, @NotNull String version, String ... namespaces) {
        Constructor<?> ctor = this.getConstructor(loader, version, namespaces);
        if (ctor == null) {
            return null;
        }
        try {
            return MethodHandles.lookup().unreflectConstructor(ctor);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.sneakyThrow(e);
            return null;
        }
    }

    @Nullable
    public MethodHandle getConstructorHandle(@NotNull String version, String ... namespaces) {
        return this.getConstructorHandle(Thread.currentThread().getContextClassLoader(), version, namespaces);
    }

    @Nullable
    public MethodHandle getConstructorHandle(@NotNull MapperPlatform platform) {
        return this.getConstructorHandle(platform.getClassLoader(), platform.getVersion(), platform.getMappingNamespaces());
    }

    @Nullable
    public MethodHandle getConstructorHandle() {
        return this.getConstructorHandle(MapperPlatforms.getCurrentPlatform());
    }

    @ApiStatus.Internal
    @Contract(value="_, _, _ -> this")
    @NotNull
    public ConstructorMapping put(@NotNull String namespace, @NotNull String[] versions, String ... types) {
        for (String version : versions) {
            this.mappings.computeIfAbsent(version, k -> new HashMap()).put(namespace, types);
        }
        return this;
    }

    @NotNull
    public ClassMapping getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public Map<String, Map<String, String[]>> getMappings() {
        return this.mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorMapping that = (ConstructorMapping)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.parent != that.parent) {
            return false;
        }
        return this.mappings.equals(that.mappings);
    }

    public int hashCode() {
        int result = System.identityHashCode(this.parent);
        result = 31 * result + this.index;
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    public String toString() {
        return "ConstructorMapping{index=" + this.index + ", mappings=" + this.mappings + '}';
    }
}

