/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.takenaka.accessor.mapping;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.lib.takenaka.accessor.mapping.ClassMapping;
import org.screamingsandals.bedwars.lib.takenaka.accessor.platform.MapperPlatform;
import org.screamingsandals.bedwars.lib.takenaka.accessor.platform.MapperPlatforms;
import org.screamingsandals.bedwars.lib.takenaka.accessor.util.ExceptionUtil;

public class FieldMapping {
    private static final Object UNINITIALIZED_VALUE = new Object();
    private final ClassMapping parent;
    private final String name;
    private final int index;
    private final Map<String, Map<String, String>> mappings;
    private volatile Object constantValue = UNINITIALIZED_VALUE;

    public FieldMapping(@NotNull ClassMapping parent, @NotNull String name) {
        this(parent, name, new HashMap<String, Map<String, String>>());
    }

    public FieldMapping(@NotNull ClassMapping parent, @NotNull String name, @NotNull Map<String, Map<String, String>> mappings) {
        this(parent, name, 0, mappings);
    }

    public FieldMapping(@NotNull ClassMapping parent, @NotNull String name, int index) {
        this(parent, name, index, new HashMap<String, Map<String, String>>());
    }

    public FieldMapping(@NotNull ClassMapping parent, @NotNull String name, int index, @NotNull Map<String, Map<String, String>> mappings) {
        this.parent = parent;
        this.name = name;
        this.index = index;
        this.mappings = mappings;
    }

    @Nullable
    public Map<String, String> getMappings(@NotNull String version) {
        return this.mappings.get(version);
    }

    @Nullable
    public String getName(@NotNull String version, String ... namespaces) {
        Map<String, String> versionMappings = this.getMappings(version);
        if (versionMappings == null) {
            return null;
        }
        for (String namespace : namespaces) {
            String name = versionMappings.get(namespace);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public FieldMapping chain(@NotNull FieldMapping other) {
        if (this.parent != other.parent) {
            throw new IllegalArgumentException("Could not chain field mappings, disassociated mapping parent");
        }
        HashMap<String, Map<String, String>> newMappings = new HashMap<String, Map<String, String>>(other.mappings.size());
        for (Map.Entry<String, Map<String, String>> entry : other.mappings.entrySet()) {
            HashMap<String, String> newMappings1 = new HashMap<String, String>(entry.getValue().size());
            newMappings1.putAll(entry.getValue());
            newMappings.put(entry.getKey(), newMappings1);
        }
        for (Map.Entry<String, Map<String, String>> entry : this.mappings.entrySet()) {
            newMappings.computeIfAbsent(entry.getKey(), k -> new HashMap(((Map)entry.getValue()).size())).putAll(entry.getValue());
        }
        return new FieldMapping(this.parent, this.name, -1, newMappings);
    }

    @Nullable
    public Field getField(@NotNull ClassLoader loader, @NotNull String version, String ... namespaces) {
        Class<?> clazz = this.parent.getClass(loader, version, namespaces);
        if (clazz == null) {
            return null;
        }
        String name = this.getName(version, namespaces);
        if (name == null) {
            return null;
        }
        while (true) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) continue;
                return null;
            }
            break;
        }
    }

    @Nullable
    public Field getField(@NotNull String version, String ... namespaces) {
        return this.getField(Thread.currentThread().getContextClassLoader(), version, namespaces);
    }

    @Nullable
    public Field getField(@NotNull MapperPlatform platform) {
        return this.getField(platform.getClassLoader(), platform.getVersion(), platform.getMappingNamespaces());
    }

    @Nullable
    public Field getField() {
        return this.getField(MapperPlatforms.getCurrentPlatform());
    }

    @Nullable
    public MethodHandle getFieldGetter(@NotNull ClassLoader loader, @NotNull String version, String ... namespaces) {
        Field field = this.getField(loader, version, namespaces);
        if (field == null) {
            return null;
        }
        try {
            return MethodHandles.lookup().unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.sneakyThrow(e);
            return null;
        }
    }

    @Nullable
    public MethodHandle getFieldGetter(@NotNull String version, String ... namespaces) {
        return this.getFieldGetter(Thread.currentThread().getContextClassLoader(), version, namespaces);
    }

    @Nullable
    public MethodHandle getFieldGetter(@NotNull MapperPlatform platform) {
        return this.getFieldGetter(platform.getClassLoader(), platform.getVersion(), platform.getMappingNamespaces());
    }

    @Nullable
    public MethodHandle getFieldGetter() {
        return this.getFieldGetter(MapperPlatforms.getCurrentPlatform());
    }

    @Nullable
    public MethodHandle getFieldSetter(@NotNull ClassLoader loader, @NotNull String version, String ... namespaces) {
        Field field = this.getField(loader, version, namespaces);
        if (field == null) {
            return null;
        }
        try {
            return MethodHandles.lookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.sneakyThrow(e);
            return null;
        }
    }

    @Nullable
    public MethodHandle getFieldSetter(@NotNull String version, String ... namespaces) {
        return this.getFieldSetter(Thread.currentThread().getContextClassLoader(), version, namespaces);
    }

    @Nullable
    public MethodHandle getFieldSetter(@NotNull MapperPlatform platform) {
        return this.getFieldSetter(platform.getClassLoader(), platform.getVersion(), platform.getMappingNamespaces());
    }

    @Nullable
    public MethodHandle getFieldSetter() {
        return this.getFieldSetter(MapperPlatforms.getCurrentPlatform());
    }

    @Nullable
    public Object getConstantValue() {
        if (this.constantValue != UNINITIALIZED_VALUE) {
            return this.constantValue;
        }
        Field field = this.getField();
        if (field == null) {
            return null;
        }
        try {
            this.constantValue = field.get(null);
            return this.constantValue;
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.sneakyThrow(e);
            return null;
        }
    }

    @ApiStatus.Internal
    @Contract(value="_, _, _ -> this")
    @NotNull
    public FieldMapping put(@NotNull String namespace, @NotNull String mapping, String ... versions) {
        for (String version : versions) {
            this.mappings.computeIfAbsent(version, k -> new HashMap()).put(namespace, mapping);
        }
        return this;
    }

    @NotNull
    public ClassMapping getParent() {
        return this.parent;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public Map<String, Map<String, String>> getMappings() {
        return this.mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMapping that = (FieldMapping)o;
        if (this.parent != that.parent) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.mappings.equals(that.mappings);
    }

    public int hashCode() {
        int result = System.identityHashCode(this.parent);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    public String toString() {
        return "FieldMapping{name='" + this.name + '\'' + ", mappings=" + this.mappings + '}';
    }
}

