/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.takenaka.accessor.platform;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.lib.takenaka.accessor.platform.MapperPlatform;

public enum MapperPlatforms implements MapperPlatform
{
    MOJANG{
        private String minecraftVersion = null;
        {
            try {
                Class<?> constClass = Class.forName("net.minecraft.SharedConstants", true, this.getClassLoader());
                Object gameVersion = constClass.getMethod("getCurrentVersion", new Class[0]).invoke(null, new Object[0]);
                try {
                    this.minecraftVersion = (String)gameVersion.getClass().getMethod("id", new Class[0]).invoke(gameVersion, new Object[0]);
                }
                catch (NoSuchMethodException ignored) {
                    this.minecraftVersion = (String)gameVersion.getClass().getMethod("getId", new Class[0]).invoke(gameVersion, new Object[0]);
                }
                if (this.minecraftVersion == null || this.minecraftVersion.length() == 32 && !this.minecraftVersion.contains(".")) {
                    try {
                        this.minecraftVersion = (String)gameVersion.getClass().getMethod("name", new Class[0]).invoke(gameVersion, new Object[0]);
                    }
                    catch (NoSuchMethodException ignored) {
                        this.minecraftVersion = (String)gameVersion.getClass().getMethod("getName", new Class[0]).invoke(gameVersion, new Object[0]);
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to get Minecraft version", e);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }

        @Override
        public boolean isSupported() {
            return this.minecraftVersion != null;
        }

        @Override
        @NotNull
        public String getVersion() {
            if (!this.isSupported()) {
                throw new UnsupportedOperationException("Mojang is not supported by this environment");
            }
            return this.minecraftVersion;
        }

        @Override
        @NotNull
        public String[] getMappingNamespaces() {
            return new String[]{"mojang"};
        }
    }
    ,
    BUKKIT{
        private String minecraftVersion = null;
        {
            try {
                Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit", true, this.getClassLoader());
                try {
                    this.minecraftVersion = (String)bukkitClass.getMethod("getMinecraftVersion", new Class[0]).invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException ignored) {
                    String versionString = (String)bukkitClass.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
                    Pattern versionPattern = Pattern.compile("\\(MC: ([^)]+?)\\)");
                    Matcher matcher = versionPattern.matcher(versionString);
                    if (!matcher.find()) {
                        throw new RuntimeException("Failed to find Minecraft version in version string " + versionString);
                    }
                    this.minecraftVersion = matcher.group(1);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to get Minecraft version", e);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean isSupported() {
            return this.minecraftVersion != null;
        }

        @Override
        @NotNull
        public String getVersion() {
            if (!this.isSupported()) {
                throw new UnsupportedOperationException("Bukkit is not supported by this environment");
            }
            return this.minecraftVersion;
        }

        @Override
        @NotNull
        public String[] getMappingNamespaces() {
            return new String[]{"spigot"};
        }
    }
    ,
    NEOFORGE{

        @Override
        public boolean isSupported() {
            return MOJANG.isSupported();
        }

        @Override
        @NotNull
        public String getVersion() {
            return MOJANG.getVersion();
        }

        @Override
        @NotNull
        public String[] getMappingNamespaces() {
            return MOJANG.getMappingNamespaces();
        }
    }
    ,
    FORGE{
        private String minecraftVersion = null;
        {
            try {
                try {
                    Class<?> mcpVersionClass = Class.forName("net.minecraftforge.versions.mcp.MCPVersion", true, this.getClassLoader());
                    this.minecraftVersion = (String)mcpVersionClass.getMethod("getMCVersion", new Class[0]).invoke(null, new Object[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException ignored) {
                    Class<?> forgeClass = Class.forName("net.minecraftforge.common.MinecraftForge", true, this.getClassLoader());
                    this.minecraftVersion = (String)forgeClass.getField("MC_VERSION").get(null);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | InvocationTargetException e) {
                throw new RuntimeException("Failed to get Minecraft version", e);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean isSupported() {
            return this.minecraftVersion != null;
        }

        @Override
        @NotNull
        public String getVersion() {
            if (!this.isSupported()) {
                throw new UnsupportedOperationException("Forge is not supported by this environment");
            }
            return this.minecraftVersion;
        }

        @Override
        @NotNull
        public String[] getMappingNamespaces() {
            return new String[]{"searge"};
        }
    };

    private static final ServiceLoader<MapperPlatform> LOADER;
    private static volatile MapperPlatform CURRENT;

    @NotNull
    public static MapperPlatform getCurrentPlatform() {
        if (CURRENT == null) {
            CURRENT = MapperPlatforms.findSupportedPlatform();
        }
        return CURRENT;
    }

    public static void setCurrentPlatform(@NotNull MapperPlatform platform) {
        CURRENT = platform;
    }

    @NotNull
    private static MapperPlatform findSupportedPlatform() {
        return Stream.concat(Arrays.stream(MapperPlatforms.values()), StreamSupport.stream(LOADER.spliterator(), false)).filter(MapperPlatform::isSupported).findFirst().orElseThrow(() -> new RuntimeException("Failed to find a supported platform, specify one with MapperPlatforms#setCurrentPlatform manually"));
    }

    @Override
    @NotNull
    public ClassLoader getClassLoader() {
        return MapperPlatforms.class.getClassLoader();
    }

    static {
        LOADER = ServiceLoader.load(MapperPlatform.class, MapperPlatforms.class.getClassLoader());
        CURRENT = null;
    }
}

