/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.lib.takenaka.accessor.util;

import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class LazySupplier<T>
implements Supplier<T> {
    private static final Object UNINITIALIZED_VALUE = new Object();
    private final Supplier<T> resultSupplier;
    private volatile T value = UNINITIALIZED_VALUE;

    private LazySupplier(@NotNull Supplier<T> resultSupplier) {
        this.resultSupplier = resultSupplier;
    }

    @NotNull
    public static <T> LazySupplier<T> of(@NotNull Supplier<T> resultSupplier) {
        return new LazySupplier<T>(resultSupplier);
    }

    @Override
    public T get() {
        if (!this.isInitialized()) {
            this.value = this.resultSupplier.get();
        }
        return this.value;
    }

    public boolean isInitialized() {
        return this.value != UNINITIALIZED_VALUE;
    }

    @ApiStatus.Internal
    @NotNull
    public Supplier<T> getResultSupplier() {
        return this.resultSupplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazySupplier that = (LazySupplier)o;
        return Objects.equals(this.resultSupplier, that.resultSupplier);
    }

    public int hashCode() {
        return Objects.hash(this.resultSupplier);
    }
}

