/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.listener;

import com.alessiodp.parties.api.Parties;
import com.alessiodp.parties.api.interfaces.PartiesAPI;
import com.alessiodp.parties.api.interfaces.Party;
import com.alessiodp.parties.api.interfaces.PartyPlayer;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinedEvent;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.lib.lang.I;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class PartyListener
implements Listener {
    @EventHandler
    public void onBedWarsPlayerJoined(BedwarsPlayerJoinedEvent e) {
        List<Player> players;
        UUID leaderUUID;
        Party party;
        if (!Main.getConfigurator().config.getBoolean("party.autojoin-members")) {
            return;
        }
        Player player = e.getPlayer();
        PartiesAPI partyApi = Parties.getApi();
        PartyPlayer partyPlayer = partyApi.getPartyPlayer(player.getUniqueId());
        Game game = (Game)e.getGame();
        if (partyPlayer.getPartyId() != null && (party = partyApi.getParty(partyPlayer.getPartyId())) != null && (leaderUUID = party.getLeader()) != null && leaderUUID.equals(player.getUniqueId()) && (players = MiscUtils.getOnlinePlayers(party.getMembers())).size() > 1) {
            players.forEach(partyMember -> {
                if (partyMember != null) {
                    Game gameOfPlayer;
                    if (partyMember.getUniqueId().equals(player.getUniqueId())) {
                        return;
                    }
                    player.sendMessage(I.i18n("party_inform_game_join"));
                    Game game2 = gameOfPlayer = Main.isPlayerInGame(partyMember) ? Main.getPlayerGameProfile(partyMember).getGame() : null;
                    if (gameOfPlayer != null) {
                        if (gameOfPlayer.getName().equalsIgnoreCase(game.getName())) {
                            return;
                        }
                        gameOfPlayer.leaveFromGame((Player)partyMember);
                    }
                    game.joinToGame((Player)partyMember);
                }
            });
            if (Main.getConfigurator().config.getBoolean("party.notify-when-warped")) {
                player.sendMessage(I.i18n("party_command_warped"));
            }
        }
    }
}

