/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.listener;

import java.util.Arrays;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GameCreator;
import org.screamingsandals.bedwars.game.GamePlayer;

public class Player19Listener
implements Listener {
    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        GamePlayer gPlayer;
        Player player = event.getPlayer();
        if (Main.isPlayerInGame(player) && (gPlayer = Main.getPlayerGameProfile(player)).getGame().getStatus() == GameStatus.WAITING) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (Main.isPlayerInGame(player)) {
            GamePlayer gPlayer = Main.getPlayerGameProfile(player);
            Game game = gPlayer.getGame();
            if (game.getOriginalOrInheritedDamageWhenPlayerIsNotInArena() && game.getStatus() == GameStatus.RUNNING && !gPlayer.isSpectator) {
                if (!GameCreator.isInArea(event.getTo(), game.getPos1(), game.getPos2())) {
                    AttributeInstance armor = player.getAttribute(Attribute.GENERIC_ARMOR);
                    AttributeInstance armorToughness = null;
                    if (Arrays.stream(Attribute.values()).anyMatch(attribute -> "GENERIC_ARMOR_TOUGHNESS".equals(attribute.name()))) {
                        armorToughness = player.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS);
                    }
                    if (armor == null) {
                        player.damage(5.0);
                    } else {
                        double multiplier = 1.0 - Math.min(20.0, Math.max(armor.getValue() / 5.0, armor.getValue() - 20.0 / ((armorToughness != null ? armorToughness.getValue() : 0.0) + 8.0))) / 25.0;
                        if (multiplier < 1.0) {
                            multiplier = 2.0 - multiplier;
                        }
                        double weaponDamage = multiplier * 5.0;
                        player.damage(weaponDamage);
                    }
                }
            } else if (Main.getConfigurator().config.getBoolean("preventSpectatorFlyingAway", false) && gPlayer.isSpectator && (game.getStatus() == GameStatus.RUNNING || game.getStatus() == GameStatus.GAME_END_CELEBRATING) && !GameCreator.isInArea(event.getTo(), game.getPos1(), game.getPos2())) {
                event.setCancelled(true);
            }
        }
    }
}

