/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.listener;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsOpenShopEvent;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.CurrentTeam;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.GameStore;
import org.screamingsandals.bedwars.utils.CitizensUtils;

public class VillagerListener
implements Listener {
    @EventHandler
    public void onVillagerInteract(PlayerInteractEntityEvent event) {
        if (Main.isPlayerInGame(event.getPlayer())) {
            GamePlayer gPlayer = Main.getPlayerGameProfile(event.getPlayer());
            Game game = gPlayer.getGame();
            if (event.getRightClicked().getType().isAlive() && !gPlayer.isSpectator && gPlayer.getGame().getStatus() == GameStatus.RUNNING) {
                GameStore npcStore;
                if (Bukkit.getPluginManager().isPluginEnabled("Citizens") && (npcStore = CitizensUtils.getFromNPC(event.getRightClicked())) != null) {
                    event.setCancelled(true);
                    this.open(npcStore, event, game);
                    return;
                }
                for (GameStore store : game.getGameStoreList()) {
                    if (!event.getRightClicked().equals(store.getEntity())) continue;
                    event.setCancelled(true);
                    this.open(store, event, game);
                }
            }
        }
    }

    public void open(GameStore store, PlayerInteractEntityEvent event, Game game) {
        BedwarsOpenShopEvent openShopEvent = new BedwarsOpenShopEvent(game, event.getPlayer(), store, event.getRightClicked());
        if (Main.getConfigurator().config.getBoolean("disable-opening-stores-of-other-teams") && store.getTeam() != null && store.getTeam() != ((CurrentTeam)game.getTeamOfPlayer((Player)event.getPlayer())).teamInfo) {
            openShopEvent.setResult(BedwarsOpenShopEvent.Result.DISALLOW_WRONG_TEAM);
        }
        Main.getInstance().getServer().getPluginManager().callEvent((Event)openShopEvent);
        if (openShopEvent.getResult() != BedwarsOpenShopEvent.Result.ALLOW) {
            return;
        }
        Main.openStore(event.getPlayer(), store);
    }
}

