/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.listener;

import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GameCreator;

public class WorldListener
implements Listener {
    @EventHandler
    public void onBurn(BlockBurnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.onBlockChange(event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onFade(BlockFadeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.onBlockChange(event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onLeavesDecay(LeavesDecayEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.onBlockChange(event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onGrow(BlockGrowEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getNewState().getType() == Material.SNOW) {
            return;
        }
        this.onBlockChange(event.getBlock(), (Cancellable)event);
    }

    public void onBlockChange(Block block, Cancellable cancellable) {
        for (String s : Main.getGameNames()) {
            Game game = Main.getGame(s);
            if (game.getStatus() != GameStatus.RUNNING && game.getStatus() != GameStatus.GAME_END_CELEBRATING || !GameCreator.isInArea(block.getLocation(), game.getPos1(), game.getPos2())) continue;
            if (!Main.isFarmBlock(block.getType()) && !game.isBlockAddedDuringGame(block.getLocation())) {
                cancellable.setCancelled(true);
            }
            return;
        }
    }

    @EventHandler
    public void onExplode(EntityExplodeEvent event) {
        ProjectileSource shooter;
        boolean originatedInArena;
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        boolean bl = originatedInArena = Main.getInGameEntity(entity) != null;
        if (!originatedInArena && entity instanceof Projectile && (shooter = ((Projectile)entity).getShooter()) instanceof Player) {
            originatedInArena = Main.isPlayerInGame((Player)shooter);
        }
        this.onExplode(event.getLocation(), event.blockList(), (Cancellable)event, originatedInArena);
    }

    @EventHandler
    public void onExplode(BlockExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.onExplode(event.getBlock().getLocation(), event.blockList(), (Cancellable)event, false);
    }

    public void onExplode(Location location, List<Block> blockList, Cancellable cancellable, boolean originatedInArena) {
        if (cancellable.isCancelled()) {
            return;
        }
        List explosionExceptionTypeName = Main.getConfigurator().config.getStringList("destroy-placed-blocks-by-explosion-except");
        boolean destroyPlacedBlocksByExplosion = Main.getConfigurator().config.getBoolean("destroy-placed-blocks-by-explosion", true);
        boolean breakableExplosions = Main.getConfigurator().config.getBoolean("breakable.enabled") && Main.getConfigurator().config.getBoolean("breakable.explosions");
        for (String gameName : Main.getGameNames()) {
            Game game = Main.getGame(gameName);
            if (!GameCreator.isInArea(location, game.getPos1(), game.getPos2())) continue;
            if (game.getStatus() == GameStatus.RUNNING || game.getStatus() == GameStatus.GAME_END_CELEBRATING) {
                blockList.removeIf(block -> {
                    if (!game.isBlockAddedDuringGame(block.getLocation())) {
                        if (game.getOriginalOrInheritedTargetBlockExplosions()) {
                            for (RunningTeam team : game.getRunningTeams()) {
                                if (!team.getTargetBlock().equals((Object)block.getLocation())) continue;
                                game.targetBlockExplode(team);
                                return true;
                            }
                        }
                        if (breakableExplosions && Main.isBreakableBlock(block.getType())) {
                            game.getRegion().putOriginalBlock(block.getLocation(), block.getState());
                            return false;
                        }
                        return true;
                    }
                    return explosionExceptionTypeName.stream().anyMatch(s -> s.equalsIgnoreCase(block.getType().name())) || !destroyPlacedBlocksByExplosion;
                });
            } else {
                cancellable.setCancelled(true);
            }
            return;
        }
        if (originatedInArena) {
            cancellable.setCancelled(true);
        }
    }

    @EventHandler
    public void onIgnite(BlockIgniteEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (String gameName : Main.getGameNames()) {
            Game game = Main.getGame(gameName);
            if (game.getStatus() != GameStatus.RUNNING && game.getStatus() != GameStatus.GAME_END_CELEBRATING || !GameCreator.isInArea(event.getBlock().getLocation(), game.getPos1(), game.getPos2())) continue;
            game.getRegion().addBuiltDuringGame(event.getBlock().getLocation());
            return;
        }
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (String gameName : Main.getGameNames()) {
            Game game = Main.getGame(gameName);
            if (game.getStatus() != GameStatus.RUNNING && game.getStatus() != GameStatus.GAME_END_CELEBRATING || !GameCreator.isInArea(event.getLocation(), game.getPos1(), game.getPos2())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled() || event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        for (String gameName : Main.getGameNames()) {
            Game game = Main.getGame(gameName);
            if (game.getStatus() == GameStatus.DISABLED || !game.getOriginalOrInheritedPreventSpawningMobs()) continue;
            if (GameCreator.isInArea(event.getLocation(), game.getPos1(), game.getPos2())) {
                event.setCancelled(true);
                return;
            }
            if (game.getLobbyWorld() != event.getLocation().getWorld() || !(event.getLocation().distanceSquared(game.getLobbySpawn()) <= Math.pow(Main.getConfigurator().config.getInt("prevent-lobby-spawn-mobs-in-radius"), 2.0))) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onLiquidFlow(BlockFromToEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (String gameName : Main.getGameNames()) {
            Game game = Main.getGame(gameName);
            if (!GameCreator.isInArea(event.getBlock().getLocation(), game.getPos1(), game.getPos2())) continue;
            if (game.getStatus() == GameStatus.RUNNING || game.getStatus() == GameStatus.GAME_END_CELEBRATING) {
                Block block = event.getToBlock();
                if (block.getType() == Material.AIR || game.getRegion().isBlockAddedDuringGame(block.getLocation())) {
                    game.getRegion().addBuiltDuringGame(block.getLocation());
                    continue;
                }
                event.setCancelled(true);
                continue;
            }
            if (game.getStatus() == GameStatus.DISABLED) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (String gameName : Main.getGameNames()) {
            Game game = Main.getGame(gameName);
            if (!GameCreator.isInArea(event.getBlock().getLocation(), game.getPos1(), game.getPos2())) continue;
            if ((game.getStatus() == GameStatus.RUNNING || game.getStatus() == GameStatus.GAME_END_CELEBRATING) && event.getEntityType() == EntityType.FALLING_BLOCK && game.getOriginalOrInheritedAllowBlockFalling()) {
                if (event.getBlock().getType() != event.getTo() && !game.getRegion().isBlockAddedDuringGame(event.getBlock().getLocation())) {
                    if (event.getBlock().getType() != Material.AIR) {
                        game.getRegion().putOriginalBlock(event.getBlock().getLocation(), event.getBlock().getState());
                    }
                    game.getRegion().addBuiltDuringGame(event.getBlock().getLocation());
                }
                return;
            }
            if (game.getStatus() == GameStatus.DISABLED) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBedWarsSpawnIsCancelled(CreatureSpawnEvent event) {
        if (!event.isCancelled()) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM && Main.getInstance().isEntityInGame((Entity)event.getEntity())) {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent unload) {
        if (unload instanceof Cancellable) {
            Chunk chunk = unload.getChunk();
            for (String name : Main.getGameNames()) {
                Game game = Main.getGame(name);
                if (game.getStatus() == GameStatus.DISABLED || game.getStatus() == GameStatus.WAITING || !GameCreator.isChunkInArea(chunk, game.getPos1(), game.getPos2())) continue;
                ((Cancellable)unload).setCancelled(true);
                return;
            }
        }
    }
}

