/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.placeholderapi;

import java.util.Locale;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.api.statistics.LeaderboardEntry;
import org.screamingsandals.bedwars.game.CurrentTeam;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.Team;
import org.screamingsandals.bedwars.listener.Player116ListenerUtils;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;

public class BedwarsExpansion
extends PlaceholderExpansion {
    public String getAuthor() {
        return String.join((CharSequence)", ", Main.getInstance().getDescription().getAuthors());
    }

    public String getIdentifier() {
        return "bedwars";
    }

    public String getVersion() {
        return Main.getVersion();
    }

    public String getPlugin() {
        return Main.getInstance().getName();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        String operation;
        Game game2;
        if (identifier.startsWith("game_")) {
            int index;
            String gameName = identifier.substring(5);
            String operation2 = gameName.substring((index = gameName.lastIndexOf("_")) + 1).toLowerCase(Locale.ROOT);
            if (operation2.equals("teams")) {
                index = gameName.lastIndexOf("_", index - 1);
                operation2 = gameName.substring(index + 1).toLowerCase(Locale.ROOT);
            } else if (gameName.contains("_team_")) {
                index = gameName.indexOf("_team_");
                operation2 = gameName.substring(index + 1).toLowerCase(Locale.ROOT);
            }
            gameName = gameName.substring(0, index);
            game2 = Main.getGame(gameName);
            if (game2 != null) {
                if (operation2.startsWith("team_") && (index = operation2.lastIndexOf("_")) != -1) {
                    String teamName = operation2.substring(5, index);
                    String teamOperation = operation2.substring(index + 1).toLowerCase(Locale.ROOT);
                    Team team = (Team)game2.getTeamFromName(teamName);
                    if (team != null) {
                        switch (teamOperation) {
                            case "colored": {
                                return team.color.chatColor + team.getName();
                            }
                            case "color": {
                                return team.color.chatColor.toString();
                            }
                            case "ingame": {
                                return game2.getCurrentTeamByTeam(team) != null ? "yes" : "no";
                            }
                            case "players": {
                                CurrentTeam ct = game2.getCurrentTeamByTeam(team);
                                if (ct != null) {
                                    return Integer.toString(ct.countConnectedPlayers());
                                }
                                return "0";
                            }
                            case "maxplayers": {
                                return Integer.toString(team.getMaxPlayers());
                            }
                            case "bed": {
                                CurrentTeam ct = game2.getCurrentTeamByTeam(team);
                                if (ct != null) {
                                    return ct.isBed ? "yes" : "no";
                                }
                                return "no";
                            }
                            case "bedsymbol": {
                                CurrentTeam ct = game2.getCurrentTeamByTeam(team);
                                if (ct != null) {
                                    boolean empty;
                                    boolean bl = empty = ct.isBed && "RESPAWN_ANCHOR".equals(team.bed.getBlock().getType().name()) && Player116ListenerUtils.isAnchorEmpty(team.bed.getBlock());
                                    return !ct.isBed ? Game.bedLostString() : (empty ? Game.anchorEmptyString() : Game.bedExistString());
                                }
                                return Game.bedLostString();
                            }
                            case "teamchests": {
                                CurrentTeam ct = game2.getCurrentTeamByTeam(team);
                                if (ct != null) {
                                    return Integer.toString(ct.countTeamChests());
                                }
                                return "0";
                            }
                        }
                    }
                }
                switch (operation2) {
                    case "name": {
                        return game2.getName();
                    }
                    case "players": {
                        return Integer.toString(game2.countConnectedPlayers());
                    }
                    case "maxplayers": {
                        return Integer.toString(game2.getMaxPlayers());
                    }
                    case "minplayers": {
                        return Integer.toString(game2.getMinPlayers());
                    }
                    case "time": {
                        return Integer.toString(game2.getCountdown());
                    }
                    case "timeformat": {
                        return Game.getFormattedTimeLeftS(game2.getCountdown());
                    }
                    case "elapsedtime": {
                        switch (game2.getStatus()) {
                            case WAITING: {
                                return Integer.toString(game2.getLobbyCountdown() - game2.getCountdown());
                            }
                            case RUNNING: {
                                return Integer.toString(game2.getGameTime() - game2.getCountdown());
                            }
                            case GAME_END_CELEBRATING: {
                                return Integer.toString(game2.getPostGameWaiting() - game2.getCountdown());
                            }
                            case REBUILDING: 
                            case DISABLED: {
                                return "0";
                            }
                        }
                    }
                    case "elapsedtimeformat": {
                        switch (game2.getStatus()) {
                            case WAITING: {
                                return Game.getFormattedTimeLeftS(game2.getLobbyCountdown() - game2.getCountdown());
                            }
                            case RUNNING: {
                                return Game.getFormattedTimeLeftS(game2.getGameTime() - game2.getCountdown());
                            }
                            case GAME_END_CELEBRATING: {
                                return Game.getFormattedTimeLeftS(game2.getPostGameWaiting() - game2.getCountdown());
                            }
                            case REBUILDING: 
                            case DISABLED: {
                                return Game.getFormattedTimeLeftS(0);
                            }
                        }
                    }
                    case "world": {
                        return game2.getWorld().getName();
                    }
                    case "state": {
                        return game2.getStatus().name().toLowerCase();
                    }
                    case "running": {
                        return game2.getStatus() == GameStatus.RUNNING || game2.getStatus() == GameStatus.GAME_END_CELEBRATING ? "true" : "false";
                    }
                    case "waiting": {
                        return game2.getStatus() == GameStatus.WAITING ? "true" : "false";
                    }
                    case "aviable_teams": 
                    case "available_teams": {
                        return Integer.toString(game2.countAvailableTeams());
                    }
                    case "connected_teams": {
                        return Integer.toString(game2.countRunningTeams());
                    }
                    case "teamchests": {
                        return Integer.toString(game2.countTeamChests());
                    }
                }
            }
        }
        if (identifier.startsWith("all_games_")) {
            switch (operation = identifier.substring(10).toLowerCase(Locale.ROOT)) {
                case "players": {
                    return Integer.toString(Main.getGameNames().stream().map(Main::getGame).mapToInt(Game::countConnectedPlayers).sum());
                }
                case "maxplayers": {
                    return Integer.toString(Main.getGameNames().stream().map(Main::getGame).mapToInt(Game::getMaxPlayers).sum());
                }
                case "anyrunning": {
                    return Main.getGameNames().stream().map(Main::getGame).anyMatch(game -> game.getStatus() == GameStatus.RUNNING || game.getStatus() == GameStatus.GAME_END_CELEBRATING) ? "true" : "false";
                }
                case "anywaiting": {
                    return Main.getGameNames().stream().map(Main::getGame).anyMatch(game -> game.getStatus() == GameStatus.WAITING) ? "true" : "false";
                }
            }
        }
        if (identifier.startsWith("otherstats_")) {
            int index;
            if (!Main.isPlayerStatisticsEnabled()) {
                return null;
            }
            String playerName = identifier.substring(11);
            String operation3 = playerName.substring((index = playerName.lastIndexOf("_")) + 1).toLowerCase(Locale.ROOT);
            if (operation3.equals("beds")) {
                index = playerName.lastIndexOf("_", index - 1);
                operation3 = playerName.substring(index + 1).toLowerCase(Locale.ROOT);
            }
            playerName = playerName.substring(0, index);
            PlayerStatistic stats = Main.getPlayerStatisticsManager().getStatistic(Bukkit.getOfflinePlayer((String)playerName));
            if (stats == null) {
                return null;
            }
            switch (operation3) {
                case "deaths": {
                    return Integer.toString(stats.getDeaths());
                }
                case "destroyed_beds": {
                    return Integer.toString(stats.getDestroyedBeds());
                }
                case "kills": {
                    return Integer.toString(stats.getKills());
                }
                case "loses": {
                    return Integer.toString(stats.getLoses());
                }
                case "score": {
                    return Integer.toString(stats.getScore());
                }
                case "wins": {
                    return Integer.toString(stats.getWins());
                }
                case "games": {
                    return Integer.toString(stats.getGames());
                }
                case "kd": {
                    return Double.toString(stats.getKD());
                }
            }
        }
        if (identifier.startsWith("leaderboard_score_")) {
            int index;
            if (!Main.isPlayerStatisticsEnabled()) {
                return null;
            }
            String remainder = identifier.substring(18);
            String[] split = remainder.split("_", 2);
            if (split.length != 2) {
                return null;
            }
            try {
                index = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (--index < 0) {
                return null;
            }
            LeaderboardEntry entry = Main.getPlayerStatisticsManager().getLeaderboardEntry(index);
            if (entry == null) {
                switch (split[1].toLowerCase(Locale.ROOT)) {
                    case "uuid": 
                    case "name": {
                        return "---";
                    }
                    case "score": 
                    case "deaths": 
                    case "destroyed_beds": 
                    case "kills": 
                    case "loses": 
                    case "wins": 
                    case "games": 
                    case "kd": {
                        return "0";
                    }
                }
            } else {
                switch (split[1].toLowerCase(Locale.ROOT)) {
                    case "uuid": {
                        return entry.getPlayer().getUniqueId().toString();
                    }
                    case "name": {
                        return entry.getLatestKnownName();
                    }
                    case "score": {
                        return Integer.toString(entry.getTotalScore());
                    }
                    case "deaths": {
                        return Integer.toString(entry.fetchStatistics().getDeaths());
                    }
                    case "destroyed_beds": {
                        return Integer.toString(entry.fetchStatistics().getDestroyedBeds());
                    }
                    case "kills": {
                        return Integer.toString(entry.fetchStatistics().getKills());
                    }
                    case "loses": {
                        return Integer.toString(entry.fetchStatistics().getLoses());
                    }
                    case "wins": {
                        return Integer.toString(entry.fetchStatistics().getWins());
                    }
                    case "games": {
                        return Integer.toString(entry.fetchStatistics().getGames());
                    }
                    case "kd": {
                        return Double.toString(entry.fetchStatistics().getKD());
                    }
                }
            }
        }
        if (player == null) {
            return null;
        }
        if (identifier.startsWith("current_")) {
            int index;
            if (identifier.toLowerCase(Locale.ROOT).startsWith("current_game_team_") && (index = (operation = identifier.substring(18)).lastIndexOf("_")) != -1) {
                Team team;
                Game game3;
                String teamName = operation.substring(0, index);
                String teamOperation = operation.substring(index + 1).toLowerCase(Locale.ROOT);
                Game game4 = game3 = Main.isPlayerInGame(player) ? Main.getPlayerGameProfile(player).getGame() : null;
                if (game3 != null && (team = (Team)game3.getTeamFromName(teamName)) != null) {
                    switch (teamOperation) {
                        case "colored": {
                            return team.color.chatColor + team.getName();
                        }
                        case "color": {
                            return team.color.chatColor.toString();
                        }
                        case "ingame": {
                            return game3.getCurrentTeamByTeam(team) != null ? "yes" : "no";
                        }
                        case "players": {
                            CurrentTeam ct = game3.getCurrentTeamByTeam(team);
                            if (ct != null) {
                                return Integer.toString(ct.countConnectedPlayers());
                            }
                            return "0";
                        }
                        case "maxplayers": {
                            return Integer.toString(team.getMaxPlayers());
                        }
                        case "bed": {
                            CurrentTeam ct = game3.getCurrentTeamByTeam(team);
                            if (ct != null) {
                                return ct.isBed ? "yes" : "no";
                            }
                            return "no";
                        }
                        case "bedsymbol": {
                            CurrentTeam ct = game3.getCurrentTeamByTeam(team);
                            if (ct != null) {
                                boolean empty;
                                boolean bl = empty = ct.isBed && "RESPAWN_ANCHOR".equals(team.bed.getBlock().getType().name()) && Player116ListenerUtils.isAnchorEmpty(team.bed.getBlock());
                                return !ct.isBed ? Game.bedLostString() : (empty ? Game.anchorEmptyString() : Game.bedExistString());
                            }
                            return Game.bedLostString();
                        }
                        case "teamchests": {
                            CurrentTeam ct = game3.getCurrentTeamByTeam(team);
                            if (ct != null) {
                                return Integer.toString(ct.countTeamChests());
                            }
                            return "0";
                        }
                    }
                }
            }
            switch (identifier.toLowerCase(Locale.ROOT).substring(8)) {
                case "game": {
                    return Main.isPlayerInGame(player) ? Main.getPlayerGameProfile(player).getGame().getName() : "none";
                }
                case "game_players": {
                    if (Main.isPlayerInGame(player)) {
                        return Integer.toString(Main.getPlayerGameProfile(player).getGame().countConnectedPlayers());
                    }
                    return "0";
                }
                case "game_maxplayers": {
                    if (Main.isPlayerInGame(player)) {
                        return Integer.toString(Main.getPlayerGameProfile(player).getGame().getMaxPlayers());
                    }
                    return "0";
                }
                case "game_minplayers": {
                    if (Main.isPlayerInGame(player)) {
                        return Integer.toString(Main.getPlayerGameProfile(player).getGame().getMinPlayers());
                    }
                    return "0";
                }
                case "game_time": {
                    if (Main.isPlayerInGame(player)) {
                        return Integer.toString(Main.getPlayerGameProfile(player).getGame().getCountdown());
                    }
                    return "0";
                }
                case "game_timeformat": {
                    if (Main.isPlayerInGame(player)) {
                        return Game.getFormattedTimeLeftS(Main.getPlayerGameProfile(player).getGame().getCountdown());
                    }
                    return "0";
                }
                case "game_elapsedtime": {
                    if (Main.isPlayerInGame(player)) {
                        Game game5 = Main.getPlayerGameProfile(player).getGame();
                        switch (game5.getStatus()) {
                            case WAITING: {
                                return Integer.toString(game5.getLobbyCountdown() - game5.getCountdown());
                            }
                            case RUNNING: {
                                return Integer.toString(game5.getGameTime() - game5.getCountdown());
                            }
                            case GAME_END_CELEBRATING: {
                                return Integer.toString(game5.getPostGameWaiting() - game5.getCountdown());
                            }
                            case REBUILDING: 
                            case DISABLED: {
                                return "0";
                            }
                        }
                    } else {
                        return "0";
                    }
                }
                case "game_elapsedtimeformat": {
                    if (Main.isPlayerInGame(player)) {
                        Game game6 = Main.getPlayerGameProfile(player).getGame();
                        switch (game6.getStatus()) {
                            case WAITING: {
                                return Game.getFormattedTimeLeftS(game6.getLobbyCountdown() - game6.getCountdown());
                            }
                            case RUNNING: {
                                return Game.getFormattedTimeLeftS(game6.getGameTime() - game6.getCountdown());
                            }
                            case GAME_END_CELEBRATING: {
                                return Game.getFormattedTimeLeftS(game6.getPostGameWaiting() - game6.getCountdown());
                            }
                            case REBUILDING: 
                            case DISABLED: {
                                return Game.getFormattedTimeLeftS(0);
                            }
                        }
                    } else {
                        return Game.getFormattedTimeLeftS(0);
                    }
                }
                case "game_world": {
                    if (Main.isPlayerInGame(player)) {
                        return Main.getPlayerGameProfile(player).getGame().getWorld().getName();
                    }
                    return "none";
                }
                case "game_state": {
                    if (Main.isPlayerInGame(player)) {
                        return Main.getPlayerGameProfile(player).getGame().getStatus().name().toLowerCase();
                    }
                    return "none";
                }
                case "game_running": {
                    if (Main.isPlayerInGame(player)) {
                        Game game7 = Main.getPlayerGameProfile(player).getGame();
                        return game7.getStatus() == GameStatus.RUNNING || game7.getStatus() == GameStatus.GAME_END_CELEBRATING ? "true" : "false";
                    }
                    return "false";
                }
                case "game_waiting": {
                    if (Main.isPlayerInGame(player)) {
                        return Main.getPlayerGameProfile(player).getGame().getStatus() == GameStatus.WAITING ? "true" : "false";
                    }
                    return "false";
                }
                case "aviable_teams": 
                case "available_teams": {
                    if (Main.isPlayerInGame(player)) {
                        return Integer.toString(Main.getPlayerGameProfile(player).getGame().countAvailableTeams());
                    }
                    return "0";
                }
                case "connected_teams": {
                    if (Main.isPlayerInGame(player)) {
                        return Integer.toString(Main.getPlayerGameProfile(player).getGame().countRunningTeams());
                    }
                    return "0";
                }
                case "teamchests": {
                    if (Main.isPlayerInGame(player)) {
                        return Integer.toString(Main.getPlayerGameProfile(player).getGame().countTeamChests());
                    }
                    return "0";
                }
                case "team": {
                    CurrentTeam team;
                    if (Main.isPlayerInGame(player)) {
                        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
                        game2 = gPlayer.getGame();
                        team = game2.getPlayerTeam(gPlayer);
                        if (team != null) {
                            return team.getName();
                        }
                        if (gPlayer.isSpectator) {
                            return "spectator";
                        }
                        return "none";
                    }
                    return "none";
                }
                case "team_colored": {
                    CurrentTeam team;
                    if (Main.isPlayerInGame(player)) {
                        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
                        game2 = gPlayer.getGame();
                        team = game2.getPlayerTeam(gPlayer);
                        if (team != null) {
                            return team.teamInfo.color.chatColor + team.getName();
                        }
                        if (gPlayer.isSpectator) {
                            return ChatColor.GRAY + "spectator";
                        }
                        return ChatColor.RED + "none";
                    }
                    return ChatColor.RED + "none";
                }
                case "team_color": {
                    CurrentTeam team;
                    if (Main.isPlayerInGame(player)) {
                        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
                        game2 = gPlayer.getGame();
                        team = game2.getPlayerTeam(gPlayer);
                        if (team != null) {
                            return team.teamInfo.color.chatColor.toString();
                        }
                        return ChatColor.GRAY.toString();
                    }
                    return "";
                }
                case "team_players": {
                    CurrentTeam team;
                    if (Main.isPlayerInGame(player)) {
                        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
                        game2 = gPlayer.getGame();
                        team = game2.getPlayerTeam(gPlayer);
                        if (team != null) {
                            return Integer.toString(team.countConnectedPlayers());
                        }
                        return "0";
                    }
                    return "0";
                }
                case "team_maxplayers": {
                    CurrentTeam team;
                    if (Main.isPlayerInGame(player)) {
                        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
                        game2 = gPlayer.getGame();
                        team = game2.getPlayerTeam(gPlayer);
                        if (team != null) {
                            return Integer.toString(team.getMaxPlayers());
                        }
                        return "0";
                    }
                    return "0";
                }
                case "team_bed": {
                    CurrentTeam team;
                    if (Main.isPlayerInGame(player)) {
                        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
                        game2 = gPlayer.getGame();
                        team = game2.getPlayerTeam(gPlayer);
                        if (team != null) {
                            return team.isBed ? "yes" : "no";
                        }
                        return "no";
                    }
                    return "no";
                }
                case "team_bedsymbol": {
                    CurrentTeam team;
                    if (Main.isPlayerInGame(player)) {
                        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
                        game2 = gPlayer.getGame();
                        team = game2.getPlayerTeam(gPlayer);
                        if (team != null) {
                            boolean empty;
                            boolean bl = empty = team.isBed && "RESPAWN_ANCHOR".equals(team.teamInfo.bed.getBlock().getType().name()) && Player116ListenerUtils.isAnchorEmpty(team.teamInfo.bed.getBlock());
                            return !team.isBed ? Game.bedLostString() : (empty ? Game.anchorEmptyString() : Game.bedExistString());
                        }
                        return Game.bedLostString();
                    }
                    return Game.bedLostString();
                }
                case "team_teamchests": {
                    CurrentTeam team;
                    if (Main.isPlayerInGame(player)) {
                        GamePlayer gPlayer = Main.getPlayerGameProfile(player);
                        game2 = gPlayer.getGame();
                        team = game2.getPlayerTeam(gPlayer);
                        if (team != null) {
                            return Integer.toString(team.countTeamChests());
                        }
                        return "0";
                    }
                    return "0";
                }
            }
        }
        if (identifier.startsWith("stats_")) {
            if (!Main.isPlayerStatisticsEnabled()) {
                return null;
            }
            PlayerStatistic stats = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player);
            if (stats == null) {
                return null;
            }
            switch (identifier.toLowerCase(Locale.ROOT).substring(6)) {
                case "deaths": {
                    return Integer.toString(stats.getDeaths());
                }
                case "destroyed_beds": {
                    return Integer.toString(stats.getDestroyedBeds());
                }
                case "kills": {
                    return Integer.toString(stats.getKills());
                }
                case "loses": {
                    return Integer.toString(stats.getLoses());
                }
                case "score": {
                    return Integer.toString(stats.getScore());
                }
                case "wins": {
                    return Integer.toString(stats.getWins());
                }
                case "games": {
                    return Integer.toString(stats.getGames());
                }
                case "kd": {
                    return Double.toString(stats.getKD());
                }
            }
        }
        return null;
    }

    public boolean persist() {
        return true;
    }
}

