/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.region;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.screamingsandals.bedwars.api.Region;
import org.screamingsandals.bedwars.region.FlatteningBedUtils;

public class FlatteningRegion
implements Region {
    private List<Location> builtBlocks = new ArrayList<Location>();
    private Map<Location, BlockData> brokenOriginalBlocks = new HashMap<Location, BlockData>();

    @Override
    public boolean isBlockAddedDuringGame(Location loc) {
        return this.builtBlocks.contains(loc);
    }

    @Override
    public void putOriginalBlock(Location loc, BlockState block) {
        this.brokenOriginalBlocks.put(loc, block.getBlockData());
    }

    @Override
    public void addBuiltDuringGame(Location loc) {
        this.builtBlocks.add(loc);
    }

    @Override
    public void removeBlockBuiltDuringGame(Location loc) {
        this.builtBlocks.remove(loc);
    }

    @Override
    public boolean isLiquid(Material material) {
        return material == Material.WATER || material == Material.LAVA;
    }

    @Override
    public boolean isBedBlock(BlockState block) {
        return block.getBlockData() instanceof Bed;
    }

    @Override
    public void regen() {
        Chunk chunk;
        for (Location location : this.builtBlocks) {
            chunk = location.getChunk();
            if (!chunk.isLoaded()) {
                chunk.load();
            }
            location.getBlock().setType(Material.AIR);
        }
        this.builtBlocks.clear();
        for (Map.Entry entry : this.brokenOriginalBlocks.entrySet()) {
            chunk = ((Location)entry.getKey()).getChunk();
            if (!chunk.isLoaded()) {
                chunk.load();
            }
            ((Location)entry.getKey()).getBlock().setBlockData((BlockData)entry.getValue());
        }
        this.brokenOriginalBlocks.clear();
    }

    @Override
    public boolean isBedHead(BlockState block) {
        return this.isBedBlock(block) && ((Bed)block.getBlockData()).getPart() == Bed.Part.HEAD;
    }

    @Override
    public boolean isDoorBlock(BlockState block) {
        return block.getBlockData() instanceof Door;
    }

    @Override
    public boolean isDoorBottomBlock(BlockState block) {
        return block.getBlockData() instanceof Door && ((Door)block.getBlockData()).getHalf() == Bisected.Half.BOTTOM;
    }

    @Override
    public Block getBedNeighbor(Block head) {
        return FlatteningBedUtils.getBedNeighbor(head);
    }

    @Override
    public boolean isChunkUsed(Chunk chunk) {
        if (chunk == null) {
            return false;
        }
        for (Location loc : this.builtBlocks) {
            if (!chunk.equals(loc.getChunk())) continue;
            return true;
        }
        for (Location loc : this.brokenOriginalBlocks.keySet()) {
            if (!chunk.equals(loc.getChunk())) continue;
            return true;
        }
        return false;
    }
}

