/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.region;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.material.Bed;
import org.bukkit.material.Colorable;
import org.bukkit.material.Directional;
import org.bukkit.material.Door;
import org.bukkit.material.Lever;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Redstone;
import org.screamingsandals.bedwars.api.Region;
import org.screamingsandals.bedwars.region.LegacyBedUtils;

public class LegacyRegion
implements Region {
    private List<Location> builtBlocks = new ArrayList<Location>();
    private List<Block> brokenBlocks = new ArrayList<Block>();
    private HashMap<Block, Block> brokenBeds = new HashMap();
    private HashMap<Block, Byte> brokenBlockData = new HashMap();
    private HashMap<Block, BlockFace> brokenBlockFace = new HashMap();
    private HashMap<Block, Boolean> brokenBlockPower = new HashMap();
    private HashMap<Block, Material> brokenBlockTypes = new HashMap();
    private HashMap<Block, DyeColor> brokenBlockColors = new HashMap();

    @Override
    public boolean isBlockAddedDuringGame(Location loc) {
        return this.builtBlocks.contains(loc);
    }

    @Override
    public void putOriginalBlock(Location loc, BlockState block) {
        if (!block.getType().name().equals("BED_BLOCK")) {
            this.brokenBlocks.add(loc.getBlock());
        }
        if (block.getData() instanceof Directional) {
            this.brokenBlockFace.put(loc.getBlock(), ((Directional)block.getData()).getFacing());
        }
        this.brokenBlockTypes.put(loc.getBlock(), block.getType());
        this.brokenBlockData.put(loc.getBlock(), block.getData().getData());
        if (block.getData() instanceof Redstone) {
            this.brokenBlockPower.put(loc.getBlock(), ((Redstone)block.getData()).isPowered());
        }
        if (block instanceof Colorable) {
            this.brokenBlockColors.put(loc.getBlock(), ((Colorable)block).getColor());
        }
        if (this.isBedHead(block)) {
            this.brokenBeds.put(loc.getBlock(), this.getBedNeighbor(loc.getBlock()));
        }
    }

    @Override
    public void addBuiltDuringGame(Location loc) {
        this.builtBlocks.add(loc);
    }

    @Override
    public void removeBlockBuiltDuringGame(Location loc) {
        this.builtBlocks.remove(loc);
    }

    @Override
    public void regen() {
        Chunk chunk;
        for (Location location : this.builtBlocks) {
            chunk = location.getChunk();
            if (!chunk.isLoaded()) {
                chunk.load();
            }
            location.getBlock().setType(Material.AIR);
        }
        this.builtBlocks.clear();
        for (Block block : this.brokenBlocks) {
            MaterialData data;
            chunk = block.getChunk();
            if (!chunk.isLoaded()) {
                chunk.load();
            }
            block.setType(this.brokenBlockTypes.get(block));
            try {
                Block.class.getMethod("setData", Byte.TYPE).invoke((Object)block, this.brokenBlockData.get(block));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.brokenBlockFace.containsKey(block) && (data = block.getState().getData()) instanceof Directional) {
                ((Directional)data).setFacingDirection(this.brokenBlockFace.get(block));
                block.getState().setData(data);
            }
            if (block.getState().getData() instanceof Lever) {
                Lever attach = (Lever)block.getState().getData();
                BlockState supportState = block.getState();
                BlockState initalState = block.getState();
                attach.setPowered(this.brokenBlockPower.get(block).booleanValue());
                block.getState().setData((MaterialData)attach);
                supportState.setType(Material.AIR);
                supportState.update(true, false);
                initalState.update(true);
            } else {
                block.getState().update(true, true);
            }
            if (!this.brokenBlockColors.containsKey(block) || !(block.getState() instanceof Colorable)) continue;
            BlockState state = block.getState();
            ((Colorable)state).setColor(this.brokenBlockColors.get(block));
            state.update(true, false);
        }
        for (Map.Entry entry : this.brokenBeds.entrySet()) {
            Block blockHead = (Block)entry.getKey();
            Block blockFeed = (Block)entry.getValue();
            BlockState headState = blockHead.getState();
            BlockState feedState = blockFeed.getState();
            headState.setType(this.brokenBlockTypes.get(blockHead));
            feedState.setType(this.brokenBlockTypes.getOrDefault(blockFeed, this.brokenBlockTypes.get(blockHead)));
            headState.setRawData((byte)0);
            feedState.setRawData((byte)8);
            feedState.update(true, false);
            headState.update(true, false);
            Bed bedHead = (Bed)headState.getData();
            bedHead.setHeadOfBed(true);
            bedHead.setFacingDirection(blockHead.getFace(blockFeed).getOppositeFace());
            Bed bedFeed = (Bed)feedState.getData();
            bedFeed.setHeadOfBed(false);
            bedFeed.setFacingDirection(blockFeed.getFace(blockHead));
            feedState.update(true, false);
            headState.update(true, true);
            headState = blockHead.getState();
            feedState = blockFeed.getState();
            if (this.brokenBlockColors.containsKey(blockFeed) && feedState instanceof Colorable) {
                ((Colorable)feedState).setColor(this.brokenBlockColors.get(blockFeed));
                feedState.update(true, false);
            }
            if (!this.brokenBlockColors.containsKey(blockHead) || !(headState instanceof Colorable)) continue;
            ((Colorable)headState).setColor(this.brokenBlockColors.get(blockHead));
            headState.update(true, true);
        }
        this.brokenBeds.clear();
        this.brokenBlocks.clear();
        this.brokenBlockData.clear();
        this.brokenBlockFace.clear();
        this.brokenBlockPower.clear();
        this.brokenBlockTypes.clear();
        this.brokenBlockColors.clear();
    }

    @Override
    public boolean isLiquid(Material material) {
        return material == Material.valueOf((String)"WATER") || material == Material.valueOf((String)"LAVA") || material == Material.valueOf((String)"STATIONARY_LAVA") || material == Material.valueOf((String)"STATIONARY_WATER");
    }

    @Override
    public boolean isBedBlock(BlockState block) {
        return block.getData() instanceof Bed;
    }

    @Override
    public boolean isBedHead(BlockState block) {
        return this.isBedBlock(block) && ((Bed)block.getData()).isHeadOfBed();
    }

    @Override
    public boolean isDoorBlock(BlockState block) {
        return block.getData() instanceof Door;
    }

    @Override
    public boolean isDoorBottomBlock(BlockState block) {
        return block.getData() instanceof Door && !((Door)block.getData()).isTopHalf();
    }

    @Override
    public Block getBedNeighbor(Block head) {
        return LegacyBedUtils.getBedNeighbor(head);
    }

    @Override
    public boolean isChunkUsed(Chunk chunk) {
        if (chunk == null) {
            return false;
        }
        for (Location loc : this.builtBlocks) {
            if (!chunk.equals(loc.getChunk())) continue;
            return true;
        }
        for (Block block : this.brokenBlocks) {
            if (!chunk.equals(block.getChunk())) continue;
            return true;
        }
        return false;
    }
}

