/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.special.SpecialItem;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class ArrowBlocker
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.ArrowBlocker {
    private Game game;
    private Player player;
    private int protectionTime;
    private int usedTime;
    private boolean isActivated;
    private ItemStack item;

    public ArrowBlocker(Game game, Player player, Team team, ItemStack item, int protectionTime) {
        super(game, player, team);
        this.game = game;
        this.player = player;
        this.item = item;
        this.protectionTime = protectionTime;
    }

    @Override
    public int getProtectionTime() {
        return this.protectionTime;
    }

    @Override
    public int getUsedTime() {
        return this.usedTime;
    }

    @Override
    public boolean isActivated() {
        return this.isActivated;
    }

    @Override
    public void runTask() {
        new BukkitRunnable(){

            public void run() {
                ArrowBlocker.this.usedTime++;
                if (ArrowBlocker.this.usedTime == ArrowBlocker.this.protectionTime) {
                    ArrowBlocker.this.isActivated = false;
                    MiscUtils.sendActionBarMessage(ArrowBlocker.this.player, I18n.i18nonly("specials_arrow_blocker_ended"));
                    ArrowBlocker.this.game.unregisterSpecialItem(ArrowBlocker.this);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 20L);
    }

    public void activate() {
        if (this.protectionTime > 0) {
            this.game.registerSpecialItem(this);
            this.runTask();
            if (this.item.getAmount() > 1) {
                this.item.setAmount(this.item.getAmount() - 1);
            } else {
                try {
                    if (this.player.getInventory().getItemInOffHand().equals((Object)this.item)) {
                        this.player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                    } else {
                        this.player.getInventory().remove(this.item);
                    }
                }
                catch (Throwable e) {
                    this.player.getInventory().remove(this.item);
                }
            }
            this.player.updateInventory();
            MiscUtils.sendActionBarMessage(this.player, I18n.i18nonly("specials_arrow_blocker_started").replace("%time%", Integer.toString(this.protectionTime)));
        }
    }
}

