/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.special.SpecialItem;

public class AutoIgniteableTNT
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.AutoIgniteableTNT {
    private int explosionTime;
    private float damage;
    private boolean damagePlacer;

    public AutoIgniteableTNT(Game game, Player player, Team team, int explosionTime, boolean damagePlacer, float damage) {
        super(game, player, team);
        this.explosionTime = explosionTime;
        this.damagePlacer = damagePlacer;
        this.damage = damage;
    }

    @Override
    public int getExplosionTime() {
        return this.explosionTime;
    }

    @Override
    public boolean isAllowedDamagingPlacer() {
        return this.damagePlacer;
    }

    @Override
    public float getDamage() {
        return this.damage;
    }

    @Override
    public void spawn(Location location) {
        final TNTPrimed tnt = (TNTPrimed)location.getWorld().spawnEntity(location, EntityType.PRIMED_TNT);
        Main.getInstance().registerEntityToGame((Entity)tnt, this.game);
        tnt.setYield(this.damage);
        tnt.setFuseTicks(this.explosionTime * 20);
        if (!this.damagePlacer) {
            tnt.setMetadata(this.player.getUniqueId().toString(), (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), null));
        }
        tnt.setMetadata("autoignited", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), null));
        new BukkitRunnable(){

            public void run() {
                Main.getInstance().unregisterEntityFromGame((Entity)tnt);
            }
        }.runTaskLater((Plugin)Main.getInstance(), (long)(this.explosionTime + 10));
    }
}

