/*
 * Decompiled with CFR 0.152.
 */
package org.screamingsandals.bedwars.special;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.lib.lang.I18n;
import org.screamingsandals.bedwars.lib.nms.accessors.IronGolemAccessor;
import org.screamingsandals.bedwars.lib.nms.accessors.ServerPlayerAccessor;
import org.screamingsandals.bedwars.lib.nms.entity.EntityUtils;
import org.screamingsandals.bedwars.special.SpecialItem;
import org.screamingsandals.bedwars.utils.MiscUtils;

public class Golem
extends SpecialItem
implements org.screamingsandals.bedwars.api.special.Golem {
    private LivingEntity entity;
    private Location location;
    private ItemStack item;
    private double speed;
    private double followRange;
    private double health;
    private String name;
    private boolean showName;

    public Golem(Game game, Player player, Team team, ItemStack item, Location location, double speed, double followRange, double health, String name, boolean showName) {
        super(game, player, team);
        this.location = location;
        this.item = item;
        this.speed = speed;
        this.followRange = followRange;
        this.health = health;
        this.name = name;
        this.showName = showName;
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    @Override
    public double getFollowRange() {
        return this.followRange;
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void spawn() {
        TeamColor color = TeamColor.fromApiColor(this.team.getColor());
        IronGolem golem = (IronGolem)this.location.getWorld().spawnEntity(this.location, EntityType.IRON_GOLEM);
        golem.setHealth(this.health);
        golem.setCustomName(this.name.replace("%teamcolor%", color.chatColor.toString()).replace("%team%", this.team.getName()));
        golem.setCustomNameVisible(this.showName);
        try {
            golem.setInvulnerable(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.entity = golem;
        EntityUtils.makeMobAttackTarget2((LivingEntity)golem, this.speed, this.followRange, -1.0).getTargetSelector().hurtByTarget(1).attackNearestTarget(2, ServerPlayerAccessor.TYPE.get()).attackNearestTarget(3, IronGolemAccessor.TYPE.get());
        this.game.registerSpecialItem(this);
        Main.registerGameEntity((Entity)golem, (org.screamingsandals.bedwars.game.Game)this.game);
        if (!Main.getConfigurator().config.getBoolean("specials.dont-show-success-messages")) {
            MiscUtils.sendActionBarMessage(this.player, I18n.i18nonly("specials_golem_created"));
        }
        if (this.item.getAmount() > 1) {
            this.item.setAmount(this.item.getAmount() - 1);
        } else {
            try {
                if (this.player.getInventory().getItemInOffHand().equals((Object)this.item)) {
                    this.player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                } else {
                    this.player.getInventory().remove(this.item);
                }
            }
            catch (Throwable e) {
                this.player.getInventory().remove(this.item);
            }
        }
        this.player.updateInventory();
    }
}

